/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.bundle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.cel.bundle.CelEnvironment;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public final class CelEnvironmentYamlSerializer
extends Representer {
    private static final DumperOptions YAML_OPTIONS = CelEnvironmentYamlSerializer.initDumperOptions();
    private static final CelEnvironmentYamlSerializer INSTANCE = new CelEnvironmentYamlSerializer();

    private static DumperOptions initDumperOptions() {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return options;
    }

    private CelEnvironmentYamlSerializer() {
        super(YAML_OPTIONS);
        this.multiRepresenters.put(CelEnvironment.class, new RepresentCelEnvironment());
        this.multiRepresenters.put(CelEnvironment.VariableDecl.class, new RepresentVariableDecl());
        this.multiRepresenters.put(CelEnvironment.FunctionDecl.class, new RepresentFunctionDecl());
        this.multiRepresenters.put(CelEnvironment.OverloadDecl.class, new RepresentOverloadDecl());
        this.multiRepresenters.put(CelEnvironment.TypeDecl.class, new RepresentTypeDecl());
        this.multiRepresenters.put(CelEnvironment.ExtensionConfig.class, new RepresentExtensionConfig());
    }

    public static String toYaml(CelEnvironment environment) {
        Yaml yaml = new Yaml(INSTANCE, YAML_OPTIONS);
        return yaml.dump(environment);
    }

    private final class RepresentCelEnvironment
    implements Represent {
        private RepresentCelEnvironment() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment environment = (CelEnvironment)data;
            ImmutableMap.Builder<String, Object> configMap = new ImmutableMap.Builder<String, Object>();
            configMap.put("name", environment.name());
            if (!environment.description().isEmpty()) {
                configMap.put("description", environment.description());
            }
            if (!environment.container().isEmpty()) {
                configMap.put("container", environment.container());
            }
            if (!environment.extensions().isEmpty()) {
                configMap.put("extensions", environment.extensions().asList());
            }
            if (!environment.variables().isEmpty()) {
                configMap.put("variables", environment.variables().asList());
            }
            if (!environment.functions().isEmpty()) {
                configMap.put("functions", environment.functions().asList());
            }
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }

    private final class RepresentVariableDecl
    implements Represent {
        private RepresentVariableDecl() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment.VariableDecl variable = (CelEnvironment.VariableDecl)data;
            ImmutableMap.Builder<String, Object> configMap = new ImmutableMap.Builder<String, Object>();
            configMap.put("name", variable.name()).put("type_name", variable.type().name());
            if (!variable.type().params().isEmpty()) {
                configMap.put("params", variable.type().params());
            }
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }

    private final class RepresentFunctionDecl
    implements Represent {
        private RepresentFunctionDecl() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment.FunctionDecl function = (CelEnvironment.FunctionDecl)data;
            ImmutableMap.Builder<String, String> configMap = new ImmutableMap.Builder<String, String>();
            configMap.put("name", function.name()).put("overloads", (String)((Object)function.overloads().asList()));
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }

    private final class RepresentOverloadDecl
    implements Represent {
        private RepresentOverloadDecl() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment.OverloadDecl overload = (CelEnvironment.OverloadDecl)data;
            ImmutableMap.Builder<String, Object> configMap = new ImmutableMap.Builder<String, Object>();
            configMap.put("id", overload.id());
            if (overload.target().isPresent()) {
                configMap.put("target", overload.target().get());
            }
            configMap.put("args", overload.arguments()).put("return", (ImmutableList<CelEnvironment.TypeDecl>)((Object)overload.returnType()));
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }

    private final class RepresentTypeDecl
    implements Represent {
        private RepresentTypeDecl() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment.TypeDecl type = (CelEnvironment.TypeDecl)data;
            ImmutableMap.Builder<String, Object> configMap = new ImmutableMap.Builder<String, Object>();
            configMap.put("type_name", type.name());
            if (!type.params().isEmpty()) {
                configMap.put("params", type.params());
            }
            if (type.isTypeParam()) {
                configMap.put("is_type_param", type.isTypeParam());
            }
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }

    private final class RepresentExtensionConfig
    implements Represent {
        private RepresentExtensionConfig() {
        }

        @Override
        public Node representData(Object data) {
            CelEnvironment.ExtensionConfig extension = (CelEnvironment.ExtensionConfig)data;
            ImmutableMap.Builder<String, Object> configMap = new ImmutableMap.Builder<String, Object>();
            configMap.put("name", extension.name());
            if (extension.version() > 0 && extension.version() != Integer.MAX_VALUE) {
                configMap.put("version", extension.version());
            }
            return CelEnvironmentYamlSerializer.this.represent(configMap.buildOrThrow());
        }
    }
}

