/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.checker.AutoValue_DescriptorTypeProvider_EnumValueDef;
import dev.cel.checker.AutoValue_DescriptorTypeProvider_FieldDef;
import dev.cel.checker.AutoValue_DescriptorTypeProvider_MapEntryDef;
import dev.cel.checker.AutoValue_DescriptorTypeProvider_TypeDef;
import dev.cel.checker.TypeProvider;
import dev.cel.checker.Types;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.FileDescriptorSetConverter;
import dev.cel.expr.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Immutable
@Internal
public class DescriptorTypeProvider
implements TypeProvider {
    private final SymbolTable symbolTable;

    public DescriptorTypeProvider() {
        this((Collection<Descriptors.FileDescriptor>)new ArrayList<Descriptors.FileDescriptor>());
    }

    public DescriptorTypeProvider(DescriptorProtos.FileDescriptorSet descriptorSet) {
        this((Collection<Descriptors.FileDescriptor>)FileDescriptorSetConverter.convert(descriptorSet));
    }

    public DescriptorTypeProvider(Collection<Descriptors.FileDescriptor> fileDescriptors) {
        this.symbolTable = new SymbolTable((Iterable<Descriptors.FileDescriptor>)ImmutableList.copyOf(fileDescriptors));
    }

    public DescriptorTypeProvider(Iterable<Descriptors.Descriptor> descriptors) {
        this.symbolTable = new SymbolTable((List<Descriptors.Descriptor>)ImmutableList.copyOf(descriptors));
    }

    @Override
    public @Nullable Type lookupType(String typeName) {
        TypeDef typeDef = this.lookupMessageTypeDef(typeName);
        return typeDef != null ? Types.create(Types.createMessage(typeDef.name())) : null;
    }

    @Override
    public @Nullable Integer lookupEnumValue(String enumName) {
        int dot = enumName.lastIndexOf(46);
        if (dot > 0) {
            EnumValueDef enumValueDef;
            String enumTypeName = enumName.substring(0, dot);
            String enumValueName = enumName.substring(dot + 1);
            TypeDef typeDef = this.symbolTable.lookupTypeDef(enumTypeName);
            if (typeDef != null && typeDef.isEnum() && (enumValueDef = typeDef.findEnumValue(enumValueName)) != null) {
                return enumValueDef.value();
            }
        }
        return null;
    }

    @Override
    public @Nullable TypeProvider.FieldType lookupFieldType(Type type, String fieldName) {
        TypeDef messageTypeDef = this.lookupMessageTypeDef(type.getMessageType());
        if (messageTypeDef == null) {
            return null;
        }
        FieldDef fieldDef = messageTypeDef.lookupField(fieldName);
        if (fieldDef == null) {
            return null;
        }
        return TypeProvider.FieldType.of(DescriptorTypeProvider.fieldDefToType(fieldDef));
    }

    @Override
    public @Nullable ImmutableSet<String> lookupFieldNames(Type type) {
        if (type.getTypeKindCase() != Type.TypeKindCase.MESSAGE_TYPE) {
            return null;
        }
        TypeDef messageTypeDef = this.lookupMessageTypeDef(type.getMessageType());
        if (messageTypeDef == null) {
            return null;
        }
        ImmutableSet.Builder fields = ImmutableSet.builder();
        for (FieldDef fieldDef : messageTypeDef.fields()) {
            fields.add(fieldDef.name());
        }
        return fields.build();
    }

    @Override
    public @Nullable TypeProvider.ExtensionFieldType lookupExtensionType(String extensionName) {
        return this.symbolTable.lookupExtension(extensionName);
    }

    private @Nullable TypeDef lookupMessageTypeDef(String typeName) {
        TypeDef typeDef = this.symbolTable.lookupTypeDef(typeName);
        return typeDef != null && typeDef.isMessage() ? typeDef : null;
    }

    private static Type fieldDefToType(FieldDef fieldDef) {
        if (fieldDef.isMap()) {
            return Types.createMap(DescriptorTypeProvider.typeDefToType(fieldDef.mapEntryType().keyType()), DescriptorTypeProvider.typeDefToType(fieldDef.mapEntryType().valueType()));
        }
        if (fieldDef.repeated()) {
            return Types.createList(DescriptorTypeProvider.typeDefToType(fieldDef.type()));
        }
        return DescriptorTypeProvider.typeDefToType(fieldDef.type());
    }

    private static Type typeDefToType(TypeDef typeDef) {
        if (typeDef.isMessage()) {
            if (Types.WELL_KNOWN_TYPE_MAP.containsKey(typeDef.name())) {
                return Types.WELL_KNOWN_TYPE_MAP.get(typeDef.name());
            }
            return Types.createMessage(typeDef.name());
        }
        if (Types.PRIMITIVE_TYPE_MAP.containsKey(typeDef.protoType())) {
            return Types.PRIMITIVE_TYPE_MAP.get(typeDef.protoType());
        }
        if (typeDef.isEnum()) {
            return Types.INT64;
        }
        throw new IllegalArgumentException("unexpected typeDef: " + typeDef);
    }

    @AutoValue
    protected static abstract class FieldDef {
        protected FieldDef() {
        }

        public abstract String name();

        public abstract @Nullable TypeDef type();

        public abstract @Nullable MapEntryDef mapEntryType();

        public abstract boolean repeated();

        public boolean isMap() {
            return this.mapEntryType() != null;
        }

        public final boolean equals(Object other) {
            return other instanceof FieldDef && ((FieldDef)other).name().equals(this.name());
        }

        public final int hashCode() {
            return this.name().hashCode();
        }

        public final String toString() {
            return String.format("%s %s;", this.isMap() ? this.mapEntryType().toString() : (this.repeated() ? "repeated " + this.type().name() : this.type().name()), this.name());
        }

        static FieldDef of(String name, TypeDef type, boolean repeated) {
            return new AutoValue_DescriptorTypeProvider_FieldDef(name, type, null, repeated);
        }

        static FieldDef of(String name, MapEntryDef mapEntryType) {
            return new AutoValue_DescriptorTypeProvider_FieldDef(name, null, mapEntryType, true);
        }
    }

    protected static class SymbolTable {
        private final ImmutableMap<String, TypeDef> typeMap;
        private final ImmutableMap<String, TypeProvider.ExtensionFieldType> extensionMap;

        public SymbolTable(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            HashSet<String> processedFiles = new HashSet<String>();
            HashMap<String, TypeDef> typeMap = new HashMap<String, TypeDef>();
            HashMap<String, TypeProvider.ExtensionFieldType> extensionMap = new HashMap<String, TypeProvider.ExtensionFieldType>();
            for (Descriptors.FileDescriptor fileDescriptor : fileDescriptors) {
                if (!processedFiles.add(fileDescriptor.getFullName())) continue;
                for (Descriptors.Descriptor messageDescriptor : fileDescriptor.getMessageTypes()) {
                    this.buildTypeDef(messageDescriptor, typeMap);
                }
                for (Descriptors.EnumDescriptor enumDescriptor : fileDescriptor.getEnumTypes()) {
                    this.buildTypeDef(enumDescriptor, typeMap);
                }
                for (Descriptors.FieldDescriptor extensionDescriptor : fileDescriptor.getExtensions()) {
                    FieldDef field = this.buildFieldDef(extensionDescriptor, typeMap);
                    if (field == null) continue;
                    extensionMap.put(extensionDescriptor.getFullName(), TypeProvider.ExtensionFieldType.of(DescriptorTypeProvider.fieldDefToType(field), Types.createMessage(extensionDescriptor.getContainingType().getFullName())));
                }
            }
            this.typeMap = ImmutableMap.copyOf(typeMap);
            this.extensionMap = ImmutableMap.copyOf(extensionMap);
        }

        public SymbolTable(List<Descriptors.Descriptor> descriptors) {
            this(Iterables.transform(descriptors, Descriptors.Descriptor::getFile));
        }

        private @Nullable TypeDef lookupTypeDef(String typeName) {
            typeName = typeName.startsWith(".") ? typeName.substring(1) : typeName;
            return this.typeMap.get(typeName);
        }

        private @Nullable TypeProvider.ExtensionFieldType lookupExtension(String extensionName) {
            extensionName = extensionName.startsWith(".") ? extensionName.substring(1) : extensionName;
            return this.extensionMap.get(extensionName);
        }

        @CanIgnoreReturnValue
        private TypeDef buildTypeDef(Descriptors.Descriptor descriptor, Map<String, TypeDef> typeMap) {
            String typeName = descriptor.getFullName();
            if (typeMap.containsKey(typeName)) {
                return typeMap.get(typeName);
            }
            HashSet<FieldDef> fields = new HashSet<FieldDef>();
            TypeDef typeDef = TypeDef.ofMessage(typeName, fields);
            typeMap.put(typeName, typeDef);
            for (Descriptors.EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
                this.buildTypeDef(enumDescriptor, typeMap);
            }
            for (Descriptors.Descriptor nested : descriptor.getNestedTypes()) {
                this.buildTypeDef(nested, typeMap);
            }
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                FieldDef field = this.buildFieldDef(fieldDescriptor, typeMap);
                if (field == null) continue;
                fields.add(field);
            }
            for (Descriptors.OneofDescriptor oneof : descriptor.getOneofs()) {
                for (Descriptors.FieldDescriptor oneofFieldDescriptor : oneof.getFields()) {
                    FieldDef field = this.buildFieldDef(oneofFieldDescriptor, typeMap);
                    if (field == null) continue;
                    fields.add(field);
                }
            }
            return typeDef;
        }

        @CanIgnoreReturnValue
        private TypeDef buildTypeDef(Descriptors.EnumDescriptor descriptor, Map<String, TypeDef> typeMap) {
            String typeName = descriptor.getFullName();
            if (typeMap.containsKey(typeName)) {
                return typeMap.get(typeName);
            }
            HashSet<EnumValueDef> enumValues = new HashSet<EnumValueDef>();
            TypeDef typeDef = TypeDef.ofEnum(typeName, enumValues);
            typeMap.put(typeName, typeDef);
            for (Descriptors.EnumValueDescriptor enumValue : descriptor.getValues()) {
                enumValues.add(EnumValueDef.of(enumValue.getName(), enumValue.getNumber()));
            }
            return typeDef;
        }

        private @Nullable FieldDef buildFieldDef(Descriptors.FieldDescriptor fieldDescriptor, Map<String, TypeDef> typeMap) {
            String fieldName = fieldDescriptor.getName();
            boolean repeated = fieldDescriptor.isRepeated();
            switch (fieldDescriptor.getType()) {
                case GROUP: 
                case MESSAGE: {
                    if (fieldDescriptor.isMapField()) {
                        FieldDef keyField = this.buildFieldDef(fieldDescriptor.getMessageType().getFields().get(0), typeMap);
                        FieldDef valueField = this.buildFieldDef(fieldDescriptor.getMessageType().getFields().get(1), typeMap);
                        if (keyField != null && valueField != null) {
                            return FieldDef.of(fieldName, MapEntryDef.of(keyField.type(), valueField.type()));
                        }
                        return null;
                    }
                    TypeDef messageDef = this.buildTypeDef(fieldDescriptor.getMessageType(), typeMap);
                    return FieldDef.of(fieldName, messageDef, repeated);
                }
                case ENUM: {
                    TypeDef enumDef = this.buildTypeDef(fieldDescriptor.getEnumType(), typeMap);
                    return FieldDef.of(fieldName, enumDef, repeated);
                }
                case DOUBLE: 
                case FLOAT: 
                case FIXED32: 
                case FIXED64: 
                case INT32: 
                case INT64: 
                case SINT32: 
                case SINT64: 
                case SFIXED32: 
                case SFIXED64: 
                case UINT32: 
                case UINT64: 
                case BOOL: 
                case STRING: 
                case BYTES: {
                    TypeDef primitiveDef = TypeDef.of(fieldDescriptor.toProto().getType());
                    return FieldDef.of(fieldName, primitiveDef, repeated);
                }
            }
            return null;
        }
    }

    @AutoValue
    protected static abstract class TypeDef {
        protected TypeDef() {
        }

        public abstract String name();

        public abstract DescriptorProtos.FieldDescriptorProto.Type protoType();

        public abstract @Nullable Iterable<FieldDef> fields();

        public abstract @Nullable Iterable<EnumValueDef> enumValues();

        public boolean isEnum() {
            return this.enumValues() != null;
        }

        public boolean isMessage() {
            return this.fields() != null;
        }

        public @Nullable FieldDef lookupField(String name) {
            for (FieldDef field : this.fields()) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public @Nullable EnumValueDef findEnumValue(String name) {
            for (EnumValueDef enumValue : this.enumValues()) {
                if (!enumValue.name().equals(name)) continue;
                return enumValue;
            }
            return null;
        }

        public final boolean equals(Object other) {
            return other instanceof TypeDef && ((TypeDef)other).name().equals(this.name());
        }

        public final int hashCode() {
            return this.name().hashCode();
        }

        public final String toString() {
            Joiner joiner = Joiner.on("\n");
            return String.format("%s {\n%s\n}", this.name(), this.isMessage() ? joiner.join(this.fields()) : (this.isEnum() ? joiner.join(this.enumValues()) : Ascii.toLowerCase(this.protoType().name())));
        }

        public static TypeDef of(DescriptorProtos.FieldDescriptorProto.Type protoType) {
            return new AutoValue_DescriptorTypeProvider_TypeDef(Ascii.toLowerCase(protoType.name()), protoType, null, null);
        }

        static TypeDef ofMessage(String name, Iterable<FieldDef> fields) {
            return new AutoValue_DescriptorTypeProvider_TypeDef(name, DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, fields, null);
        }

        static TypeDef ofEnum(String name, Iterable<EnumValueDef> enumValues) {
            return new AutoValue_DescriptorTypeProvider_TypeDef(name, DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, null, enumValues);
        }
    }

    @AutoValue
    protected static abstract class EnumValueDef {
        protected EnumValueDef() {
        }

        public abstract String name();

        public abstract int value();

        public final String toString() {
            return String.format("%s = %d", Ascii.toUpperCase(this.name()), this.value());
        }

        static EnumValueDef of(String name, int value) {
            return new AutoValue_DescriptorTypeProvider_EnumValueDef(name, value);
        }
    }

    @AutoValue
    protected static abstract class MapEntryDef {
        protected MapEntryDef() {
        }

        public abstract TypeDef keyType();

        public abstract TypeDef valueType();

        public final String toString() {
            return String.format("map<%s, %s>", this.keyType().name(), this.valueType().name());
        }

        static MapEntryDef of(TypeDef keyType, TypeDef valueType) {
            return new AutoValue_DescriptorTypeProvider_MapEntryDef(keyType, valueType);
        }
    }
}

