/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import dev.cel.common.annotations.Internal;
import dev.cel.expr.Constant;
import dev.cel.expr.Expr;

@Internal
public abstract class ExprVisitor {
    protected ExprVisitor() {
    }

    public void visit(Expr expr) {
        switch (expr.getExprKindCase()) {
            case CONST_EXPR: {
                this.visit(expr, expr.getConstExpr());
                break;
            }
            case IDENT_EXPR: {
                this.visit(expr, expr.getIdentExpr());
                break;
            }
            case SELECT_EXPR: {
                this.visit(expr, expr.getSelectExpr());
                break;
            }
            case CALL_EXPR: {
                this.visit(expr, expr.getCallExpr());
                break;
            }
            case LIST_EXPR: {
                this.visit(expr, expr.getListExpr());
                break;
            }
            case STRUCT_EXPR: {
                this.visit(expr, expr.getStructExpr());
                break;
            }
            case COMPREHENSION_EXPR: {
                this.visit(expr, expr.getComprehensionExpr());
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected expr kind");
            }
        }
    }

    protected void visit(Expr expr, Expr.Ident ident) {
    }

    protected void visit(Expr expr, Constant constant) {
    }

    protected void visit(Expr expr, Expr.Select select) {
        this.visit(select.getOperand());
    }

    protected void visit(Expr expr, Expr.Call call) {
        if (call.hasTarget()) {
            this.visit(call.getTarget());
        }
        for (int i = 0; i < call.getArgsCount(); ++i) {
            Expr arg = call.getArgs(i);
            this.visit(arg);
            this.visitArg(expr, arg, i);
        }
    }

    protected void visit(Expr expr, Expr.CreateStruct createStruct) {
        for (Expr.CreateStruct.Entry entry : createStruct.getEntriesList()) {
            if (entry.getKeyKindCase() == Expr.CreateStruct.Entry.KeyKindCase.MAP_KEY) {
                this.visit(entry.getMapKey());
            }
            this.visit(entry.getValue());
        }
    }

    protected void visit(Expr expr, Expr.CreateList createList) {
        for (Expr elem : createList.getElementsList()) {
            this.visit(elem);
        }
    }

    protected void visit(Expr expr, Expr.Comprehension comprehension) {
        this.visit(comprehension.getIterRange());
        this.visitArg(expr, comprehension.getIterRange(), ComprehensionArg.ITER_RANGE.ordinal());
        this.visit(comprehension.getAccuInit());
        this.visitArg(expr, comprehension.getAccuInit(), ComprehensionArg.ACCU_INIT.ordinal());
        this.visit(comprehension.getLoopCondition());
        this.visitArg(expr, comprehension.getLoopCondition(), ComprehensionArg.LOOP_CONDIITON.ordinal());
        this.visit(comprehension.getLoopStep());
        this.visitArg(expr, comprehension.getLoopStep(), ComprehensionArg.LOOP_STEP.ordinal());
        this.visit(comprehension.getResult());
        this.visitArg(expr, comprehension.getResult(), ComprehensionArg.RESULT.ordinal());
    }

    protected void visitArg(Expr expr, Expr arg, int argNum) {
    }

    public static enum ComprehensionArg {
        ITER_RANGE,
        ACCU_INIT,
        LOOP_CONDIITON,
        LOOP_STEP,
        RESULT;

    }
}

