/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.checker.Types;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelType;
import dev.cel.common.types.TypeParamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Internal
public class InferenceContext {
    private Map<CelType, CelType> substitution = new HashMap<CelType, CelType>();
    private int freeTypeVarCounter;

    public CelType newTypeVar(String prefix) {
        String separator = !prefix.isEmpty() && Character.isDigit(prefix.charAt(prefix.length() - 1)) ? "%" : "";
        return TypeParamType.create("%" + prefix + separator + this.freeTypeVarCounter++);
    }

    public CelType newInstance(Iterable<String> typeParams, CelType type) {
        HashMap<CelType, CelType> subs = new HashMap<CelType, CelType>();
        for (String typeParam : typeParams) {
            subs.put(TypeParamType.create(typeParam), this.newTypeVar(typeParam));
        }
        return Types.substitute(subs, type, false);
    }

    @CanIgnoreReturnValue
    public boolean isAssignable(CelType type1, CelType type2) {
        Map<CelType, CelType> newSubs = Types.isAssignable(this.substitution, type1, type2);
        if (newSubs != null) {
            this.substitution = newSubs;
            return true;
        }
        return false;
    }

    public boolean isAssignable(List<CelType> list1, List<CelType> list2) {
        Map<CelType, CelType> newSubs = Types.isAssignable(this.substitution, list1, list2);
        if (newSubs != null) {
            this.substitution = newSubs;
            return true;
        }
        return false;
    }

    public CelType specialize(CelType type) {
        return Types.substitute(this.substitution, type, false);
    }

    public List<CelType> specialize(List<CelType> types) {
        ArrayList<CelType> result = new ArrayList<CelType>();
        for (CelType type : types) {
            result.add(this.specialize(type));
        }
        return result;
    }

    public CelType finalize(CelType type) {
        return Types.substitute(this.substitution, type, true);
    }
}

