/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelMutableSource;
import dev.cel.common.ast.CelMutableExpr;
import dev.cel.common.ast.CelMutableExprConverter;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class CelMutableAst {
    private final CelMutableExpr mutatedExpr;
    private final CelMutableSource source;
    private final Map<Long, CelReference> references;
    private final Map<Long, CelType> types;

    public CelMutableExpr expr() {
        return this.mutatedExpr;
    }

    public CelMutableSource source() {
        return this.source;
    }

    public Optional<CelReference> getReference(long exprId) {
        return Optional.ofNullable(this.references.get(exprId));
    }

    public Optional<CelType> getType(long exprId) {
        return Optional.ofNullable(this.types.get(exprId));
    }

    public CelAbstractSyntaxTree toParsedAst() {
        return CelAbstractSyntaxTree.newParsedAst(CelMutableExprConverter.fromMutableExpr(this.mutatedExpr), this.source.toCelSource());
    }

    public static CelMutableAst fromCelAst(CelAbstractSyntaxTree ast) {
        return new CelMutableAst(CelMutableExprConverter.fromCelExpr(ast.getExpr()), CelMutableSource.fromCelSource(ast.getSource()), ast.getReferenceMap(), ast.getTypeMap());
    }

    public static CelMutableAst of(CelMutableExpr mutableExpr, CelMutableSource mutableSource) {
        return new CelMutableAst(mutableExpr, mutableSource);
    }

    private CelMutableAst(CelMutableExpr mutatedExpr, CelMutableSource mutableSource) {
        this(mutatedExpr, mutableSource, new HashMap<Long, CelReference>(), new HashMap<Long, CelType>());
    }

    private CelMutableAst(CelMutableExpr mutatedExpr, CelMutableSource mutableSource, Map<Long, CelReference> references, Map<Long, CelType> types) {
        this.mutatedExpr = mutatedExpr;
        this.source = mutableSource;
        this.references = new HashMap<Long, CelReference>(references);
        this.types = new HashMap<Long, CelType>(types);
    }
}

