/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelOptions;
import dev.cel.common.annotations.Beta;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class CelOptions {
    public static final CelOptions DEFAULT = CelOptions.current().build();
    public static final CelOptions LEGACY = CelOptions.newBuilder().disableCelStandardEquality(true).build();

    CelOptions() {
    }

    public abstract boolean enableReservedIds();

    public abstract boolean enableOptionalSyntax();

    public abstract int maxExpressionCodePointSize();

    public abstract int maxParseErrorRecoveryLimit();

    public abstract int maxParseRecursionDepth();

    public abstract boolean populateMacroCalls();

    public abstract boolean retainRepeatedUnaryOperators();

    public abstract boolean retainUnbalancedLogicalExpressions();

    public abstract boolean enableHiddenAccumulatorVar();

    public abstract boolean enableQuotedIdentifierSyntax();

    public abstract boolean enableCompileTimeOverloadResolution();

    public abstract boolean enableHomogeneousLiterals();

    public abstract boolean enableTimestampEpoch();

    public abstract boolean enableHeterogeneousNumericComparisons();

    public abstract boolean enableNamespacedDeclarations();

    public abstract boolean disableCelStandardEquality();

    public abstract boolean enableShortCircuiting();

    public abstract boolean enableRegexPartialMatch();

    public abstract boolean enableUnsignedComparisonAndArithmeticIsUnsigned();

    public abstract boolean enableUnsignedLongs();

    public abstract boolean enableProtoDifferencerEquality();

    public abstract boolean errorOnDuplicateMapKeys();

    public abstract boolean errorOnIntWrap();

    public abstract boolean resolveTypeDependencies();

    public abstract boolean enableUnknownTracking();

    public abstract boolean enableCelValue();

    public abstract int comprehensionMaxIterations();

    public abstract boolean unwrapWellKnownTypesOnFunctionDispatch();

    public abstract ProtoUnsetFieldOptions fromProtoUnsetFieldOption();

    public abstract boolean enableStringConversion();

    public abstract boolean enableStringConcatenation();

    public abstract boolean enableListConcatenation();

    public abstract boolean enableComprehension();

    public abstract int maxRegexProgramSize();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_CelOptions.Builder().enableReservedIds(false).enableOptionalSyntax(false).maxExpressionCodePointSize(100000).maxParseErrorRecoveryLimit(30).maxParseRecursionDepth(250).populateMacroCalls(false).retainRepeatedUnaryOperators(false).retainUnbalancedLogicalExpressions(false).enableHiddenAccumulatorVar(true).enableQuotedIdentifierSyntax(false).enableCompileTimeOverloadResolution(false).enableHomogeneousLiterals(false).enableTimestampEpoch(false).enableHeterogeneousNumericComparisons(false).enableNamespacedDeclarations(true).disableCelStandardEquality(true).enableShortCircuiting(true).enableRegexPartialMatch(false).enableUnsignedComparisonAndArithmeticIsUnsigned(false).enableUnsignedLongs(false).enableProtoDifferencerEquality(false).errorOnIntWrap(false).errorOnDuplicateMapKeys(false).resolveTypeDependencies(true).enableUnknownTracking(false).enableCelValue(false).comprehensionMaxIterations(-1).unwrapWellKnownTypesOnFunctionDispatch(true).fromProtoUnsetFieldOption(ProtoUnsetFieldOptions.BIND_DEFAULT).enableStringConversion(true).enableStringConcatenation(true).enableListConcatenation(true).enableComprehension(true).maxRegexProgramSize(-1);
    }

    public static Builder current() {
        return CelOptions.newBuilder().enableReservedIds(true).enableUnsignedComparisonAndArithmeticIsUnsigned(true).enableUnsignedLongs(true).enableRegexPartialMatch(true).errorOnDuplicateMapKeys(true).errorOnIntWrap(true).resolveTypeDependencies(true).disableCelStandardEquality(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder enableReservedIds(boolean var1);

        public abstract Builder enableOptionalSyntax(boolean var1);

        public abstract Builder maxExpressionCodePointSize(int var1);

        public abstract Builder maxParseErrorRecoveryLimit(int var1);

        public abstract Builder maxParseRecursionDepth(int var1);

        public abstract Builder populateMacroCalls(boolean var1);

        public abstract Builder retainRepeatedUnaryOperators(boolean var1);

        public abstract Builder retainUnbalancedLogicalExpressions(boolean var1);

        public abstract Builder enableHiddenAccumulatorVar(boolean var1);

        public abstract Builder enableQuotedIdentifierSyntax(boolean var1);

        public abstract Builder enableCompileTimeOverloadResolution(boolean var1);

        @Deprecated
        public abstract Builder enableHomogeneousLiterals(boolean var1);

        public abstract Builder enableTimestampEpoch(boolean var1);

        public abstract Builder enableHeterogeneousNumericComparisons(boolean var1);

        @Deprecated
        public abstract Builder enableNamespacedDeclarations(boolean var1);

        public abstract Builder disableCelStandardEquality(boolean var1);

        public abstract Builder enableShortCircuiting(boolean var1);

        public abstract Builder enableRegexPartialMatch(boolean var1);

        public abstract Builder enableUnsignedComparisonAndArithmeticIsUnsigned(boolean var1);

        @Deprecated
        public abstract Builder enableUnsignedLongs(boolean var1);

        public abstract Builder enableProtoDifferencerEquality(boolean var1);

        public abstract Builder errorOnDuplicateMapKeys(boolean var1);

        public abstract Builder errorOnIntWrap(boolean var1);

        public abstract Builder resolveTypeDependencies(boolean var1);

        public abstract Builder enableUnknownTracking(boolean var1);

        @Beta
        public abstract Builder enableCelValue(boolean var1);

        public abstract Builder comprehensionMaxIterations(int var1);

        @Deprecated
        public abstract Builder unwrapWellKnownTypesOnFunctionDispatch(boolean var1);

        public abstract Builder fromProtoUnsetFieldOption(ProtoUnsetFieldOptions var1);

        public abstract Builder enableStringConversion(boolean var1);

        public abstract Builder enableStringConcatenation(boolean var1);

        public abstract Builder enableListConcatenation(boolean var1);

        public abstract Builder enableComprehension(boolean var1);

        public abstract Builder maxRegexProgramSize(int var1);

        public abstract CelOptions build();
    }

    public static enum ProtoUnsetFieldOptions {
        SKIP,
        BIND_DEFAULT;

    }
}

