/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelSource;
import dev.cel.common.AutoValue_CelSource_Extension;
import dev.cel.common.AutoValue_CelSource_Extension_Version;
import dev.cel.common.CelSourceHelper;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.Source;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.CelCodePointArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class CelSource
implements Source {
    abstract CelCodePointArray codePoints();

    abstract String description();

    abstract ImmutableList<Integer> lineOffsets();

    abstract ImmutableMap<Long, Integer> positions();

    abstract ImmutableMap<Long, CelExpr> macroCalls();

    abstract ImmutableSet<Extension> extensions();

    @Override
    public CelCodePointArray getContent() {
        return this.codePoints();
    }

    @Override
    public String getDescription() {
        return this.description();
    }

    @Override
    public ImmutableMap<Long, Integer> getPositionsMap() {
        return this.positions();
    }

    public ImmutableList<Integer> getLineOffsets() {
        return this.lineOffsets();
    }

    public ImmutableMap<Long, CelExpr> getMacroCalls() {
        return this.macroCalls();
    }

    public ImmutableSet<Extension> getExtensions() {
        return this.extensions();
    }

    public Optional<Integer> getLocationOffset(CelSourceLocation location) {
        Preconditions.checkNotNull(location);
        return this.getLocationOffset(location.getLine(), location.getColumn());
    }

    public Optional<Integer> getLocationOffset(int line, int column) {
        return CelSource.getLocationOffsetImpl(this.lineOffsets(), line, column);
    }

    public Optional<CelSourceLocation> getOffsetLocation(int offset) {
        return CelSourceHelper.getOffsetLocation(this.codePoints(), offset);
    }

    @Override
    public Optional<String> getSnippet(int line) {
        return CelSourceHelper.getSnippet(this.codePoints(), line);
    }

    private static Optional<Integer> getLocationOffsetImpl(List<Integer> lineOffsets, int line, int column) {
        if (line <= 0 || column < 0) {
            return Optional.empty();
        }
        int offset = CelSourceHelper.findLineOffset(lineOffsets, line);
        if (offset == -1) {
            return Optional.empty();
        }
        return Optional.of(offset + column);
    }

    public Builder toBuilder() {
        return new Builder(this.codePoints(), this.lineOffsets()).setDescription(this.description()).addPositionsMap(this.positions()).addAllExtensions(this.extensions()).addAllMacroCalls(this.macroCalls());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String text) {
        return CelSource.newBuilder(CelCodePointArray.fromString(text));
    }

    public static Builder newBuilder(CelCodePointArray codePointArray) {
        return new Builder(codePointArray, codePointArray.lineOffsets());
    }

    public static final class Builder {
        private final CelCodePointArray codePoints;
        private final List<Integer> lineOffsets;
        private final Map<Long, Integer> positions;
        private final Map<Long, CelExpr> macroCalls;
        private final ImmutableSet.Builder<Extension> extensions;
        private final boolean lineOffsetsAlreadyComputed;
        private String description;

        private Builder() {
            this(CelCodePointArray.fromString(""), new ArrayList<Integer>());
        }

        private Builder(CelCodePointArray codePoints, List<Integer> lineOffsets) {
            this.codePoints = Preconditions.checkNotNull(codePoints);
            this.lineOffsets = Preconditions.checkNotNull(lineOffsets);
            this.positions = new HashMap<Long, Integer>();
            this.macroCalls = new HashMap<Long, CelExpr>();
            this.extensions = ImmutableSet.builder();
            this.description = "";
            this.lineOffsetsAlreadyComputed = !lineOffsets.isEmpty();
        }

        @CanIgnoreReturnValue
        public Builder setDescription(String description) {
            this.description = Preconditions.checkNotNull(description);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLineOffsets(int lineOffset) {
            Preconditions.checkArgument(lineOffset >= 0);
            Preconditions.checkState(!this.lineOffsetsAlreadyComputed, "Line offsets were already been computed through the provided code points.");
            this.lineOffsets.add(lineOffset);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllLineOffsets(Iterable<Integer> lineOffsets) {
            for (int lineOffset : lineOffsets) {
                this.addLineOffsets(lineOffset);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPositionsMap(Map<Long, Integer> positionsMap) {
            Preconditions.checkNotNull(positionsMap);
            this.positions.putAll(positionsMap);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPositions(long exprId, int position) {
            this.positions.put(exprId, position);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removePositions(long exprId) {
            this.positions.remove(exprId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addMacroCalls(long exprId, CelExpr expr) {
            this.macroCalls.put(exprId, expr);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllMacroCalls(Map<Long, CelExpr> macroCalls) {
            this.macroCalls.putAll(macroCalls);
            return this;
        }

        public ImmutableSet<Extension> getExtensions() {
            return this.extensions.build();
        }

        @CanIgnoreReturnValue
        public Builder addAllExtensions(Iterable<? extends Extension> extensions) {
            Preconditions.checkNotNull(extensions);
            this.extensions.addAll(extensions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllExtensions(Extension ... extensions) {
            return this.addAllExtensions(Arrays.asList(extensions));
        }

        public Optional<Integer> getLocationOffset(CelSourceLocation location) {
            Preconditions.checkNotNull(location);
            return this.getLocationOffset(location.getLine(), location.getColumn());
        }

        public Optional<Integer> getLocationOffset(int line, int column) {
            return CelSource.getLocationOffsetImpl(this.lineOffsets, line, column);
        }

        public Optional<CelSourceLocation> getOffsetLocation(int offset) {
            return CelSourceHelper.getOffsetLocation(this.codePoints, offset);
        }

        @CheckReturnValue
        public Map<Long, Integer> getPositionsMap() {
            return this.positions;
        }

        @CheckReturnValue
        public Map<Long, CelExpr> getMacroCalls() {
            return this.macroCalls;
        }

        @CheckReturnValue
        public boolean containsMacroCalls(long exprId) {
            return this.macroCalls.containsKey(exprId);
        }

        @CheckReturnValue
        public CelSource build() {
            return new AutoValue_CelSource(this.codePoints, this.description, ImmutableList.copyOf(this.lineOffsets), ImmutableMap.copyOf(this.positions), ImmutableMap.copyOf(this.macroCalls), (ImmutableSet<Extension>)this.extensions.build());
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Extension {
        abstract String id();

        abstract Version version();

        abstract ImmutableList<Component> affectedComponents();

        @CheckReturnValue
        public static Extension create(String id, Version version, Iterable<Component> components) {
            Preconditions.checkNotNull(version);
            Preconditions.checkNotNull(components);
            return new AutoValue_CelSource_Extension(id, version, ImmutableList.copyOf(components));
        }

        @CheckReturnValue
        public static Extension create(String id, Version version, Component ... components) {
            return Extension.create(id, version, Arrays.asList(components));
        }

        @Immutable
        @AutoValue
        public static abstract class Version {
            abstract long major();

            abstract long minor();

            public static Version of(long major, long minor) {
                return new AutoValue_CelSource_Extension_Version(major, minor);
            }
        }

        public static enum Component {
            COMPONENT_UNSPECIFIED,
            COMPONENT_PARSER,
            COMPONENT_TYPE_CHECKER,
            COMPONENT_RUNTIME;

        }
    }
}

