/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;
import java.util.List;
import java.util.Optional;

@Internal
public final class CelSourceHelper {
    public static Optional<String> getSnippet(CelCodePointArray content, int line) {
        Preconditions.checkArgument(line > 0);
        ImmutableList<Integer> lineOffsets = content.lineOffsets();
        int start = CelSourceHelper.findLineOffset(lineOffsets, line);
        if (start == -1) {
            return Optional.empty();
        }
        int end = CelSourceHelper.findLineOffset(lineOffsets, line + 1);
        end = end == -1 ? content.size() : --end;
        return Optional.of(end != start ? content.slice(start, end).toString() : "");
    }

    public static Optional<CelSourceLocation> getOffsetLocation(CelCodePointArray content, int offset) {
        Preconditions.checkArgument(offset >= 0);
        LineAndOffset lineAndOffset = CelSourceHelper.findLine(content.lineOffsets(), offset);
        return Optional.of(CelSourceLocation.of(lineAndOffset.line, offset - lineAndOffset.offset));
    }

    private static LineAndOffset findLine(List<Integer> lineOffsets, int offset) {
        int line = 1;
        for (Integer lineOffset : lineOffsets) {
            if (lineOffset > offset) break;
            ++line;
        }
        if (line == 1) {
            return new LineAndOffset(line, 0);
        }
        return new LineAndOffset(line, lineOffsets.get(line - 2));
    }

    static int findLineOffset(List<Integer> lineOffsets, int line) {
        if (line == 1) {
            return 0;
        }
        if (line > 1 && line <= lineOffsets.size()) {
            return lineOffsets.get(line - 2);
        }
        return -1;
    }

    private CelSourceHelper() {
    }

    private static final class LineAndOffset {
        private final int line;
        private final int offset;

        private LineAndOffset(int line, int offset) {
            this.line = line;
            this.offset = offset;
        }
    }
}

