/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import java.util.AbstractCollection;
import java.util.Locale;

final class CelExprFormatter {
    private final StringBuilder indent = new StringBuilder();
    private final StringBuilder exprBuilder = new StringBuilder();
    private static final ImmutableSet<CelExpr.ExprKind.Kind> EXCLUDED_NEWLINE_KINDS = ImmutableSet.of(CelExpr.ExprKind.Kind.CONSTANT, CelExpr.ExprKind.Kind.NOT_SET);

    static String format(CelExpr celExpr) {
        CelExprFormatter formatter = new CelExprFormatter();
        formatter.formatExpr(celExpr);
        return formatter.exprBuilder.toString();
    }

    private void formatExpr(CelExpr celExpr) {
        CelExpr.ExprKind.Kind exprKind = celExpr.exprKind().getKind();
        this.append(String.format(Locale.getDefault(), "%s [%d] {", new Object[]{exprKind, celExpr.id()}));
        if (!EXCLUDED_NEWLINE_KINDS.contains((Object)exprKind)) {
            this.appendNewline();
        }
        switch (exprKind) {
            case CONSTANT: {
                this.appendConst(celExpr.constant());
                break;
            }
            case IDENT: {
                this.appendIdent(celExpr.ident());
                break;
            }
            case SELECT: {
                this.appendSelect(celExpr.select());
                break;
            }
            case CALL: {
                this.appendCall(celExpr.call());
                break;
            }
            case LIST: {
                this.appendList(celExpr.list());
                break;
            }
            case STRUCT: {
                this.appendStruct(celExpr.struct());
                break;
            }
            case MAP: {
                this.appendMap(celExpr.map());
                break;
            }
            case COMPREHENSION: {
                this.appendComprehension(celExpr.comprehension());
                break;
            }
            case NOT_SET: {
                break;
            }
            default: {
                this.indent();
                this.append("Unknown kind: " + (Object)((Object)exprKind));
                this.outdent();
            }
        }
        if (!EXCLUDED_NEWLINE_KINDS.contains((Object)exprKind)) {
            this.appendNewline();
            this.append("}");
        } else {
            this.appendWithoutIndent("}");
        }
    }

    private void appendConst(CelConstant celConstant) {
        this.appendWithoutIndent(" value: ");
        switch (celConstant.getKind()) {
            case NULL_VALUE: {
                this.appendWithoutIndent("null");
                break;
            }
            case BOOLEAN_VALUE: {
                this.appendWithoutIndent(Boolean.toString(celConstant.booleanValue()));
                break;
            }
            case INT64_VALUE: {
                this.appendWithoutIndent(Long.toString(celConstant.int64Value()));
                break;
            }
            case UINT64_VALUE: {
                this.appendWithoutIndent(celConstant.uint64Value() + "u");
                break;
            }
            case DOUBLE_VALUE: {
                this.appendWithoutIndent(Double.toString(celConstant.doubleValue()));
                break;
            }
            case STRING_VALUE: {
                this.appendWithoutIndent("\"" + celConstant.stringValue() + "\"");
                break;
            }
            case BYTES_VALUE: {
                this.appendWithoutIndent(String.format(Locale.getDefault(), "b\"%s\"", celConstant.bytesValue().toStringUtf8()));
                break;
            }
            default: {
                this.append("Unknown kind: " + (Object)((Object)celConstant.getKind()));
            }
        }
        this.appendWithoutIndent(" ");
    }

    private void appendIdent(CelExpr.CelIdent celIdent) {
        this.indent();
        this.append("name: " + celIdent.name());
        this.outdent();
    }

    private void appendSelect(CelExpr.CelSelect celSelect) {
        this.indent();
        this.formatExpr(celSelect.operand());
        this.outdent();
        this.appendWithoutIndent(".");
        this.appendWithoutIndent(celSelect.field());
        if (celSelect.testOnly()) {
            this.appendWithoutIndent("~presence_test");
        }
    }

    private void appendCall(CelExpr.CelCall celCall) {
        this.indent();
        this.appendWithNewline("function: " + celCall.function());
        if (celCall.target().isPresent()) {
            this.appendWithNewline("target: {");
            this.indent();
            this.formatExpr(celCall.target().get());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
        }
        this.append("args: {");
        this.indent();
        for (CelExpr celExpr : celCall.args()) {
            this.appendNewline();
            this.formatExpr(celExpr);
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void appendList(CelExpr.CelList celList) {
        this.indent();
        this.append("elements: {");
        this.indent();
        for (CelExpr expr : celList.elements()) {
            this.appendNewline();
            this.formatExpr(expr);
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        if (!((AbstractCollection)((Object)celList.optionalIndices())).isEmpty()) {
            this.appendNewline();
            this.append("optional_indices: [");
            for (int i = 0; i < ((AbstractCollection)((Object)celList.optionalIndices())).size(); ++i) {
                this.appendWithoutIndent(String.valueOf(i));
                if (i == ((AbstractCollection)((Object)celList.optionalIndices())).size() - 1) continue;
                this.appendWithoutIndent(", ");
            }
            this.appendWithoutIndent("]");
        }
        this.outdent();
    }

    private void appendStruct(CelExpr.CelStruct celStruct) {
        this.indent();
        this.appendWithNewline("name: " + celStruct.messageName());
        this.append("entries: {");
        this.indent();
        for (CelExpr.CelStruct.Entry entry : celStruct.entries()) {
            this.appendNewline();
            this.appendWithNewline(String.format(Locale.getDefault(), "ENTRY [%d] {", entry.id()));
            this.indent();
            this.appendWithNewline("field_key: " + entry.fieldKey());
            if (entry.optionalEntry()) {
                this.appendWithNewline("optional_entry: true");
            }
            this.appendWithNewline("value: {");
            this.indent();
            this.formatExpr(entry.value());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            this.outdent();
            this.append("}");
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void appendMap(CelExpr.CelMap celMap) {
        this.indent();
        boolean firstLine = true;
        for (CelExpr.CelMap.Entry entry : celMap.entries()) {
            if (!firstLine) {
                this.appendNewline();
            } else {
                firstLine = false;
            }
            this.appendWithNewline(String.format(Locale.getDefault(), "MAP_ENTRY [%d] {", entry.id()));
            this.indent();
            this.appendWithNewline("key: {");
            this.indent();
            this.formatExpr(entry.key());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            if (entry.optionalEntry()) {
                this.appendWithNewline("optional_entry: true");
            }
            this.appendWithNewline("value: {");
            this.indent();
            this.formatExpr(entry.value());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            this.outdent();
            this.append("}");
        }
        this.outdent();
    }

    private void appendComprehension(CelExpr.CelComprehension celComprehension) {
        this.indent();
        this.appendWithNewline("iter_var: " + celComprehension.iterVar());
        this.appendWithNewline("iter_range: {");
        this.indent();
        this.formatExpr(celComprehension.iterRange());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("accu_var: " + celComprehension.accuVar());
        this.appendWithNewline("accu_init: {");
        this.indent();
        this.formatExpr(celComprehension.accuInit());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("loop_condition: {");
        this.indent();
        this.formatExpr(celComprehension.loopCondition());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("loop_step: {");
        this.indent();
        this.formatExpr(celComprehension.loopStep());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("result: {");
        this.indent();
        this.formatExpr(celComprehension.result());
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void append(String str) {
        this.exprBuilder.append((CharSequence)this.indent);
        this.exprBuilder.append(str);
    }

    private void appendWithNewline(String str) {
        this.append(str);
        this.appendNewline();
    }

    private void appendWithoutIndent(String str) {
        this.exprBuilder.append(str);
    }

    private void appendNewline() {
        this.exprBuilder.append('\n');
    }

    private void indent() {
        this.indent.append("  ");
    }

    private void outdent() {
        this.indent.setLength(this.indent.length() - 2);
    }

    private CelExprFormatter() {
    }
}

