/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.formats;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import dev.cel.common.formats.ParserContext;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public final class YamlHelper {
    public static final String ERROR = "*error*";

    public static boolean assertYamlType(ParserContext<Node> ctx, long id, Node node, YamlNodeType ... expectedNodeTypes) {
        if (YamlHelper.validateYamlType(node, expectedNodeTypes)) {
            return true;
        }
        String nodeTag = node.getTag().getValue();
        ctx.reportError(id, String.format("Got yaml node type %s, wanted type(s) [%s]", nodeTag, Arrays.stream(expectedNodeTypes).map(YamlNodeType::tag).collect(Collectors.joining(" "))));
        return false;
    }

    public static Optional<Node> parseYamlSource(String policyContent) {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        return Optional.ofNullable(yaml.compose(new StringReader(policyContent)));
    }

    public static boolean assertRequiredFields(ParserContext<Node> ctx, long id, List<String> missingRequiredFields) {
        if (missingRequiredFields.isEmpty()) {
            return true;
        }
        ctx.reportError(id, String.format("Missing required attribute(s): %s", Joiner.on(", ").join(missingRequiredFields)));
        return false;
    }

    public static boolean validateYamlType(Node node, YamlNodeType ... expectedNodeTypes) {
        String nodeTag = node.getTag().getValue();
        for (YamlNodeType expectedNodeType : expectedNodeTypes) {
            if (!expectedNodeType.tag().equals(nodeTag)) continue;
            return true;
        }
        return false;
    }

    public static Double newDouble(ParserContext<Node> ctx, Node node) {
        long id = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, id, node, YamlNodeType.DOUBLE)) {
            return 0.0;
        }
        return Double.parseDouble(((ScalarNode)node).getValue());
    }

    public static Integer newInteger(ParserContext<Node> ctx, Node node) {
        long id = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, id, node, YamlNodeType.INTEGER)) {
            return 0;
        }
        return Integer.parseInt(((ScalarNode)node).getValue());
    }

    public static boolean newBoolean(ParserContext<Node> ctx, Node node) {
        long id = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, id, node, YamlNodeType.BOOLEAN)) {
            return false;
        }
        return Boolean.parseBoolean(((ScalarNode)node).getValue());
    }

    public static String newString(ParserContext<Node> ctx, Node node) {
        return ctx.newValueString(node).value();
    }

    private YamlHelper() {
    }

    public static enum YamlNodeType {
        MAP("tag:yaml.org,2002:map"),
        STRING("tag:yaml.org,2002:str"),
        BOOLEAN("tag:yaml.org,2002:bool"),
        INTEGER("tag:yaml.org,2002:int"),
        DOUBLE("tag:yaml.org,2002:float"),
        TEXT("!txt"),
        LIST("tag:yaml.org,2002:seq");

        private static final ImmutableMap<String, YamlNodeType> TAG_TO_NODE_TYPE;
        private final String tag;

        public static Optional<YamlNodeType> nodeType(String tag) {
            return Optional.ofNullable(TAG_TO_NODE_TYPE.get(tag));
        }

        public String tag() {
            return this.tag;
        }

        private YamlNodeType(String tag) {
            this.tag = tag;
        }

        static {
            TAG_TO_NODE_TYPE = Arrays.stream(YamlNodeType.values()).collect(ImmutableMap.toImmutableMap(YamlNodeType::tag, Function.identity()));
        }
    }
}

