/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.formats;

import com.google.common.base.Strings;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.Source;
import dev.cel.common.annotations.Internal;
import dev.cel.common.formats.ParserContext;
import dev.cel.common.formats.ValueString;
import dev.cel.common.formats.YamlHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

@Internal
public final class YamlParserContextImpl
implements ParserContext<Node> {
    private final ArrayList<CelIssue> issues = new ArrayList();
    private final HashMap<Long, CelSourceLocation> idToLocationMap = new HashMap();
    private final HashMap<Long, Integer> idToOffsetMap = new HashMap();
    private final Source policySource;
    private long id;

    @Override
    public void reportError(long id, String message) {
        this.issues.add(CelIssue.formatError(this.idToLocationMap.get(id), message));
    }

    @Override
    public List<CelIssue> getIssues() {
        return this.issues;
    }

    @Override
    public Map<Long, Integer> getIdToOffsetMap() {
        return this.idToOffsetMap;
    }

    @Override
    public ValueString newValueString(Node node) {
        long id = this.collectMetadata(node);
        if (!YamlHelper.assertYamlType(this, id, node, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) {
            return ValueString.of(id, "*error*");
        }
        ScalarNode scalarNode = (ScalarNode)node;
        DumperOptions.ScalarStyle style = scalarNode.getScalarStyle();
        if (style.equals((Object)DumperOptions.ScalarStyle.FOLDED) || style.equals((Object)DumperOptions.ScalarStyle.LITERAL)) {
            CelSourceLocation location = this.idToLocationMap.get(id);
            int line = location.getLine();
            int column = location.getColumn();
            String indent = Strings.padStart("", column, ' ');
            String text = this.policySource.getSnippet(line).orElse("");
            StringBuilder raw = new StringBuilder();
            while (text.startsWith(indent)) {
                raw.append(text);
                text = this.policySource.getSnippet(++line).orElse("");
                if (text.isEmpty()) break;
                if (!text.startsWith(indent)) continue;
                raw.append("\n");
            }
            this.idToOffsetMap.compute(id, (k, offset) -> offset - column);
            return ValueString.of(id, raw.toString());
        }
        return ValueString.of(id, scalarNode.getValue());
    }

    @Override
    public long collectMetadata(Node node) {
        long id = this.nextId();
        int line = node.getStartMark().getLine() + 1;
        int column = node.getStartMark().getColumn();
        if (node instanceof ScalarNode) {
            DumperOptions.ScalarStyle style = ((ScalarNode)node).getScalarStyle();
            switch (style) {
                case SINGLE_QUOTED: 
                case DOUBLE_QUOTED: {
                    ++column;
                    break;
                }
                case LITERAL: 
                case FOLDED: {
                    column = 0;
                    String snippet = this.policySource.getSnippet(++line).orElse("");
                    for (char c : snippet.toCharArray()) {
                        if (!Character.isWhitespace(c)) break;
                        ++column;
                    }
                    break;
                }
            }
        }
        this.idToLocationMap.put(id, CelSourceLocation.of(line, column));
        int offset = 0;
        if (line > 1) {
            offset = (Integer)this.policySource.getContent().lineOffsets().get(line - 2) + column;
        }
        this.idToOffsetMap.put(id, offset);
        return id;
    }

    @Override
    public long nextId() {
        return ++this.id;
    }

    public static ParserContext<Node> newInstance(Source source2) {
        return new YamlParserContextImpl(source2);
    }

    private YamlParserContextImpl(Source source2) {
        this.policySource = source2;
    }
}

