/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.BasicCodePointArray;
import java.util.Arrays;

@Internal
final class AutoValue_BasicCodePointArray
extends BasicCodePointArray {
    private final int size;
    private final ImmutableList<Integer> lineOffsets;
    private final char[] codePoints;
    private final int offset;

    AutoValue_BasicCodePointArray(int size, ImmutableList<Integer> lineOffsets, char[] codePoints, int offset) {
        this.size = size;
        if (lineOffsets == null) {
            throw new NullPointerException("Null lineOffsets");
        }
        this.lineOffsets = lineOffsets;
        if (codePoints == null) {
            throw new NullPointerException("Null codePoints");
        }
        this.codePoints = codePoints;
        this.offset = offset;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableList<Integer> lineOffsets() {
        return this.lineOffsets;
    }

    @Override
    char[] codePoints() {
        return this.codePoints;
    }

    @Override
    int offset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BasicCodePointArray) {
            BasicCodePointArray that = (BasicCodePointArray)o;
            return this.size == that.size() && this.lineOffsets.equals(that.lineOffsets()) && Arrays.equals(this.codePoints, that instanceof AutoValue_BasicCodePointArray ? ((AutoValue_BasicCodePointArray)that).codePoints : that.codePoints()) && this.offset == that.offset();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.size;
        h$ *= 1000003;
        h$ ^= this.lineOffsets.hashCode();
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.codePoints);
        h$ *= 1000003;
        return h$ ^= this.offset;
    }
}

