/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AutoValue_BasicCodePointArray;
import dev.cel.common.internal.CelCodePointArray;

@Immutable
@Internal
@AutoValue
@AutoValue.CopyAnnotations
public abstract class BasicCodePointArray
extends CelCodePointArray {
    abstract char[] codePoints();

    abstract int offset();

    static BasicCodePointArray create(char[] codePoints, int size, ImmutableList<Integer> lineOffsets) {
        return BasicCodePointArray.create(codePoints, 0, lineOffsets, size);
    }

    static BasicCodePointArray create(char[] codePoints, int offset, ImmutableList<Integer> lineOffsets, int size) {
        return new AutoValue_BasicCodePointArray(size, Preconditions.checkNotNull(lineOffsets), codePoints, offset);
    }

    @Override
    public BasicCodePointArray slice(int i, int j) {
        Preconditions.checkPositionIndexes(i, j, this.size());
        return BasicCodePointArray.create(this.codePoints(), this.offset() + i, this.lineOffsets(), j - i);
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex(index, this.size());
        return this.codePoints()[this.offset() + index] & 0xFFFF;
    }

    @Override
    public final String toString() {
        return new String(this.codePoints(), this.offset(), this.size());
    }
}

