/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.BasicCodePointArray;
import dev.cel.common.internal.EmptyCodePointArray;
import dev.cel.common.internal.Latin1CodePointArray;
import dev.cel.common.internal.SupplementalCodePointArray;
import java.util.PrimitiveIterator;

@Immutable
@Internal
public abstract class CelCodePointArray {
    CelCodePointArray() {
    }

    public abstract CelCodePointArray slice(int var1, int var2);

    public abstract int get(int var1);

    public abstract int size();

    public abstract ImmutableList<Integer> lineOffsets();

    public final int length() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract String toString();

    public static CelCodePointArray fromString(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return EmptyCodePointArray.INSTANCE;
        }
        PrimitiveIterator.OfInt codePoints = text.codePoints().iterator();
        byte[] byteArray = new byte[text.length()];
        int byteIndex = 0;
        LineOffsetContext lineOffsetContext = new LineOffsetContext();
        while (codePoints.hasNext()) {
            int intIndex;
            int codePoint = codePoints.nextInt();
            lineOffsetContext.process(codePoint);
            if (codePoint <= 255) {
                byteArray[byteIndex++] = (byte)codePoint;
                continue;
            }
            if (codePoint <= 65535) {
                int charIndex;
                char[] charArray = new char[text.length()];
                for (charIndex = 0; charIndex < byteIndex; ++charIndex) {
                    charArray[charIndex] = (char)(byteArray[charIndex] & 0xFF);
                }
                byteArray = null;
                charArray[charIndex++] = (char)codePoint;
                while (codePoints.hasNext()) {
                    int intIndex2;
                    codePoint = codePoints.nextInt();
                    lineOffsetContext.process(codePoint);
                    if (codePoint <= 65535) {
                        charArray[charIndex++] = (char)codePoint;
                        continue;
                    }
                    int[] intArray = new int[text.length()];
                    for (intIndex2 = 0; intIndex2 < charIndex; ++intIndex2) {
                        intArray[intIndex2] = charArray[intIndex2] & 0xFFFF;
                    }
                    charArray = null;
                    intArray[intIndex2++] = codePoint;
                    while (codePoints.hasNext()) {
                        codePoint = codePoints.nextInt();
                        lineOffsetContext.process(codePoint);
                        intArray[intIndex2++] = codePoint;
                    }
                    return SupplementalCodePointArray.create(intArray, intIndex2, lineOffsetContext.buildLineOffsets());
                }
                return BasicCodePointArray.create(charArray, charIndex, lineOffsetContext.buildLineOffsets());
            }
            int[] intArray = new int[text.length()];
            for (intIndex = 0; intIndex < byteIndex; ++intIndex) {
                intArray[intIndex] = byteArray[intIndex] & 0xFF;
            }
            byteArray = null;
            intArray[intIndex++] = codePoint;
            while (codePoints.hasNext()) {
                codePoint = codePoints.nextInt();
                lineOffsetContext.process(codePoint);
                intArray[intIndex++] = codePoint;
            }
            return SupplementalCodePointArray.create(intArray, intIndex, lineOffsetContext.buildLineOffsets());
        }
        return Latin1CodePointArray.create(byteArray, byteIndex, lineOffsetContext.buildLineOffsets());
    }

    private static class LineOffsetContext {
        private static final int NEWLINE_CODE_POINT = 10;
        private final ImmutableList.Builder<Integer> lineOffsetBuilder = ImmutableList.builder();
        private int lineOffsetCodePoints;

        private void process(int codePoint) {
            ++this.lineOffsetCodePoints;
            if (codePoint == 10) {
                this.lineOffsetBuilder.add((Object)this.lineOffsetCodePoints);
            }
        }

        private ImmutableList<Integer> buildLineOffsets() {
            return ((ImmutableList.Builder)this.lineOffsetBuilder.add((Object)(this.lineOffsetCodePoints + 1))).build();
        }

        private LineOffsetContext() {
        }
    }
}

