/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;

@Internal
public final class CodePointStream
implements CharStream {
    private final String sourceName;
    private final CelCodePointArray codePoints;
    private int position;

    public CodePointStream(String sourceName, CelCodePointArray codePoints) {
        this.sourceName = Preconditions.checkNotNull(sourceName);
        this.codePoints = Preconditions.checkNotNull(codePoints);
        this.position = 0;
    }

    @Override
    public void consume() {
        if (this.position >= this.size()) {
            Preconditions.checkState(this.LA(1) == -1);
            throw new IllegalStateException("Cannot consume EOF");
        }
        ++this.position;
    }

    @Override
    public int LA(int i) {
        switch (Integer.signum(i)) {
            case -1: {
                int index = this.position + i;
                if (index < 0) {
                    return -1;
                }
                return this.codePoints.get(index);
            }
            case 0: {
                return 0;
            }
            case 1: {
                int index = this.position + i - 1;
                if (index >= this.codePoints.size()) {
                    return -1;
                }
                return this.codePoints.get(index);
            }
        }
        throw new AssertionError();
    }

    @Override
    public int mark() {
        return -1;
    }

    @Override
    public void release(int marker) {
    }

    @Override
    public int index() {
        return this.position;
    }

    @Override
    public void seek(int index) {
        Preconditions.checkArgument(index >= 0 && index <= this.size());
        this.position = index;
    }

    @Override
    public int size() {
        return this.codePoints.size();
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public String getText(Interval interval) {
        int index = Math.min(interval.a, this.size());
        int size = Math.min(interval.b - interval.a + 1, this.size() - index);
        return this.codePoints.slice(index, index + size).toString();
    }

    public String toString() {
        return this.codePoints.toString();
    }
}

