/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import java.util.Optional;

@Immutable
@Internal
public final class CombinedDescriptorPool
implements CelDescriptorPool {
    private final ImmutableList<CelDescriptorPool> descriptorPools;
    private final ExtensionRegistry extensionRegistry;

    public static CombinedDescriptorPool create(ImmutableList<CelDescriptorPool> descriptorPools) {
        return new CombinedDescriptorPool(descriptorPools);
    }

    @Override
    public Optional<Descriptors.Descriptor> findDescriptor(String name) {
        for (CelDescriptorPool descriptorPool : this.descriptorPools) {
            Optional<Descriptors.Descriptor> maybeDescriptor = descriptorPool.findDescriptor(name);
            if (!maybeDescriptor.isPresent()) continue;
            return maybeDescriptor;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Descriptors.FieldDescriptor> findExtensionDescriptor(Descriptors.Descriptor containingDescriptor, String fieldName) {
        for (CelDescriptorPool descriptorPool : this.descriptorPools) {
            Optional<Descriptors.FieldDescriptor> maybeExtensionDescriptor = descriptorPool.findExtensionDescriptor(containingDescriptor, fieldName);
            if (!maybeExtensionDescriptor.isPresent()) continue;
            return maybeExtensionDescriptor;
        }
        return Optional.empty();
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    private CombinedDescriptorPool(ImmutableList<CelDescriptorPool> descriptorPools) {
        this.descriptorPools = descriptorPools;
        this.extensionRegistry = descriptorPools.stream().map(CelDescriptorPool::getExtensionRegistry).filter(e -> !e.equals(ExtensionRegistry.getEmptyRegistry())).findFirst().orElse(ExtensionRegistry.getEmptyRegistry());
    }
}

