/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.navigation;

import com.google.auto.value.AutoValue;
import dev.cel.common.ast.Expression;
import dev.cel.common.navigation.AutoValue_ExprPropertyCalculator_ExprProperty;
import java.util.HashMap;
import java.util.List;

final class ExprPropertyCalculator<E extends Expression> {
    private final HashMap<Long, ExprProperty> idToProperty = new HashMap();

    ExprPropertyCalculator(E celExpr) {
        this.visit(celExpr);
    }

    ExprProperty getProperty(Long exprId) {
        if (!this.idToProperty.containsKey(exprId)) {
            throw new IllegalArgumentException("Property not found for expression id: " + exprId);
        }
        return this.idToProperty.get(exprId);
    }

    private ExprProperty visit(E expr) {
        ExprProperty visitedProperty;
        int baseHeight = 1;
        switch (expr.getKind()) {
            case CALL: {
                visitedProperty = this.visit(expr.call());
                break;
            }
            case LIST: {
                visitedProperty = this.visit(expr.list());
                break;
            }
            case SELECT: {
                visitedProperty = this.visit(expr.select());
                break;
            }
            case STRUCT: {
                visitedProperty = this.visitStruct(expr.struct());
                break;
            }
            case MAP: {
                visitedProperty = this.visitMap(expr.map());
                break;
            }
            case COMPREHENSION: {
                visitedProperty = this.visit(expr.comprehension());
                break;
            }
            default: {
                baseHeight = 0;
                visitedProperty = ExprProperty.create(baseHeight, expr.id());
            }
        }
        ExprProperty exprProperty = ExprProperty.create(baseHeight + visitedProperty.height(), Math.max(visitedProperty.maxId(), expr.id()));
        this.idToProperty.put(expr.id(), exprProperty);
        return exprProperty;
    }

    private ExprProperty visit(Expression.Call<E> call) {
        ExprProperty visitedTarget = ExprProperty.create(0, 0L);
        if (call.target().isPresent()) {
            visitedTarget = this.visit((Expression)call.target().get());
        }
        ExprProperty visitedArgument = this.visitExprList(call.args());
        return ExprProperty.merge(visitedArgument, visitedTarget);
    }

    private ExprProperty visit(Expression.List<E> list) {
        return this.visitExprList(list.elements());
    }

    private ExprProperty visit(Expression.Select<E> selectExpr) {
        return this.visit(selectExpr.operand());
    }

    private ExprProperty visit(Expression.Comprehension<E> comprehension) {
        ExprProperty visitedProperty = this.visit(comprehension.iterRange());
        visitedProperty = ExprProperty.merge(visitedProperty, this.visit(comprehension.accuInit()));
        visitedProperty = ExprProperty.merge(visitedProperty, this.visit(comprehension.loopCondition()));
        visitedProperty = ExprProperty.merge(visitedProperty, this.visit(comprehension.loopStep()));
        visitedProperty = ExprProperty.merge(visitedProperty, this.visit(comprehension.result()));
        return visitedProperty;
    }

    private ExprProperty visitStruct(Expression.Struct<Expression.Struct.Entry<E>> struct) {
        ExprProperty visitedProperty = ExprProperty.create(0, 0L);
        for (Expression.Struct.Entry<E> entry : struct.entries()) {
            visitedProperty = ExprProperty.merge(visitedProperty, this.visit(entry.value()));
        }
        return visitedProperty;
    }

    private ExprProperty visitMap(Expression.Map<Expression.Map.Entry<E>> map) {
        ExprProperty visitedProperty = ExprProperty.create(0, 0L);
        for (Expression.Map.Entry<E> entry : map.entries()) {
            visitedProperty = ExprProperty.merge(visitedProperty, this.visit(entry.key()));
            visitedProperty = ExprProperty.merge(visitedProperty, this.visit(entry.value()));
        }
        return visitedProperty;
    }

    private ExprProperty visitExprList(List<E> list) {
        ExprProperty visitedProperty = ExprProperty.create(0, 0L);
        for (Expression expr : list) {
            visitedProperty = ExprProperty.merge(visitedProperty, this.visit(expr));
        }
        return visitedProperty;
    }

    @AutoValue
    static abstract class ExprProperty {
        ExprProperty() {
        }

        abstract int height();

        abstract long maxId();

        private static ExprProperty merge(ExprProperty e1, ExprProperty e2) {
            return ExprProperty.create(Math.max(e1.height(), e2.height()), Math.max(e1.maxId(), e2.maxId()));
        }

        private static ExprProperty create(int height, long maxId) {
            return new AutoValue_ExprPropertyCalculator_ExprProperty(height, maxId);
        }
    }
}

