/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelKind;
import java.util.function.Function;

@Immutable
@CheckReturnValue
public abstract class CelType {
    protected CelType() {
    }

    public abstract CelKind kind();

    public abstract String name();

    public ImmutableList<CelType> parameters() {
        return ImmutableList.of();
    }

    public boolean isAssignableFrom(CelType other) {
        return this.equals(other);
    }

    @CanIgnoreReturnValue
    public CelType withParameters(ImmutableList<CelType> parameters) {
        return this;
    }

    @CanIgnoreReturnValue
    public CelType withFreshTypeParamVariables(Function<String, String> varNameGenerator) {
        return this.withParameters(this.parameters().stream().map(p -> p.withFreshTypeParamVariables(varNameGenerator)).collect(ImmutableList.toImmutableList()));
    }
}

