/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.NullableType;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeType;
import java.util.Optional;

public final class CelTypes {
    public static final String ANY_MESSAGE = "google.protobuf.Any";
    public static final String DURATION_MESSAGE = "google.protobuf.Duration";
    public static final String LIST_VALUE_MESSAGE = "google.protobuf.ListValue";
    public static final String STRUCT_MESSAGE = "google.protobuf.Struct";
    public static final String TIMESTAMP_MESSAGE = "google.protobuf.Timestamp";
    public static final String VALUE_MESSAGE = "google.protobuf.Value";
    public static final String BOOL_WRAPPER_MESSAGE = "google.protobuf.BoolValue";
    public static final String BYTES_WRAPPER_MESSAGE = "google.protobuf.BytesValue";
    public static final String DOUBLE_WRAPPER_MESSAGE = "google.protobuf.DoubleValue";
    public static final String FLOAT_WRAPPER_MESSAGE = "google.protobuf.FloatValue";
    public static final String INT32_WRAPPER_MESSAGE = "google.protobuf.Int32Value";
    public static final String INT64_WRAPPER_MESSAGE = "google.protobuf.Int64Value";
    public static final String STRING_WRAPPER_MESSAGE = "google.protobuf.StringValue";
    public static final String UINT32_WRAPPER_MESSAGE = "google.protobuf.UInt32Value";
    public static final String UINT64_WRAPPER_MESSAGE = "google.protobuf.UInt64Value";
    private static final ImmutableMap<String, CelType> WELL_KNOWN_CEL_TYPE_MAP = ImmutableMap.builder().put("google.protobuf.BoolValue", NullableType.create(SimpleType.BOOL)).put("google.protobuf.BytesValue", NullableType.create(SimpleType.BYTES)).put("google.protobuf.FloatValue", NullableType.create(SimpleType.DOUBLE)).put("google.protobuf.DoubleValue", NullableType.create(SimpleType.DOUBLE)).put("google.protobuf.Int32Value", NullableType.create(SimpleType.INT)).put("google.protobuf.Int64Value", NullableType.create(SimpleType.INT)).put("google.protobuf.StringValue", NullableType.create(SimpleType.STRING)).put("google.protobuf.UInt32Value", NullableType.create(SimpleType.UINT)).put("google.protobuf.UInt64Value", NullableType.create(SimpleType.UINT)).put("google.protobuf.Any", (NullableType)SimpleType.ANY).put("google.protobuf.Duration", (NullableType)SimpleType.DURATION).put("google.protobuf.Timestamp", (NullableType)SimpleType.TIMESTAMP).put("google.protobuf.ListValue", (NullableType)((Object)ListType.create(SimpleType.DYN))).put("google.protobuf.Struct", (NullableType)((Object)MapType.create(SimpleType.STRING, SimpleType.DYN))).put("google.protobuf.Value", (NullableType)SimpleType.DYN).buildOrThrow();

    public static boolean isWrapperType(String typeName) {
        switch (typeName) {
            case "google.protobuf.BoolValue": 
            case "google.protobuf.BytesValue": 
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.StringValue": 
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.UInt64Value": {
                return true;
            }
        }
        return false;
    }

    @Internal
    public static OpaqueType createFunctionType(CelType resultType, Iterable<CelType> argumentTypes) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add(resultType);
        arguments.addAll(argumentTypes);
        return OpaqueType.create("function", (ImmutableList<CelType>)arguments.build());
    }

    public static String format(CelType type) {
        return CelTypes.format(type, false);
    }

    static String format(CelType type, boolean typeParamToDyn) {
        if (type instanceof NullableType) {
            return String.format("wrapper(%s)", CelTypes.format(((NullableType)type).targetType(), typeParamToDyn));
        }
        switch (type.kind()) {
            case DYN: {
                return "dyn";
            }
            case NULL_TYPE: {
                return "null";
            }
            case BOOL: {
                return "bool";
            }
            case INT: {
                return "int";
            }
            case UINT: {
                return "uint";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                return "string";
            }
            case BYTES: {
                return "bytes";
            }
            case TIMESTAMP: {
                return TIMESTAMP_MESSAGE;
            }
            case DURATION: {
                return DURATION_MESSAGE;
            }
            case ANY: {
                return "any";
            }
            case LIST: {
                ListType listType = (ListType)type;
                return String.format("list(%s)", CelTypes.format(listType.elemType(), typeParamToDyn));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return String.format("map(%s, %s)", CelTypes.format(mapType.keyType(), typeParamToDyn), CelTypes.format(mapType.valueType(), typeParamToDyn));
            }
            case TYPE: {
                TypeType typeType = (TypeType)type;
                return String.format("type(%s)", CelTypes.format(typeType.type(), typeParamToDyn));
            }
            case ERROR: {
                return "*error*";
            }
            case STRUCT: {
                return type.name();
            }
            case TYPE_PARAM: {
                return typeParamToDyn ? "dyn" : type.name();
            }
            case OPAQUE: {
                if (type.name().equals("function")) {
                    return CelTypes.formatFunction((CelType)type.parameters().get(0), type.parameters().subList(1, type.parameters().size()), false, typeParamToDyn);
                }
                String result = type.name();
                if (!type.parameters().isEmpty()) {
                    result = result + CelTypes.formatTypeArgs(type.parameters(), typeParamToDyn);
                }
                return result;
            }
        }
        return "<unknown type>";
    }

    public static String formatFunction(CelType resultType, Iterable<CelType> argTypes, boolean isInstance, boolean typeParamToDyn) {
        String argString = isInstance ? CelTypes.format(Iterables.get(argTypes, 0), typeParamToDyn) + "." + CelTypes.formatTypeArgs(Iterables.skip(argTypes, 1), typeParamToDyn) : CelTypes.formatTypeArgs(argTypes, typeParamToDyn);
        if (resultType == null) {
            return argString;
        }
        return argString + " -> " + CelTypes.format(resultType, typeParamToDyn);
    }

    public static boolean isWellKnownType(String typeName) {
        return WELL_KNOWN_CEL_TYPE_MAP.containsKey(typeName);
    }

    public static Optional<CelType> getWellKnownCelType(String typeName) {
        return Optional.ofNullable(WELL_KNOWN_CEL_TYPE_MAP.getOrDefault(typeName, null));
    }

    private static String formatTypeArgs(Iterable<CelType> types, boolean typeParamToDyn) {
        return String.format("(%s)", Joiner.on(", ").join(Iterables.transform(types, type -> CelTypes.format(type, typeParamToDyn))));
    }

    private CelTypes() {
    }
}

