/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_ProtoMessageType_Extension;
import dev.cel.common.types.CelType;
import dev.cel.common.types.StructType;
import java.util.Optional;

@CheckReturnValue
@Immutable
public final class ProtoMessageType
extends StructType {
    private final StructType.FieldResolver extensionResolver;

    ProtoMessageType(String name, ImmutableSet<String> fieldNames, StructType.FieldResolver fieldResolver, StructType.FieldResolver extensionResolver) {
        super(name, fieldNames, fieldResolver);
        this.extensionResolver = extensionResolver;
    }

    public Optional<Extension> findExtension(String extensionName) {
        return this.extensionResolver.findField(extensionName).map(type -> Extension.of(extensionName, type, this));
    }

    public ProtoMessageType withVisibleFields(ImmutableSet<String> visibleFields) {
        return new ProtoMessageType(this.name, visibleFields, this.fieldResolver, this.extensionResolver);
    }

    public static ProtoMessageType create(String name, ImmutableSet<String> fieldNames, StructType.FieldResolver fieldResolver, StructType.FieldResolver extensionResolver) {
        return new ProtoMessageType(name, fieldNames, fieldResolver, extensionResolver);
    }

    @Immutable
    @AutoValue
    public static abstract class Extension {
        public abstract String name();

        public abstract CelType type();

        public abstract CelType messageType();

        static Extension of(String name, CelType type, CelType messageType) {
            return new AutoValue_ProtoMessageType_Extension(name, type, messageType);
        }
    }
}

