/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_StructType_Field;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.StructTypeReference;
import java.util.NoSuchElementException;
import java.util.Optional;

@CheckReturnValue
@Immutable
public class StructType
extends CelType {
    protected final String name;
    protected final ImmutableSet<String> fieldNames;
    protected final FieldResolver fieldResolver;

    StructType(String name, ImmutableSet<String> fieldNames, FieldResolver fieldResolver) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.fieldResolver = fieldResolver;
    }

    @Override
    public CelKind kind() {
        return CelKind.STRUCT;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isAssignableFrom(CelType other) {
        return super.isAssignableFrom(other) || (other instanceof StructType || other instanceof StructTypeReference) && other.name().equals(this.name());
    }

    public Optional<Field> findField(String fieldName) {
        if (!this.fieldNames.contains(fieldName)) {
            return Optional.empty();
        }
        return this.fieldResolver.findField(fieldName).map(type -> Field.of(fieldName, type));
    }

    public ImmutableSet<String> fieldNames() {
        return this.fieldNames;
    }

    public ImmutableSet<Field> fields() {
        return this.fieldNames().stream().map(f -> this.findField((String)f).orElseThrow(() -> new NoSuchElementException(String.format("no such field: %s", f)))).collect(ImmutableSet.toImmutableSet());
    }

    public static StructType create(String name, ImmutableSet<String> fieldNames, FieldResolver fieldResolver) {
        return new StructType(name, fieldNames, fieldResolver);
    }

    @Immutable
    @FunctionalInterface
    public static interface FieldResolver {
        public Optional<CelType> findField(String var1);
    }

    @Immutable
    @AutoValue
    public static abstract class Field {
        public abstract String name();

        public abstract CelType type();

        public static Field of(String name, CelType type) {
            return new AutoValue_StructType_Field(name, type);
        }
    }
}

