/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.errorprone.annotations.Immutable;
import java.util.Arrays;

@Immutable
public final class CelByteString {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final CelByteString EMPTY = new CelByteString(EMPTY_BYTE_ARRAY);
    private final byte[] data;
    private volatile int hash = 0;

    public static CelByteString of(byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        if (buffer.length == 0) {
            return EMPTY;
        }
        return new CelByteString(buffer);
    }

    public int size() {
        return this.data.length;
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public byte[] toByteArray() {
        int size = this.size();
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return Arrays.copyOf(this.data, size);
    }

    private CelByteString(byte[] buffer) {
        this.data = Arrays.copyOf(buffer, buffer.length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CelByteString)) {
            return false;
        }
        return Arrays.equals(this.data, ((CelByteString)o).data);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h2 = 1;
            h2 *= 1000003;
            if ((h2 ^= Arrays.hashCode(this.data)) == 0) {
                h2 = 1;
            }
            this.hash = h2;
        }
        return this.hash;
    }
}

