/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueProvider;
import java.util.Map;
import java.util.Optional;

@Immutable
public final class CombinedCelValueProvider
implements CelValueProvider {
    private final ImmutableList<CelValueProvider> celValueProviders;

    public static CombinedCelValueProvider combine(CelValueProvider ... providers) {
        Preconditions.checkArgument(providers.length >= 2, "You must provide two or more providers");
        return new CombinedCelValueProvider(ImmutableList.copyOf(providers));
    }

    @Override
    public Optional<CelValue> newValue(String structType, Map<String, Object> fields) {
        for (CelValueProvider provider : this.celValueProviders) {
            Optional<CelValue> newValue = provider.newValue(structType, fields);
            if (!newValue.isPresent()) continue;
            return newValue;
        }
        return Optional.empty();
    }

    public ImmutableList<CelValueProvider> valueProviders() {
        return this.celValueProviders;
    }

    private CombinedCelValueProvider(ImmutableList<CelValueProvider> providers) {
        this.celValueProviders = Preconditions.checkNotNull(providers);
    }
}

