/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.types.CelType;
import dev.cel.common.types.StructTypeReference;
import dev.cel.common.values.AutoValue_ProtoMessageValue;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.ProtoCelValueConverter;
import dev.cel.common.values.StringValue;
import dev.cel.common.values.StructValue;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class ProtoMessageValue
extends StructValue<StringValue> {
    @Override
    public abstract Message value();

    @Override
    public abstract CelType celType();

    abstract CelDescriptorPool celDescriptorPool();

    abstract ProtoCelValueConverter protoCelValueConverter();

    @Override
    public boolean isZeroValue() {
        return this.value().getDefaultInstanceForType().equals(this.value());
    }

    @Override
    public CelValue select(StringValue field) {
        Descriptors.FieldDescriptor fieldDescriptor = this.findField(this.celDescriptorPool(), this.value().getDescriptorForType(), field.value());
        return this.protoCelValueConverter().fromProtoMessageFieldToCelValue(this.value(), fieldDescriptor);
    }

    @Override
    public Optional<CelValue> find(StringValue field) {
        Descriptors.FieldDescriptor fieldDescriptor = this.findField(this.celDescriptorPool(), this.value().getDescriptorForType(), field.value());
        if (fieldDescriptor.isRepeated() ? this.value().getRepeatedFieldCount(fieldDescriptor) == 0 : !this.value().hasField(fieldDescriptor)) {
            return Optional.empty();
        }
        return Optional.of(this.protoCelValueConverter().fromProtoMessageFieldToCelValue(this.value(), fieldDescriptor));
    }

    public static ProtoMessageValue create(Message value, CelDescriptorPool celDescriptorPool, ProtoCelValueConverter protoCelValueConverter) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(celDescriptorPool);
        Preconditions.checkNotNull(protoCelValueConverter);
        return new AutoValue_ProtoMessageValue(value, StructTypeReference.create(value.getDescriptorForType().getFullName()), celDescriptorPool, protoCelValueConverter);
    }

    private Descriptors.FieldDescriptor findField(CelDescriptorPool celDescriptorPool, Descriptors.Descriptor descriptor, String fieldName) {
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(fieldName);
        if (fieldDescriptor != null) {
            return fieldDescriptor;
        }
        return celDescriptorPool.findExtensionDescriptor(descriptor, fieldName).orElseThrow(() -> new IllegalArgumentException(String.format("field '%s' is not declared in message '%s'", fieldName, descriptor.getFullName())));
    }
}

