/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.compiler;

import com.google.errorprone.annotations.Immutable;
import dev.cel.checker.CelChecker;
import dev.cel.common.CelValidationResult;
import dev.cel.compiler.CelCompilerBuilder;
import dev.cel.parser.CelParser;

@Immutable
public interface CelCompiler
extends CelParser,
CelChecker {
    default public CelValidationResult compile(String expression) {
        return this.compile(expression, "<input>");
    }

    default public CelValidationResult compile(String expression, String description) {
        CelValidationResult result = this.parse(expression, description);
        if (result.hasError()) {
            return result;
        }
        try {
            return this.check(result.getAst());
        }
        catch (Exception ex) {
            throw new IllegalStateException("this method must only be called when !hasError()", ex);
        }
    }

    public CelCompilerBuilder toCompilerBuilder();
}

