/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelIssue;
import dev.cel.common.ast.CelExpr;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.CelParserBuilder;
import java.util.Optional;

@Immutable
final class CelBindingsExtensions
implements CelCompilerLibrary {
    private static final String CEL_NAMESPACE = "cel";
    private static final String UNUSED_ITER_VAR = "#unused";

    @Override
    public void setParserOptions(CelParserBuilder parserBuilder) {
        parserBuilder.addMacros(CelMacro.newReceiverMacro("bind", 3, CelBindingsExtensions::expandBind));
    }

    private static Optional<CelExpr> expandBind(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(target);
        if (!CelBindingsExtensions.isTargetInNamespace(target)) {
            return Optional.empty();
        }
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkArgument(arguments.size() == 3);
        CelExpr varIdent = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (varIdent.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(varIdent), "cel.bind() variable name must be a simple identifier")));
        }
        String varName = varIdent.ident().name();
        CelExpr varInit = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        CelExpr resultExpr = Preconditions.checkNotNull((CelExpr)arguments.get(2));
        return Optional.of(exprFactory.fold(UNUSED_ITER_VAR, exprFactory.newList(new CelExpr[0]), varName, varInit, exprFactory.newBoolLiteral(false), exprFactory.newIdentifier(varName), resultExpr));
    }

    private static boolean isTargetInNamespace(CelExpr target) {
        return target.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && target.ident().name().equals(CEL_NAMESPACE);
    }

    CelBindingsExtensions() {
    }
}

