/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeParamType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.Collection;
import java.util.Set;

final class CelListsExtensions
implements CelCompilerLibrary,
CelRuntimeLibrary {
    private static final TypeParamType LIST_PARAM_TYPE = TypeParamType.create("T");
    private final ImmutableSet<Function> functions;

    CelListsExtensions() {
        this.functions = ImmutableSet.copyOf(Function.values());
    }

    CelListsExtensions(Set<Function> functions) {
        this.functions = ImmutableSet.copyOf(functions);
    }

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        this.functions.forEach(function -> checkerBuilder.addFunctionDeclarations(((Function)function).functionDecl));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        this.functions.forEach(function -> runtimeBuilder.addFunctionBindings(((Function)function).functionBindings));
    }

    private static ImmutableList<Object> flatten(Collection<Object> list, long depth) {
        Preconditions.checkArgument(depth >= 0L, "Level must be non-negative");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object element : list) {
            if (!(element instanceof Collection) || depth == 0L) {
                builder.add(element);
                continue;
            }
            Collection listItem = (Collection)element;
            builder.addAll(CelListsExtensions.flatten(listItem, depth - 1L));
        }
        return builder.build();
    }

    public static ImmutableList<Long> genRange(long end) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i = 0L; i < end; ++i) {
            builder.add((Object)i);
        }
        return builder.build();
    }

    static /* synthetic */ TypeParamType access$000() {
        return LIST_PARAM_TYPE;
    }

    public static enum Function {
        FLATTEN(CelFunctionDecl.newFunctionDeclaration("flatten", CelOverloadDecl.newMemberOverload("list_flatten", "Flattens a list by a single level", (CelType)ListType.create(CelListsExtensions.access$000()), ListType.create(ListType.create(CelListsExtensions.access$000()))), CelOverloadDecl.newMemberOverload("list_flatten_list_int", "Flattens a list to the specified level. A negative depth value flattens the list recursively to its deepest level.", (CelType)ListType.create(SimpleType.DYN), ListType.create(SimpleType.DYN), SimpleType.INT)), CelFunctionBinding.from("list_flatten", Collection.class, list -> CelListsExtensions.access$100(list, 1L)), CelFunctionBinding.from("list_flatten_list_int", Collection.class, Long.class, (x$0, x$1) -> CelListsExtensions.access$100(x$0, x$1))),
        RANGE(CelFunctionDecl.newFunctionDeclaration("lists.range", CelOverloadDecl.newGlobalOverload("lists_range", "Returns a list of integers from 0 to n-1.", (CelType)ListType.create(SimpleType.INT), SimpleType.INT)), CelFunctionBinding.from("lists_range", Long.class, CelListsExtensions::genRange));

        private final CelFunctionDecl functionDecl;
        private final ImmutableSet<CelFunctionBinding> functionBindings;

        String getFunction() {
            return this.functionDecl.name();
        }

        private Function(CelFunctionDecl functionDecl, CelFunctionBinding ... functionBindings) {
            this.functionDecl = functionDecl;
            this.functionBindings = ImmutableSet.copyOf(functionBindings);
        }
    }
}

