/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelIssue;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.ComparisonFunctions;
import dev.cel.common.types.ListType;
import dev.cel.common.types.SimpleType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.CelParserBuilder;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.math.RoundingMode;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

@Immutable
final class CelMathExtensions
implements CelCompilerLibrary,
CelRuntimeLibrary {
    private static final String MATH_NAMESPACE = "math";
    private static final String MATH_MAX_FUNCTION = "math.@max";
    private static final String MATH_MAX_OVERLOAD_DOC = "Returns the greatest valued number present in the arguments.";
    private static final String MATH_MIN_FUNCTION = "math.@min";
    private static final String MATH_MIN_OVERLOAD_DOC = "Returns the least valued number present in the arguments.";
    private static final String MATH_CEIL_FUNCTION = "math.ceil";
    private static final String MATH_FLOOR_FUNCTION = "math.floor";
    private static final String MATH_ROUND_FUNCTION = "math.round";
    private static final String MATH_TRUNC_FUNCTION = "math.trunc";
    private static final String MATH_ISFINITE_FUNCTION = "math.isFinite";
    private static final String MATH_ISNAN_FUNCTION = "math.isNaN";
    private static final String MATH_ISINF_FUNCTION = "math.isInf";
    private static final String MATH_ABS_FUNCTION = "math.abs";
    private static final String MATH_SIGN_FUNCTION = "math.sign";
    private static final String MATH_BIT_AND_FUNCTION = "math.bitAnd";
    private static final String MATH_BIT_OR_FUNCTION = "math.bitOr";
    private static final String MATH_BIT_XOR_FUNCTION = "math.bitXor";
    private static final String MATH_BIT_NOT_FUNCTION = "math.bitNot";
    private static final String MATH_BIT_LEFT_SHIFT_FUNCTION = "math.bitShiftLeft";
    private static final String MATH_BIT_RIGHT_SHIFT_FUNCTION = "math.bitShiftRight";
    private static final int MAX_BIT_SHIFT = 63;
    private static final ImmutableTable<Class, Class, BiFunction<Object, Object, Integer>> CLASSES_TO_COMPARATORS = CelMathExtensions.newComparatorTable();
    private final boolean enableUnsignedLongs;
    private final ImmutableSet<Function> functions;

    private static ImmutableTable<Class, Class, BiFunction<Object, Object, Integer>> newComparatorTable() {
        ImmutableTable.Builder<Class, Class, BiFunction<Object, Object, Integer>> builder = new ImmutableTable.Builder<Class, Class, BiFunction<Object, Object, Integer>>();
        builder.put(Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble((Long)x, (Double)y));
        builder.put(Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt((Double)x, (Long)y));
        builder.put(Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint((Double)x, (UnsignedLong)y));
        builder.put(UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble((UnsignedLong)x, (Double)y));
        builder.put(Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint((Long)x, (UnsignedLong)y));
        builder.put(UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt((UnsignedLong)x, (Long)y));
        return builder.buildOrThrow();
    }

    CelMathExtensions(CelOptions celOptions) {
        this(celOptions, ImmutableSet.copyOf(Function.values()));
    }

    CelMathExtensions(CelOptions celOptions, Set<Function> functions) {
        this.enableUnsignedLongs = celOptions.enableUnsignedLongs();
        this.functions = ImmutableSet.copyOf(functions);
    }

    @Override
    public void setParserOptions(CelParserBuilder parserBuilder) {
        parserBuilder.addMacros(CelMacro.newReceiverVarArgMacro("greatest", CelMathExtensions::expandGreatestMacro), CelMacro.newReceiverVarArgMacro("least", CelMathExtensions::expandLeastMacro));
    }

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        this.functions.forEach(function -> checkerBuilder.addFunctionDeclarations(((Function)function).functionDecl));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        this.functions.forEach(function -> {
            runtimeBuilder.addFunctionBindings(((Function)function).functionBindings);
            runtimeBuilder.addFunctionBindings(this.enableUnsignedLongs ? ((Function)function).functionBindingsULongUnsigned : ((Function)function).functionBindingsULongSigned);
        });
    }

    private static Optional<CelExpr> expandGreatestMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        if (!CelMathExtensions.isTargetInNamespace(target)) {
            return Optional.empty();
        }
        switch (arguments.size()) {
            case 0: {
                return CelMathExtensions.newError(exprFactory, "math.greatest() requires at least one argument", target);
            }
            case 1: {
                Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgumentSingleArg(exprFactory, "math.greatest()", (CelExpr)arguments.get(0));
                if (invalidArg.isPresent()) {
                    return invalidArg;
                }
                return Optional.of(exprFactory.newGlobalCall(MATH_MAX_FUNCTION, (CelExpr)arguments.get(0)));
            }
            case 2: {
                Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgument(exprFactory, "math.greatest()", arguments);
                if (invalidArg.isPresent()) {
                    return invalidArg;
                }
                return Optional.of(exprFactory.newGlobalCall(MATH_MAX_FUNCTION, arguments));
            }
        }
        Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgument(exprFactory, "math.greatest()", arguments);
        if (invalidArg.isPresent()) {
            return invalidArg;
        }
        return Optional.of(exprFactory.newGlobalCall(MATH_MAX_FUNCTION, exprFactory.newList(arguments)));
    }

    private static Comparable maxPair(Comparable x, Comparable y) {
        if (x.getClass().equals(y.getClass())) {
            return Comparators.max(x, y);
        }
        return (Integer)((BiFunction)CLASSES_TO_COMPARATORS.get(x.getClass(), y.getClass())).apply(x, y) >= 0 ? x : y;
    }

    private static Comparable maxList(List<Comparable> list) {
        if (list.isEmpty()) {
            throw new IllegalStateException("math.@max(list) argument must not be empty");
        }
        Comparable max = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            max = CelMathExtensions.maxPair(max, list.get(i));
        }
        return max;
    }

    private static Comparable minPair(Comparable x, Comparable y) {
        if (x.getClass().equals(y.getClass())) {
            return Comparators.min(x, y);
        }
        return (Integer)((BiFunction)CLASSES_TO_COMPARATORS.get(x.getClass(), y.getClass())).apply(x, y) <= 0 ? x : y;
    }

    private static long absExact(long x) {
        if (x == Long.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return Math.abs(x);
    }

    private static boolean isNaN(double x) {
        return Double.isNaN(x);
    }

    private static Double trunc(Double x) {
        if (CelMathExtensions.isNaN(x) || CelMathExtensions.isInfinite(x)) {
            return x;
        }
        return x.longValue();
    }

    private static boolean isInfinite(double x) {
        return Double.isInfinite(x);
    }

    private static double round(double x) {
        if (CelMathExtensions.isNaN(x) || CelMathExtensions.isInfinite(x)) {
            return x;
        }
        return DoubleMath.roundToLong(x, RoundingMode.HALF_EVEN);
    }

    private static Number sign(Number x) {
        if (x instanceof Double) {
            double val = x.doubleValue();
            if (CelMathExtensions.isNaN(val)) {
                return val;
            }
            if (val == 0.0) {
                return 0.0;
            }
            return val > 0.0 ? 1.0 : -1.0;
        }
        if (x instanceof Long) {
            long val = x.longValue();
            if (val == 0L) {
                return 0L;
            }
            return val > 0L ? 1L : -1L;
        }
        if (x instanceof UnsignedLong) {
            UnsignedLong val = (UnsignedLong)x;
            if (val.equals(UnsignedLong.ZERO)) {
                return val;
            }
            return UnsignedLong.ONE;
        }
        throw new IllegalArgumentException("Unsupported type: " + x.getClass());
    }

    private static Long intBitAnd(long x, long y) {
        return x & y;
    }

    private static UnsignedLong uintBitAnd(UnsignedLong x, UnsignedLong y) {
        return UnsignedLong.fromLongBits(x.longValue() & y.longValue());
    }

    private static Long intBitOr(long x, long y) {
        return x | y;
    }

    private static UnsignedLong uintBitOr(UnsignedLong x, UnsignedLong y) {
        return UnsignedLong.fromLongBits(x.longValue() | y.longValue());
    }

    private static Long intBitXor(long x, long y) {
        return x ^ y;
    }

    private static UnsignedLong uintBitXor(UnsignedLong x, UnsignedLong y) {
        return UnsignedLong.fromLongBits(x.longValue() ^ y.longValue());
    }

    private static Long intBitNot(long x) {
        return x ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static UnsignedLong uintBitNot(UnsignedLong x) {
        return UnsignedLong.fromLongBits(x.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static Long intBitShiftLeft(long value, long shiftAmount) {
        if (shiftAmount < 0L) {
            throw new IllegalArgumentException("math.bitShiftLeft() negative offset:" + shiftAmount);
        }
        if (shiftAmount > 63L) {
            return 0L;
        }
        return value << (int)shiftAmount;
    }

    private static UnsignedLong uintBitShiftLeft(UnsignedLong value, long shiftAmount) {
        if (shiftAmount < 0L) {
            throw new IllegalArgumentException("math.bitShiftLeft() negative offset:" + shiftAmount);
        }
        if (shiftAmount > 63L) {
            return UnsignedLong.ZERO;
        }
        return UnsignedLong.fromLongBits(value.longValue() << (int)shiftAmount);
    }

    private static Long intBitShiftRight(long value, long shiftAmount) {
        if (shiftAmount < 0L) {
            throw new IllegalArgumentException("math.bitShiftRight() negative offset:" + shiftAmount);
        }
        if (shiftAmount > 63L) {
            return 0L;
        }
        return value >>> (int)shiftAmount;
    }

    private static UnsignedLong uintBitShiftRight(UnsignedLong value, long shiftAmount) {
        if (shiftAmount < 0L) {
            throw new IllegalArgumentException("math.bitShiftRight() negative offset:" + shiftAmount);
        }
        if (shiftAmount > 63L) {
            return UnsignedLong.ZERO;
        }
        return UnsignedLong.fromLongBits(value.longValue() >>> (int)shiftAmount);
    }

    private static Comparable minList(List<Comparable> list) {
        if (list.isEmpty()) {
            throw new IllegalStateException("math.@min(list) argument must not be empty");
        }
        Comparable min2 = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            min2 = CelMathExtensions.minPair(min2, list.get(i));
        }
        return min2;
    }

    private static Optional<CelExpr> expandLeastMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        if (!CelMathExtensions.isTargetInNamespace(target)) {
            return Optional.empty();
        }
        switch (arguments.size()) {
            case 0: {
                return CelMathExtensions.newError(exprFactory, "math.least() requires at least one argument", target);
            }
            case 1: {
                Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgumentSingleArg(exprFactory, "math.least()", (CelExpr)arguments.get(0));
                if (invalidArg.isPresent()) {
                    return invalidArg;
                }
                return Optional.of(exprFactory.newGlobalCall(MATH_MIN_FUNCTION, (CelExpr)arguments.get(0)));
            }
            case 2: {
                Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgument(exprFactory, "math.least()", arguments);
                if (invalidArg.isPresent()) {
                    return invalidArg;
                }
                return Optional.of(exprFactory.newGlobalCall(MATH_MIN_FUNCTION, arguments));
            }
        }
        Optional<CelExpr> invalidArg = CelMathExtensions.checkInvalidArgument(exprFactory, "math.least()", arguments);
        if (invalidArg.isPresent()) {
            return invalidArg;
        }
        return Optional.of(exprFactory.newGlobalCall(MATH_MIN_FUNCTION, exprFactory.newList(arguments)));
    }

    private static boolean isTargetInNamespace(CelExpr target) {
        return target.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && target.ident().name().equals(MATH_NAMESPACE);
    }

    private static Optional<CelExpr> checkInvalidArgument(CelMacroExprFactory exprFactory, String functionName, List<CelExpr> arguments) {
        for (CelExpr arg : arguments) {
            if (CelMathExtensions.isArgumentValidType(arg)) continue;
            return CelMathExtensions.newError(exprFactory, String.format("%s simple literal arguments must be numeric", functionName), arg);
        }
        return Optional.empty();
    }

    private static Optional<CelExpr> checkInvalidArgumentSingleArg(CelMacroExprFactory exprFactory, String functionName, CelExpr argument) {
        if (argument.exprKind().getKind() == CelExpr.ExprKind.Kind.LIST) {
            if (((AbstractCollection)((Object)argument.list().elements())).isEmpty()) {
                return CelMathExtensions.newError(exprFactory, String.format("%s invalid single argument value", functionName), argument);
            }
            return CelMathExtensions.checkInvalidArgument(exprFactory, functionName, argument.list().elements());
        }
        if (CelMathExtensions.isArgumentValidType(argument)) {
            return Optional.empty();
        }
        return CelMathExtensions.newError(exprFactory, String.format("%s invalid single argument value", functionName), argument);
    }

    private static boolean isArgumentValidType(CelExpr argument) {
        if (argument.exprKind().getKind() == CelExpr.ExprKind.Kind.CONSTANT) {
            CelConstant constant = argument.constant();
            return constant.getKind() == CelConstant.Kind.INT64_VALUE || constant.getKind() == CelConstant.Kind.UINT64_VALUE || constant.getKind() == CelConstant.Kind.DOUBLE_VALUE;
        }
        return !argument.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) && !argument.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.STRUCT) && !argument.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.MAP);
    }

    private static Optional<CelExpr> newError(CelMacroExprFactory exprFactory, String errorMessage, CelExpr argument) {
        return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(argument), errorMessage)));
    }

    static enum Function {
        MAX(CelFunctionDecl.newFunctionDeclaration("math.@max", CelOverloadDecl.newGlobalOverload("math_@max_double", "Returns the greatest valued number present in the arguments.", SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@max_int", "Returns the greatest valued number present in the arguments.", SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@max_uint", "Returns the greatest valued number present in the arguments.", SimpleType.UINT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@max_double_double", "Returns the greatest valued number present in the arguments.", SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@max_int_int", "Returns the greatest valued number present in the arguments.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@max_uint_uint", "Returns the greatest valued number present in the arguments.", SimpleType.UINT, SimpleType.UINT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@max_int_uint", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.INT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@max_int_double", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.INT, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@max_double_int", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.DOUBLE, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@max_double_uint", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.DOUBLE, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@max_uint_int", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.UINT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@max_uint_double", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, SimpleType.UINT, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@max_list_dyn", "Returns the greatest valued number present in the arguments.", SimpleType.DYN, ListType.create(SimpleType.DYN))), ImmutableSet.of(CelFunctionBinding.from("math_@max_double", Double.class, x -> x), CelFunctionBinding.from("math_@max_int", Long.class, x -> x), CelFunctionBinding.from("math_@max_double_double", Double.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_int_double", Long.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_double_int", Double.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), new CelFunctionBinding[]{CelFunctionBinding.from("math_@max_list_dyn", List.class, x$0 -> CelMathExtensions.access$2100(x$0))}), ImmutableSet.of(CelFunctionBinding.from("math_@max_uint", Long.class, x -> x), CelFunctionBinding.from("math_@max_uint_uint", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_double_uint", Double.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_uint_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_uint_double", Long.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_int_uint", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), new CelFunctionBinding[0]), ImmutableSet.of(CelFunctionBinding.from("math_@max_uint", UnsignedLong.class, x -> x), CelFunctionBinding.from("math_@max_uint_uint", UnsignedLong.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_double_uint", Double.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_uint_int", UnsignedLong.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_uint_double", UnsignedLong.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), CelFunctionBinding.from("math_@max_int_uint", Long.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$2000(x$0, x$1)), new CelFunctionBinding[0])),
        MIN(CelFunctionDecl.newFunctionDeclaration("math.@min", CelOverloadDecl.newGlobalOverload("math_@min_double", "Returns the least valued number present in the arguments.", SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@min_int", "Returns the least valued number present in the arguments.", SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@min_uint", "Returns the least valued number present in the arguments.", SimpleType.UINT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@min_double_double", "Returns the least valued number present in the arguments.", SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@min_int_int", "Returns the least valued number present in the arguments.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@min_uint_uint", "Returns the least valued number present in the arguments.", SimpleType.UINT, SimpleType.UINT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@min_int_uint", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.INT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@min_int_double", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.INT, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@min_double_int", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.DOUBLE, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@min_double_uint", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.DOUBLE, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_@min_uint_int", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.UINT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_@min_uint_double", "Returns the least valued number present in the arguments.", SimpleType.DYN, SimpleType.UINT, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_@min_list_dyn", "Returns the least valued number present in the arguments.", SimpleType.DYN, ListType.create(SimpleType.DYN))), ImmutableSet.of(CelFunctionBinding.from("math_@min_double", Double.class, x -> x), CelFunctionBinding.from("math_@min_int", Long.class, x -> x), CelFunctionBinding.from("math_@min_double_double", Double.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_int_double", Long.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_double_int", Double.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), new CelFunctionBinding[]{CelFunctionBinding.from("math_@min_list_dyn", List.class, x$0 -> CelMathExtensions.access$1900(x$0))}), ImmutableSet.of(CelFunctionBinding.from("math_@min_uint", Long.class, x -> x), CelFunctionBinding.from("math_@min_uint_uint", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_double_uint", Double.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_uint_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_uint_double", Long.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_int_uint", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), new CelFunctionBinding[0]), ImmutableSet.of(CelFunctionBinding.from("math_@min_uint", UnsignedLong.class, x -> x), CelFunctionBinding.from("math_@min_uint_uint", UnsignedLong.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_double_uint", Double.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_uint_int", UnsignedLong.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_uint_double", UnsignedLong.class, Double.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), CelFunctionBinding.from("math_@min_int_uint", Long.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$1800(x$0, x$1)), new CelFunctionBinding[0])),
        CEIL(CelFunctionDecl.newFunctionDeclaration("math.ceil", CelOverloadDecl.newGlobalOverload("math_ceil_double", "Compute the ceiling of a double value.", SimpleType.DOUBLE, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_ceil_double", Double.class, Math::ceil))),
        FLOOR(CelFunctionDecl.newFunctionDeclaration("math.floor", CelOverloadDecl.newGlobalOverload("math_floor_double", "Compute the floor of a double value.", SimpleType.DOUBLE, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_floor_double", Double.class, Math::floor))),
        ROUND(CelFunctionDecl.newFunctionDeclaration("math.round", CelOverloadDecl.newGlobalOverload("math_round_double", "Rounds the double value to the nearest whole number with ties rounding away from zero.", SimpleType.DOUBLE, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_round_double", Double.class, x$0 -> CelMathExtensions.access$1700(x$0)))),
        TRUNC(CelFunctionDecl.newFunctionDeclaration("math.trunc", CelOverloadDecl.newGlobalOverload("math_trunc_double", "Truncates the fractional portion of the double value.", SimpleType.DOUBLE, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_trunc_double", Double.class, x$0 -> CelMathExtensions.access$1600(x$0)))),
        ISFINITE(CelFunctionDecl.newFunctionDeclaration("math.isFinite", CelOverloadDecl.newGlobalOverload("math_isFinite_double", "Returns true if the value is a finite number.", SimpleType.BOOL, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_isFinite_double", Double.class, Double::isFinite))),
        ISNAN(CelFunctionDecl.newFunctionDeclaration("math.isNaN", CelOverloadDecl.newGlobalOverload("math_isNaN_double", "Returns true if the input double value is NaN, false otherwise.", SimpleType.BOOL, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_isNaN_double", Double.class, x$0 -> CelMathExtensions.access$1500(x$0)))),
        ISINF(CelFunctionDecl.newFunctionDeclaration("math.isInf", CelOverloadDecl.newGlobalOverload("math_isInf_double", "Returns true if the input double value is -Inf or +Inf.", SimpleType.BOOL, SimpleType.DOUBLE)), ImmutableSet.of(CelFunctionBinding.from("math_isInf_double", Double.class, x$0 -> CelMathExtensions.access$1400(x$0)))),
        ABS(CelFunctionDecl.newFunctionDeclaration("math.abs", CelOverloadDecl.newGlobalOverload("math_abs_double", "Compute the absolute value of a double value.", SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_abs_int", "Compute the absolute value of an int value.", SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_abs_uint", "Compute the absolute value of a uint value.", SimpleType.UINT, SimpleType.UINT)), ImmutableSet.of(CelFunctionBinding.from("math_abs_double", Double.class, Math::abs), CelFunctionBinding.from("math_abs_int", Long.class, x$0 -> CelMathExtensions.access$1300(x$0)), CelFunctionBinding.from("math_abs_uint", UnsignedLong.class, x -> x))),
        SIGN(CelFunctionDecl.newFunctionDeclaration("math.sign", CelOverloadDecl.newGlobalOverload("math_sign_double", "Returns the sign of the input numeric type, either -1, 0, 1 cast as double.", SimpleType.DOUBLE, SimpleType.DOUBLE), CelOverloadDecl.newGlobalOverload("math_sign_uint", "Returns the sign of the input numeric type, either -1, 0, 1 case as uint.", SimpleType.UINT, SimpleType.UINT), CelOverloadDecl.newGlobalOverload("math_sign_int", "Returns the sign of the input numeric type, either -1, 0, 1.", SimpleType.INT, SimpleType.INT)), ImmutableSet.of(CelFunctionBinding.from("math_sign_double", Double.class, x$0 -> CelMathExtensions.access$1200(x$0)), CelFunctionBinding.from("math_sign_int", Long.class, x$0 -> CelMathExtensions.access$1200(x$0)), CelFunctionBinding.from("math_sign_uint", UnsignedLong.class, x$0 -> CelMathExtensions.access$1200(x$0)))),
        BITAND(CelFunctionDecl.newFunctionDeclaration("math.bitAnd", CelOverloadDecl.newGlobalOverload("math_bitAnd_int_int", "Performs a bitwise-AND operation over two int values.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitAnd_uint_uint", "Performs a bitwise-AND operation over two uint values.", SimpleType.UINT, SimpleType.UINT, SimpleType.UINT)), ImmutableSet.of(CelFunctionBinding.from("math_bitAnd_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$1100(x$0, x$1)), CelFunctionBinding.from("math_bitAnd_uint_uint", UnsignedLong.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$1000(x$0, x$1)))),
        BITOR(CelFunctionDecl.newFunctionDeclaration("math.bitOr", CelOverloadDecl.newGlobalOverload("math_bitOr_int_int", "Performs a bitwise-OR operation over two int values.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitOr_uint_uint", "Performs a bitwise-OR operation over two uint values.", SimpleType.UINT, SimpleType.UINT, SimpleType.UINT)), ImmutableSet.of(CelFunctionBinding.from("math_bitOr_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$900(x$0, x$1)), CelFunctionBinding.from("math_bitOr_uint_uint", UnsignedLong.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$800(x$0, x$1)))),
        BITXOR(CelFunctionDecl.newFunctionDeclaration("math.bitXor", CelOverloadDecl.newGlobalOverload("math_bitXor_int_int", "Performs a bitwise-XOR operation over two int values.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitXor_uint_uint", "Performs a bitwise-XOR operation over two uint values.", SimpleType.UINT, SimpleType.UINT, SimpleType.UINT)), ImmutableSet.of(CelFunctionBinding.from("math_bitXor_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$700(x$0, x$1)), CelFunctionBinding.from("math_bitXor_uint_uint", UnsignedLong.class, UnsignedLong.class, (x$0, x$1) -> CelMathExtensions.access$600(x$0, x$1)))),
        BITNOT(CelFunctionDecl.newFunctionDeclaration("math.bitNot", CelOverloadDecl.newGlobalOverload("math_bitNot_int_int", "Performs a bitwise-NOT operation over two int values.", SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitNot_uint_uint", "Performs a bitwise-NOT operation over two uint values.", SimpleType.UINT, SimpleType.UINT)), ImmutableSet.of(CelFunctionBinding.from("math_bitNot_int_int", Long.class, x$0 -> CelMathExtensions.access$500(x$0)), CelFunctionBinding.from("math_bitNot_uint_uint", UnsignedLong.class, x$0 -> CelMathExtensions.access$400(x$0)))),
        BITSHIFTLEFT(CelFunctionDecl.newFunctionDeclaration("math.bitShiftLeft", CelOverloadDecl.newGlobalOverload("math_bitShiftLeft_int_int", "Performs a bitwise-SHIFTLEFT operation over two int values.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitShiftLeft_uint_int", "Performs a bitwise-SHIFTLEFT operation over two uint values.", SimpleType.UINT, SimpleType.UINT, SimpleType.INT)), ImmutableSet.of(CelFunctionBinding.from("math_bitShiftLeft_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$300(x$0, x$1)), CelFunctionBinding.from("math_bitShiftLeft_uint_int", UnsignedLong.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$200(x$0, x$1)))),
        BITSHIFTRIGHT(CelFunctionDecl.newFunctionDeclaration("math.bitShiftRight", CelOverloadDecl.newGlobalOverload("math_bitShiftRight_int_int", "Performs a bitwise-SHIFTRIGHT operation over two int values.", SimpleType.INT, SimpleType.INT, SimpleType.INT), CelOverloadDecl.newGlobalOverload("math_bitShiftRight_uint_int", "Performs a bitwise-SHIFTRIGHT operation over two uint values.", SimpleType.UINT, SimpleType.UINT, SimpleType.INT)), ImmutableSet.of(CelFunctionBinding.from("math_bitShiftRight_int_int", Long.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$100(x$0, x$1)), CelFunctionBinding.from("math_bitShiftRight_uint_int", UnsignedLong.class, Long.class, (x$0, x$1) -> CelMathExtensions.access$000(x$0, x$1))));

        private final CelFunctionDecl functionDecl;
        private final ImmutableSet<CelFunctionBinding> functionBindings;
        private final ImmutableSet<CelFunctionBinding> functionBindingsULongSigned;
        private final ImmutableSet<CelFunctionBinding> functionBindingsULongUnsigned;

        String getFunction() {
            return this.functionDecl.name();
        }

        private Function(CelFunctionDecl functionDecl, ImmutableSet<CelFunctionBinding> bindings) {
            this(functionDecl, bindings, ImmutableSet.of(), ImmutableSet.of());
        }

        private Function(CelFunctionDecl functionDecl, ImmutableSet<CelFunctionBinding> functionBindings, ImmutableSet<CelFunctionBinding> functionBindingsULongSigned, ImmutableSet<CelFunctionBinding> functionBindingsULongUnsigned) {
            this.functionDecl = functionDecl;
            this.functionBindings = functionBindings;
            this.functionBindingsULongSigned = functionBindingsULongSigned;
            this.functionBindingsULongUnsigned = functionBindingsULongUnsigned;
        }
    }
}

