/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelIssue;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.Constants;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.CelParserBuilder;
import java.util.Optional;

@Immutable
final class CelProtoExtensions
implements CelCompilerLibrary {
    private static final String PROTO_NAMESPACE = "proto";
    private static final CelExpr ERROR = CelExpr.newBuilder().setConstant(Constants.ERROR).build();

    CelProtoExtensions() {
    }

    @Override
    public void setParserOptions(CelParserBuilder parserBuilder) {
        parserBuilder.addMacros(CelMacro.newReceiverMacro("hasExt", 2, CelProtoExtensions::expandHasProtoExt), CelMacro.newReceiverMacro("getExt", 2, CelProtoExtensions::expandGetProtoExt));
    }

    private static Optional<CelExpr> expandHasProtoExt(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        return CelProtoExtensions.expandProtoExt(exprFactory, target, arguments, true);
    }

    private static Optional<CelExpr> expandGetProtoExt(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        return CelProtoExtensions.expandProtoExt(exprFactory, target, arguments, false);
    }

    private static Optional<CelExpr> expandProtoExt(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments, boolean testOnly) {
        if (!CelProtoExtensions.isTargetInNamespace(target)) {
            return Optional.empty();
        }
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        CelExpr arg2 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        StringBuilder extensionFieldNameBuilder = new StringBuilder();
        CelExpr result = CelProtoExtensions.getExtensionFieldName(arg2, extensionFieldNameBuilder);
        if (result.equals(ERROR)) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(arg2), "invalid extension field")));
        }
        return Optional.of(exprFactory.newSelect(arg1, extensionFieldNameBuilder.toString(), testOnly));
    }

    private static CelExpr getExtensionFieldName(CelExpr target, StringBuilder sb) {
        if (target.exprKind().getKind() != CelExpr.ExprKind.Kind.SELECT) {
            return ERROR;
        }
        return CelProtoExtensions.buildExtensionFieldName(target, sb);
    }

    private static CelExpr buildExtensionFieldName(CelExpr target, StringBuilder sb) {
        switch (target.exprKind().getKind()) {
            case IDENT: {
                sb.append(target.ident().name());
                return target;
            }
            case SELECT: {
                CelExpr.CelSelect select = target.select();
                if (select.testOnly()) {
                    return ERROR;
                }
                CelExpr operand = CelProtoExtensions.buildExtensionFieldName(select.operand(), sb);
                if (operand.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
                    return ERROR;
                }
                sb.append(".").append(select.field());
                return operand;
            }
        }
        return ERROR;
    }

    private static boolean isTargetInNamespace(CelExpr target) {
        return target.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && target.ident().name().equals(PROTO_NAMESPACE);
    }
}

