/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.Immutable;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.internal.CelCodePointArray;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.SimpleType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationExceptionBuilder;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Immutable
public final class CelStringExtensions
implements CelCompilerLibrary,
CelRuntimeLibrary {
    private final ImmutableSet<Function> functions;

    CelStringExtensions() {
        this(ImmutableSet.copyOf(Function.values()));
    }

    CelStringExtensions(Set<Function> functions) {
        this.functions = ImmutableSet.copyOf(functions);
    }

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        this.functions.forEach(function -> checkerBuilder.addFunctionDeclarations(((Function)function).functionDecl));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        this.functions.forEach(function -> runtimeBuilder.addFunctionBindings(((Function)function).functionBindings));
    }

    private static String charAt(String s2, long i) throws CelEvaluationException {
        int index;
        try {
            index = Math.toIntExact(i);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("charAt failure: Index must not exceed the int32 range: %d", i).setCause(e).build();
        }
        CelCodePointArray codePointArray = CelCodePointArray.fromString(s2);
        if (index == codePointArray.length()) {
            return "";
        }
        if (index < 0 || index > codePointArray.length()) {
            throw CelEvaluationExceptionBuilder.newBuilder("charAt failure: Index out of range: %d", index).build();
        }
        return codePointArray.slice(index, index + 1).toString();
    }

    private static Long indexOf(String str, String substr) throws CelEvaluationException {
        Object[] params = new Object[]{str, substr, 0L};
        return CelStringExtensions.indexOf(params);
    }

    private static Long indexOf(Object[] args) throws CelEvaluationException {
        int offset;
        String str = (String)args[0];
        String substr = (String)args[1];
        long offsetInLong = (Long)args[2];
        try {
            offset = Math.toIntExact(offsetInLong);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("indexOf failure: Offset must not exceed the int32 range: %d", offsetInLong).setCause(e).build();
        }
        return CelStringExtensions.indexOf(str, substr, offset);
    }

    private static Long indexOf(String str, String substr, int offset) throws CelEvaluationException {
        if (substr.isEmpty()) {
            return offset;
        }
        CelCodePointArray strCpa = CelCodePointArray.fromString(str);
        CelCodePointArray substrCpa = CelCodePointArray.fromString(substr);
        if (offset < 0 || offset >= strCpa.length()) {
            throw CelEvaluationExceptionBuilder.newBuilder("indexOf failure: Offset out of range: %d", offset).build();
        }
        return CelStringExtensions.safeIndexOf(strCpa, substrCpa, offset);
    }

    private static Long safeIndexOf(CelCodePointArray str, CelCodePointArray substr, int offset) {
        for (int i = offset; i < str.length() - (substr.length() - 1); ++i) {
            int j;
            for (j = 0; j < substr.length() && str.get(i + j) == substr.get(j); ++j) {
            }
            if (j != substr.length()) continue;
            return i;
        }
        return -1L;
    }

    private static String join(List<String> stringList) {
        return CelStringExtensions.join(stringList, "");
    }

    private static String join(List<String> stringList, String separator) {
        return Joiner.on(separator).join(stringList);
    }

    private static Long lastIndexOf(String str, String substr) throws CelEvaluationException {
        CelCodePointArray strCpa = CelCodePointArray.fromString(str);
        CelCodePointArray substrCpa = CelCodePointArray.fromString(substr);
        if (substrCpa.isEmpty()) {
            return strCpa.length();
        }
        if (strCpa.length() < substrCpa.length()) {
            return -1L;
        }
        return CelStringExtensions.lastIndexOf(strCpa, substrCpa, (long)strCpa.length() - 1L);
    }

    private static Long lastIndexOf(Object[] args) throws CelEvaluationException {
        CelCodePointArray strCpa = CelCodePointArray.fromString((String)args[0]);
        CelCodePointArray substrCpa = CelCodePointArray.fromString((String)args[1]);
        long offset = (Long)args[2];
        return CelStringExtensions.lastIndexOf(strCpa, substrCpa, offset);
    }

    private static Long lastIndexOf(CelCodePointArray str, CelCodePointArray substr, long offset) throws CelEvaluationException {
        int off;
        if (substr.isEmpty()) {
            return offset;
        }
        try {
            off = Math.toIntExact(offset);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("lastIndexOf failure: Offset must not exceed the int32 range: %d", offset).setCause(e).build();
        }
        if (off < 0 || off >= str.length()) {
            throw CelEvaluationExceptionBuilder.newBuilder("lastIndexOf failure: Offset out of range: %d", offset).build();
        }
        if (off > str.length() - substr.length()) {
            off = str.length() - substr.length();
        }
        for (int i = off; i >= 0; --i) {
            int j;
            for (j = 0; j < substr.length() && str.get(i + j) == substr.get(j); ++j) {
            }
            if (j != substr.length()) continue;
            return i;
        }
        return -1L;
    }

    private static String replaceAll(Object[] objects) {
        return CelStringExtensions.replace((String)objects[0], (String)objects[1], (String)objects[2], -1);
    }

    private static String replace(Object[] objects) throws CelEvaluationException {
        int index;
        Long indexInLong = (Long)objects[3];
        try {
            index = Math.toIntExact(indexInLong);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("replace failure: Index must not exceed the int32 range: %d", indexInLong).setCause(e).build();
        }
        return CelStringExtensions.replace((String)objects[0], (String)objects[1], (String)objects[2], index);
    }

    private static String replace(String text, String searchString, String replacement, int limit) {
        if (searchString.equals(replacement) || limit == 0) {
            return text;
        }
        if (text.isEmpty()) {
            return searchString.isEmpty() ? replacement : "";
        }
        CelCodePointArray textCpa = CelCodePointArray.fromString(text);
        CelCodePointArray searchCpa = CelCodePointArray.fromString(searchString);
        CelCodePointArray replaceCpa = CelCodePointArray.fromString(replacement);
        int start = 0;
        int end = Math.toIntExact(CelStringExtensions.safeIndexOf(textCpa, searchCpa, 0));
        if (end < 0) {
            return text;
        }
        int minSearchLength = Math.max(searchCpa.length(), 1);
        StringBuilder sb = new StringBuilder(textCpa.length() - searchCpa.length() + replaceCpa.length());
        do {
            CelCodePointArray sliced = textCpa.slice(start, end);
            sb.append(sliced).append(replaceCpa);
            start = end + searchCpa.length();
        } while (--limit != 0 && (end = Math.toIntExact(CelStringExtensions.safeIndexOf(textCpa, searchCpa, end + minSearchLength))) > 0);
        return sb.append(textCpa.slice(start, textCpa.length())).toString();
    }

    private static List<String> split(String str, String separator) {
        return CelStringExtensions.split(str, separator, Integer.MAX_VALUE);
    }

    private static List<String> split(Object[] args) throws CelEvaluationException {
        int limit;
        long limitInLong = (Long)args[2];
        try {
            limit = Math.toIntExact(limitInLong);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("split failure: Limit must not exceed the int32 range: %d", limitInLong).setCause(e).build();
        }
        return CelStringExtensions.split((String)args[0], (String)args[1], limit);
    }

    private static List<String> split(String str, String separator, int limit) {
        if (limit == 0) {
            return new ArrayList<String>();
        }
        if (limit == 1) {
            ArrayList<String> singleElementList = new ArrayList<String>();
            singleElementList.add(str);
            return singleElementList;
        }
        if (limit < 0) {
            limit = str.length();
        }
        if (separator.isEmpty()) {
            return CelStringExtensions.explode(str, limit);
        }
        Iterable<String> splitString = Splitter.on(separator).limit(limit).split(str);
        return Lists.newArrayList(splitString);
    }

    private static List<String> explode(String str, int limit) {
        ArrayList<String> exploded = new ArrayList<String>();
        CelCodePointArray codePointArray = CelCodePointArray.fromString(str);
        if (limit > 0) {
            --limit;
        }
        int charCount = Math.min(codePointArray.length(), limit);
        for (int i = 0; i < charCount; ++i) {
            exploded.add(codePointArray.slice(i, i + 1).toString());
        }
        if (codePointArray.length() > limit) {
            exploded.add(codePointArray.slice(limit, codePointArray.length()).toString());
        }
        return exploded;
    }

    private static Object substring(String s2, long i) throws CelEvaluationException {
        boolean indexIsInRange;
        int beginIndex;
        try {
            beginIndex = Math.toIntExact(i);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("substring failure: Index must not exceed the int32 range: %d", i).setCause(e).build();
        }
        CelCodePointArray codePointArray = CelCodePointArray.fromString(s2);
        boolean bl = indexIsInRange = beginIndex <= codePointArray.length() && beginIndex >= 0;
        if (!indexIsInRange) {
            throw CelEvaluationExceptionBuilder.newBuilder("substring failure: Range [%d, %d) out of bounds", beginIndex, codePointArray.length()).build();
        }
        if (beginIndex == codePointArray.length()) {
            return "";
        }
        return codePointArray.slice(beginIndex, codePointArray.length()).toString();
    }

    private static String substring(Object[] args) throws CelEvaluationException {
        boolean indicesIsInRange;
        int endIndex;
        int beginIndex;
        Long beginIndexInLong = (Long)args[1];
        Long endIndexInLong = (Long)args[2];
        try {
            beginIndex = Math.toIntExact(beginIndexInLong);
            endIndex = Math.toIntExact(endIndexInLong);
        }
        catch (ArithmeticException e) {
            throw CelEvaluationExceptionBuilder.newBuilder("substring failure: Indices must not exceed the int32 range: [%d, %d)", beginIndexInLong, endIndexInLong).setCause(e).build();
        }
        String s2 = (String)args[0];
        CelCodePointArray codePointArray = CelCodePointArray.fromString(s2);
        boolean bl = indicesIsInRange = beginIndex <= endIndex && beginIndex >= 0 && beginIndex <= codePointArray.length() && endIndex <= codePointArray.length();
        if (!indicesIsInRange) {
            throw CelEvaluationExceptionBuilder.newBuilder("substring failure: Range [%d, %d) out of bounds", beginIndex, endIndex).build();
        }
        if (beginIndex == endIndex) {
            return "";
        }
        return codePointArray.slice(beginIndex, endIndex).toString();
    }

    private static String trim(String text) {
        CelCodePointArray textCpa = CelCodePointArray.fromString(text);
        int left = CelStringExtensions.indexOfNonWhitespace(textCpa);
        if (left == textCpa.length()) {
            return "";
        }
        int right = CelStringExtensions.lastIndexOfNonWhitespace(textCpa);
        return textCpa.slice(left, right + 1).toString();
    }

    private static int indexOfNonWhitespace(CelCodePointArray textCpa) {
        for (int i = 0; i < textCpa.length(); ++i) {
            if (CelStringExtensions.isWhitespace(textCpa.get(i))) continue;
            return i;
        }
        return textCpa.length();
    }

    private static int lastIndexOfNonWhitespace(CelCodePointArray textCpa) {
        if (textCpa.isEmpty()) {
            return -1;
        }
        for (int i = textCpa.length() - 1; i >= 0; --i) {
            if (CelStringExtensions.isWhitespace(textCpa.get(i))) continue;
            return i;
        }
        return 0;
    }

    private static boolean isWhitespace(int codePoint) {
        return codePoint >= 9 && codePoint <= 13 || codePoint == 32 || codePoint == 133 || codePoint == 160 || codePoint == 5760 || codePoint >= 8192 && codePoint <= 8202 || codePoint == 8232 || codePoint == 8233 || codePoint == 8239 || codePoint == 8287 || codePoint == 12288;
    }

    public static enum Function {
        CHAR_AT(CelFunctionDecl.newFunctionDeclaration("charAt", CelOverloadDecl.newMemberOverload("string_char_at_int", "Returns the character at the given position. If the position is negative, or greater than the length of the string, the function will produce an error.", SimpleType.STRING, ImmutableList.of(SimpleType.STRING, SimpleType.INT))), CelFunctionBinding.from("string_char_at_int", String.class, Long.class, (x$0, x$1) -> CelStringExtensions.access$1300(x$0, x$1))),
        INDEX_OF(CelFunctionDecl.newFunctionDeclaration("indexOf", CelOverloadDecl.newMemberOverload("string_index_of_string", "Returns the integer index of the first occurrence of the search string. If the search string is not found the function returns -1.", SimpleType.INT, ImmutableList.of(SimpleType.STRING, SimpleType.STRING)), CelOverloadDecl.newMemberOverload("string_index_of_string_int", "Returns the integer index of the first occurrence of the search string from the given offset. If the search string is not found the function returns -1. If the substring is the empty string, the index where the search starts is returned (zero or custom).", SimpleType.INT, ImmutableList.of(SimpleType.STRING, SimpleType.STRING, SimpleType.INT))), CelFunctionBinding.from("string_index_of_string", String.class, String.class, (x$0, x$1) -> CelStringExtensions.access$1200(x$0, x$1)), CelFunctionBinding.from("string_index_of_string_int", ImmutableList.of(String.class, String.class, Long.class), x$0 -> CelStringExtensions.access$1100(x$0))),
        JOIN(CelFunctionDecl.newFunctionDeclaration("join", CelOverloadDecl.newMemberOverload("list_join", "Returns a new string where the elements of string list are concatenated.", SimpleType.STRING, ListType.create(SimpleType.STRING)), CelOverloadDecl.newMemberOverload("list_join_string", "Returns a new string where the elements of string list are concatenated using the separator.", SimpleType.STRING, ImmutableList.of(ListType.create(SimpleType.STRING), SimpleType.STRING))), CelFunctionBinding.from("list_join", List.class, x$0 -> CelStringExtensions.access$1000(x$0)), CelFunctionBinding.from("list_join_string", List.class, String.class, (x$0, x$1) -> CelStringExtensions.access$900(x$0, x$1))),
        LAST_INDEX_OF(CelFunctionDecl.newFunctionDeclaration("lastIndexOf", CelOverloadDecl.newMemberOverload("string_last_index_of_string", "Returns the integer index of the last occurrence of the search string. If the search string is not found the function returns -1.", SimpleType.INT, ImmutableList.of(SimpleType.STRING, SimpleType.STRING)), CelOverloadDecl.newMemberOverload("string_last_index_of_string_int", "Returns the integer index of the last occurrence of the search string from the given offset. If the search string is not found the function returns -1. If the substring is the empty string, the index where the search starts is returned (string length or custom).", SimpleType.INT, ImmutableList.of(SimpleType.STRING, SimpleType.STRING, SimpleType.INT))), CelFunctionBinding.from("string_last_index_of_string", String.class, String.class, (x$0, x$1) -> CelStringExtensions.access$800(x$0, x$1)), CelFunctionBinding.from("string_last_index_of_string_int", ImmutableList.of(String.class, String.class, Long.class), x$0 -> CelStringExtensions.access$700(x$0))),
        LOWER_ASCII(CelFunctionDecl.newFunctionDeclaration("lowerAscii", CelOverloadDecl.newMemberOverload("string_lower_ascii", "Returns a new string where all ASCII characters are lower-cased. This function does not perform Unicode case-mapping for characters outside the ASCII range.", SimpleType.STRING, SimpleType.STRING)), CelFunctionBinding.from("string_lower_ascii", String.class, Ascii::toLowerCase)),
        REPLACE(CelFunctionDecl.newFunctionDeclaration("replace", CelOverloadDecl.newMemberOverload("string_replace_string_string", "Returns a new string based on the target, which replaces the occurrences of a search string with a replacement string if present.", SimpleType.STRING, ImmutableList.of(SimpleType.STRING, SimpleType.STRING, SimpleType.STRING)), CelOverloadDecl.newMemberOverload("string_replace_string_string_int", "Returns a new string based on the target, which replaces the occurrences of a search string with a replacement string if present. The function accepts a limit on the number of substring replacements to be made. When the replacement limit is 0, the result is the original string. When the limit is a negative number, the function behaves the same as replace all.", SimpleType.STRING, ImmutableList.of(SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INT))), CelFunctionBinding.from("string_replace_string_string", ImmutableList.of(String.class, String.class, String.class), x$0 -> CelStringExtensions.access$600(x$0)), CelFunctionBinding.from("string_replace_string_string_int", ImmutableList.of(String.class, String.class, String.class, Long.class), x$0 -> CelStringExtensions.access$500(x$0))),
        SPLIT(CelFunctionDecl.newFunctionDeclaration("split", CelOverloadDecl.newMemberOverload("string_split_string", "Returns a mutable list of strings split from the input by the given separator.", (CelType)ListType.create(SimpleType.STRING), ImmutableList.of(SimpleType.STRING, SimpleType.STRING)), CelOverloadDecl.newMemberOverload("string_split_string_int", "Returns a mutable list of strings split from the input by the given separator with the specified limit on the number of substrings produced by the split.", (CelType)ListType.create(SimpleType.STRING), ImmutableList.of(SimpleType.STRING, SimpleType.STRING, SimpleType.INT))), CelFunctionBinding.from("string_split_string", String.class, String.class, (x$0, x$1) -> CelStringExtensions.access$400(x$0, x$1)), CelFunctionBinding.from("string_split_string_int", ImmutableList.of(String.class, String.class, Long.class), x$0 -> CelStringExtensions.access$300(x$0))),
        SUBSTRING(CelFunctionDecl.newFunctionDeclaration("substring", CelOverloadDecl.newMemberOverload("string_substring_int", "returns a string that is a substring of this string. The substring begins with the character at the specified index and extends to the end of this string.", SimpleType.STRING, ImmutableList.of(SimpleType.STRING, SimpleType.INT)), CelOverloadDecl.newMemberOverload("string_substring_int_int", "returns a string that is a substring of this string. The substring begins at the specified beginIndex and extends to the character at index endIndex - 1. Thus the length of the substring is {@code endIndex-beginIndex}.", SimpleType.STRING, ImmutableList.of(SimpleType.STRING, SimpleType.INT, SimpleType.INT))), CelFunctionBinding.from("string_substring_int", String.class, Long.class, (x$0, x$1) -> CelStringExtensions.access$200(x$0, x$1)), CelFunctionBinding.from("string_substring_int_int", ImmutableList.of(String.class, Long.class, Long.class), x$0 -> CelStringExtensions.access$100(x$0))),
        TRIM(CelFunctionDecl.newFunctionDeclaration("trim", CelOverloadDecl.newMemberOverload("string_trim", "Returns a new string which removes the leading and trailing whitespace in the target string. The trim function uses the Unicode definition of whitespace which does not include the zero-width spaces. ", SimpleType.STRING, SimpleType.STRING)), CelFunctionBinding.from("string_trim", String.class, x$0 -> CelStringExtensions.access$000(x$0))),
        UPPER_ASCII(CelFunctionDecl.newFunctionDeclaration("upperAscii", CelOverloadDecl.newMemberOverload("string_upper_ascii", "Returns a new string where all ASCII characters are upper-cased. This function does not perform Unicode case-mapping for characters outside the ASCII range.", SimpleType.STRING, SimpleType.STRING)), CelFunctionBinding.from("string_upper_ascii", String.class, Ascii::toUpperCase));

        private final CelFunctionDecl functionDecl;
        private final ImmutableSet<CelFunctionBinding> functionBindings;

        String getFunction() {
            return this.functionDecl.name();
        }

        private Function(CelFunctionDecl functionDecl, CelFunctionBinding ... functionBindings) {
            this.functionDecl = functionDecl;
            this.functionBindings = ImmutableSet.copyOf(functionBindings);
        }
    }
}

