/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import dev.cel.extensions.SetsFunction;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelLiteRuntimeBuilder;
import dev.cel.runtime.CelLiteRuntimeLibrary;
import dev.cel.runtime.RuntimeEquality;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

@Immutable
final class SetsExtensionsRuntimeImpl
implements CelLiteRuntimeLibrary {
    private final RuntimeEquality runtimeEquality;
    private final ImmutableSet<SetsFunction> functions;

    SetsExtensionsRuntimeImpl(RuntimeEquality runtimeEquality, Set<SetsFunction> functions) {
        this.runtimeEquality = runtimeEquality;
        this.functions = ImmutableSet.copyOf(functions);
    }

    @Override
    public void setRuntimeOptions(CelLiteRuntimeBuilder runtimeBuilder) {
        runtimeBuilder.addFunctionBindings(this.newFunctionBindings());
    }

    ImmutableSet<CelFunctionBinding> newFunctionBindings() {
        ImmutableSet.Builder bindingBuilder = ImmutableSet.builder();
        for (SetsFunction function : this.functions) {
            switch (function) {
                case CONTAINS: {
                    bindingBuilder.add(CelFunctionBinding.from("list_sets_contains_list", Collection.class, Collection.class, this::containsAll));
                    break;
                }
                case EQUIVALENT: {
                    bindingBuilder.add(CelFunctionBinding.from("list_sets_equivalent_list", Collection.class, Collection.class, (listA, listB) -> this.containsAll((Collection<?>)listA, (Collection<?>)listB) && this.containsAll((Collection<?>)listB, (Collection<?>)listA)));
                    break;
                }
                case INTERSECTS: {
                    bindingBuilder.add(CelFunctionBinding.from("list_sets_intersects_list", Collection.class, Collection.class, this::setIntersects));
                }
            }
        }
        return bindingBuilder.build();
    }

    private boolean containsAll(Collection<?> list, Collection<?> subList) {
        for (Object e : subList) {
            if (this.contains(e, list)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Object o, Collection<?> list) {
        Iterator<?> it = list.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                Object item = it.next();
                if (!this.objectsEquals(item, o)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean objectsEquals(Object o1, Object o2) {
        return this.runtimeEquality.objectEquals(o1, o2);
    }

    private boolean setIntersects(Collection<?> listA, Collection<?> listB) {
        if (listA.isEmpty() || listB.isEmpty()) {
            return false;
        }
        for (Object element : listB) {
            if (!this.contains(element, listA)) continue;
            return true;
        }
        return false;
    }
}

