/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.optimizer;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelMutableAst;
import dev.cel.common.CelMutableSource;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprIdGeneratorFactory;
import dev.cel.common.ast.CelMutableExpr;
import dev.cel.common.navigation.CelNavigableMutableAst;
import dev.cel.common.navigation.CelNavigableMutableExpr;
import dev.cel.common.navigation.TraversalOrder;
import dev.cel.common.types.CelType;
import dev.cel.optimizer.AutoValue_AstMutator_MangledComprehensionAst;
import dev.cel.optimizer.AutoValue_AstMutator_MangledComprehensionName;
import dev.cel.optimizer.AutoValue_AstMutator_MangledComprehensionType;
import dev.cel.optimizer.MutableExprVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public final class AstMutator {
    private static final CelExprIdGeneratorFactory.ExprIdGenerator NO_OP_ID_GENERATOR = id -> id;
    private static final CelExprIdGeneratorFactory.ExprIdGenerator UNSET_ID_GENERATOR = id -> 0L;
    private final long iterationLimit;

    public static AstMutator newInstance(long iterationLimit) {
        return new AstMutator(iterationLimit);
    }

    private AstMutator(long iterationLimit) {
        Preconditions.checkState(iterationLimit > 0L);
        this.iterationLimit = iterationLimit;
    }

    public CelMutableExpr clearExprIds(CelMutableExpr expr) {
        return this.renumberExprIds(UNSET_ID_GENERATOR, expr);
    }

    public CelMutableAst wrapAstWithNewCelBlock(String celBlockFunction, CelMutableAst ast, List<CelMutableExpr> subexpressions) {
        long maxId = AstMutator.getMaxId(ast);
        maxId = maxId + 1L;
        CelMutableExpr blockExpr = CelMutableExpr.ofCall(maxId, CelMutableExpr.CelMutableCall.create(celBlockFunction, CelMutableExpr.ofList(++maxId, CelMutableExpr.CelMutableList.create(subexpressions)), ast.expr()));
        return CelMutableAst.of(blockExpr, ast.source());
    }

    public CelMutableAst newGlobalCall(String function, Collection<CelMutableAst> args) {
        return this.newCallAst(Optional.empty(), function, args);
    }

    public CelMutableAst newGlobalCall(String function, CelMutableAst ... args) {
        return this.newGlobalCall(function, Arrays.asList(args));
    }

    public CelMutableAst newMemberCall(CelMutableAst target, String function, CelMutableAst ... args) {
        return this.newMemberCall(target, function, Arrays.asList(args));
    }

    public CelMutableAst newMemberCall(CelMutableAst target, String function, Collection<CelMutableAst> args) {
        return this.newCallAst(Optional.of(target), function, args);
    }

    private CelMutableAst newCallAst(Optional<CelMutableAst> target, String function, Collection<CelMutableAst> args) {
        long maxId = 0L;
        CelMutableSource combinedSource = CelMutableSource.newInstance();
        for (CelMutableAst arg : args) {
            CelMutableAst stableArg = this.stabilizeAst(arg, maxId);
            maxId = AstMutator.getMaxId(stableArg);
            combinedSource = AstMutator.combine(combinedSource, stableArg.source());
        }
        Optional<CelMutableAst> maybeTarget = Optional.empty();
        if (target.isPresent()) {
            CelMutableAst stableTarget = this.stabilizeAst(target.get(), maxId);
            combinedSource = AstMutator.combine(combinedSource, stableTarget.source());
            maxId = AstMutator.getMaxId(stableTarget);
            maybeTarget = Optional.of(stableTarget);
        }
        List exprArgs = args.stream().map(CelMutableAst::expr).collect(Collectors.toCollection(ArrayList::new));
        CelMutableExpr.CelMutableCall newCall = maybeTarget.map(celMutableAst -> CelMutableExpr.CelMutableCall.create(celMutableAst.expr(), function, exprArgs)).orElseGet(() -> CelMutableExpr.CelMutableCall.create(function, exprArgs));
        CelMutableExpr newCallExpr = CelMutableExpr.ofCall(++maxId, newCall);
        return CelMutableAst.of(newCallExpr, combinedSource);
    }

    public CelMutableAst replaceSubtreeWithNewBindMacro(CelMutableAst ast, String varName, CelMutableAst varInit, CelMutableExpr resultExpr, long exprIdToReplace, boolean populateMacroSource) {
        long maxId = AstMutator.getMaxId(ast);
        varInit = this.stabilizeAst(varInit, maxId);
        CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator = CelExprIdGeneratorFactory.newStableIdGenerator(maxId);
        CelMutableExpr newBindMacroExpr = this.newBindMacroExpr(varName, varInit.expr(), CelMutableExpr.newInstance(resultExpr), stableIdGenerator);
        CelMutableSource celSource = CelMutableSource.newInstance();
        if (populateMacroSource) {
            CelMutableExpr newBindMacroSourceExpr = this.newBindMacroSourceExpr(newBindMacroExpr, varName, stableIdGenerator);
            celSource = AstMutator.combine(ast.source(), varInit.source());
            celSource = this.normalizeMacroSource(celSource, -1L, newBindMacroSourceExpr, stableIdGenerator::renumberId);
            celSource.addMacroCalls(newBindMacroExpr.id(), newBindMacroSourceExpr);
        }
        CelMutableAst newBindAst = CelMutableAst.of(newBindMacroExpr, celSource);
        return this.replaceSubtree(ast, newBindAst, exprIdToReplace);
    }

    public CelMutableAst replaceSubtreeWithNewBindMacro(CelMutableAst ast, String varName, CelMutableExpr varInit, CelMutableExpr resultExpr, long exprIdToReplace, boolean populateMacroSource) {
        return this.replaceSubtreeWithNewBindMacro(ast, varName, CelMutableAst.of(varInit, CelMutableSource.newInstance()), resultExpr, exprIdToReplace, populateMacroSource);
    }

    public CelMutableAst renumberIdsConsecutively(CelMutableAst mutableAst) {
        CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator = CelExprIdGeneratorFactory.newStableIdGenerator(0L);
        CelMutableExpr mutableExpr = this.renumberExprIds(stableIdGenerator::renumberId, mutableAst.expr());
        CelMutableSource newSource = this.normalizeMacroSource(mutableAst.source(), Integer.MIN_VALUE, mutableExpr, stableIdGenerator::renumberId);
        return CelMutableAst.of(mutableExpr, newSource);
    }

    public MangledComprehensionAst mangleComprehensionIdentifierNames(CelMutableAst ast, String newIterVarPrefix, String newAccuVarPrefix, boolean incrementSerially) {
        CelNavigableMutableAst navigableMutableAst = CelNavigableMutableAst.fromAst(ast);
        Predicate<CelNavigableMutableExpr> comprehensionIdentifierPredicate = x -> true;
        comprehensionIdentifierPredicate = comprehensionIdentifierPredicate.and(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)).and(node -> !((CelMutableExpr)node.expr()).comprehension().iterVar().startsWith(newIterVarPrefix)).and(node -> !((CelMutableExpr)node.expr()).comprehension().accuVar().startsWith(newAccuVarPrefix));
        LinkedHashMap comprehensionsToMangle = navigableMutableAst.getRoot().allNodes(TraversalOrder.POST_ORDER).filter(comprehensionIdentifierPredicate).filter(node -> {
            String iterVar = ((CelMutableExpr)node.expr()).comprehension().iterVar();
            String result = ((CelMutableExpr)node.expr()).comprehension().result().ident().name();
            return CelNavigableMutableExpr.fromExpr(((CelMutableExpr)node.expr()).comprehension().loopStep()).allNodes().filter(subNode -> subNode.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT)).map(subNode -> ((CelMutableExpr)subNode.expr()).ident()).anyMatch(ident -> ident.name().contains(iterVar) || ident.name().contains(result));
        }).collect(Collectors.toMap(k -> k, v -> {
            CelMutableExpr.CelMutableComprehension comprehension = ((CelMutableExpr)v.expr()).comprehension();
            String iterVar = comprehension.iterVar();
            Optional<Long> iterVarId = CelNavigableMutableExpr.fromExpr(comprehension.loopStep()).allNodes().filter(loopStepNode -> loopStepNode.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && ((CelMutableExpr)loopStepNode.expr()).ident().name().equals(iterVar)).map(rec$ -> ((CelNavigableMutableExpr)rec$).id()).findAny();
            Optional<CelType> iterVarType = iterVarId.map(id -> navigableMutableAst.getType((long)id).orElseThrow(() -> new NoSuchElementException("Checked type not present for iteration variable: " + iterVarId)));
            CelType resultType = navigableMutableAst.getType(comprehension.result().id()).orElseThrow(() -> new IllegalStateException("Result type was not present for the comprehension ID: " + comprehension.result().id()));
            return MangledComprehensionType.of(iterVarType, resultType);
        }, (x, y) -> {
            throw new IllegalStateException("Unexpected CelNavigableMutableExpr collision");
        }, LinkedHashMap::new));
        HashMap<MangledComprehensionName, MangledComprehensionType> mangledIdentNamesToType = new HashMap<MangledComprehensionName, MangledComprehensionType>();
        HashBasedTable<Integer, MangledComprehensionType, MangledComprehensionName> comprehensionLevelToType = HashBasedTable.create();
        CelMutableExpr mutatedComprehensionExpr = navigableMutableAst.getAst().expr();
        CelMutableSource newSource = navigableMutableAst.getAst().source();
        int iterCount = 0;
        for (Map.Entry comprehensionEntry : comprehensionsToMangle.entrySet()) {
            MangledComprehensionName mangledComprehensionName;
            CelNavigableMutableExpr comprehensionNode = (CelNavigableMutableExpr)comprehensionEntry.getKey();
            MangledComprehensionType comprehensionEntryType = (MangledComprehensionType)comprehensionEntry.getValue();
            CelMutableExpr comprehensionExpr = (CelMutableExpr)comprehensionNode.expr();
            if (incrementSerially) {
                String mangledIterVarName = newIterVarPrefix + ":" + iterCount;
                String mangledResultName = newAccuVarPrefix + ":" + iterCount;
                mangledComprehensionName = MangledComprehensionName.of(mangledIterVarName, mangledResultName);
                mangledIdentNamesToType.put(mangledComprehensionName, (MangledComprehensionType)comprehensionEntry.getValue());
            } else {
                mangledComprehensionName = AstMutator.getMangledComprehensionName(newIterVarPrefix, newAccuVarPrefix, comprehensionNode, comprehensionLevelToType, comprehensionEntryType);
            }
            mangledIdentNamesToType.put(mangledComprehensionName, comprehensionEntryType);
            String iterVar = comprehensionExpr.comprehension().iterVar();
            String accuVar = comprehensionExpr.comprehension().accuVar();
            mutatedComprehensionExpr = this.mangleIdentsInComprehensionExpr(mutatedComprehensionExpr, comprehensionExpr, iterVar, accuVar, mangledComprehensionName);
            newSource = this.mangleIdentsInMacroSource(newSource, mutatedComprehensionExpr, iterVar, mangledComprehensionName, comprehensionExpr.id());
            ++iterCount;
        }
        if ((long)iterCount >= this.iterationLimit) {
            throw new IllegalStateException("Max iteration count reached.");
        }
        return MangledComprehensionAst.of(CelMutableAst.of(mutatedComprehensionExpr, newSource), ImmutableMap.copyOf(mangledIdentNamesToType));
    }

    private static MangledComprehensionName getMangledComprehensionName(String newIterVarPrefix, String newResultPrefix, CelNavigableMutableExpr comprehensionNode, Table<Integer, MangledComprehensionType, MangledComprehensionName> comprehensionLevelToType, MangledComprehensionType comprehensionEntryType) {
        MangledComprehensionName mangledComprehensionName;
        int comprehensionNestingLevel = AstMutator.countComprehensionNestingLevel(comprehensionNode);
        if (comprehensionLevelToType.contains(comprehensionNestingLevel, comprehensionEntryType)) {
            mangledComprehensionName = comprehensionLevelToType.get(comprehensionNestingLevel, comprehensionEntryType);
        } else {
            int uniqueTypeIdx = comprehensionLevelToType.row(comprehensionNestingLevel).size();
            String mangledIterVarName = newIterVarPrefix + ":" + comprehensionNestingLevel + ":" + uniqueTypeIdx;
            String mangledResultName = newResultPrefix + ":" + comprehensionNestingLevel + ":" + uniqueTypeIdx;
            mangledComprehensionName = MangledComprehensionName.of(mangledIterVarName, mangledResultName);
            comprehensionLevelToType.put(comprehensionNestingLevel, comprehensionEntryType, mangledComprehensionName);
        }
        return mangledComprehensionName;
    }

    private static int countComprehensionNestingLevel(CelNavigableMutableExpr comprehensionExpr) {
        int nestedLevel = 0;
        Optional<CelNavigableMutableExpr> maybeParent = comprehensionExpr.parent();
        while (maybeParent.isPresent()) {
            if (maybeParent.get().getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)) {
                ++nestedLevel;
            }
            maybeParent = maybeParent.get().parent();
        }
        return nestedLevel;
    }

    public CelMutableAst replaceSubtree(CelMutableExpr root, CelMutableExpr newExpr, long exprIdToReplace) {
        return this.replaceSubtree(CelMutableAst.of(root, CelMutableSource.newInstance()), newExpr, exprIdToReplace);
    }

    public CelMutableAst replaceSubtree(CelMutableAst ast, CelMutableExpr newExpr, long exprIdToReplace) {
        return this.replaceSubtree(ast, CelMutableAst.of(newExpr, ast.source()), exprIdToReplace);
    }

    public CelMutableAst replaceSubtree(CelMutableAst ast, CelMutableAst newAst, long exprIdToReplace) {
        return this.replaceSubtree(CelNavigableMutableAst.fromAst(ast), CelNavigableMutableAst.fromAst(newAst), exprIdToReplace);
    }

    public CelMutableAst replaceSubtree(CelNavigableMutableAst navAst, CelNavigableMutableAst navNewAst, long exprIdToReplace) {
        long maxId = Math.max(AstMutator.getMaxId(navAst), AstMutator.getMaxId(navNewAst));
        CelMutableAst ast = navAst.getAst();
        CelMutableAst newAst = navNewAst.getAst();
        newAst = this.stabilizeAst(newAst, maxId);
        long stablizedNewExprRootId = newAst.expr().id();
        CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator = CelExprIdGeneratorFactory.newStableIdGenerator(AstMutator.getMaxId(newAst));
        CelMutableExpr mutatedRoot = this.mutateExpr(stableIdGenerator::renumberId, ast.expr(), newAst.expr(), exprIdToReplace);
        CelMutableSource newAstSource = CelMutableSource.newInstance().setDescription(ast.source().getDescription());
        if (!ast.source().getMacroCalls().isEmpty()) {
            newAstSource = AstMutator.combine(newAstSource, ast.source());
        }
        if (!newAst.source().getMacroCalls().isEmpty()) {
            stableIdGenerator.memoize(stablizedNewExprRootId, stableIdGenerator.renumberId(exprIdToReplace));
            newAstSource = AstMutator.combine(newAstSource, newAst.source());
        }
        newAstSource = this.normalizeMacroSource(newAstSource, exprIdToReplace, mutatedRoot, stableIdGenerator::renumberId);
        return CelMutableAst.of(mutatedRoot, newAstSource);
    }

    private CelMutableExpr mangleIdentsInComprehensionExpr(CelMutableExpr root, CelMutableExpr comprehensionExpr, String originalIterVar, String originalAccuVar, MangledComprehensionName mangledComprehensionName) {
        CelMutableExpr.CelMutableComprehension comprehension = comprehensionExpr.comprehension();
        this.replaceIdentName(comprehension.loopStep(), originalIterVar, mangledComprehensionName.iterVarName());
        this.replaceIdentName(comprehensionExpr, originalAccuVar, mangledComprehensionName.resultName());
        comprehension.setIterVar(mangledComprehensionName.iterVarName());
        if (comprehension.accuVar().equals(originalAccuVar)) {
            comprehension.setAccuVar(mangledComprehensionName.resultName());
        }
        return this.mutateExpr(NO_OP_ID_GENERATOR, root, comprehensionExpr, comprehensionExpr.id());
    }

    private void replaceIdentName(CelMutableExpr comprehensionExpr, String originalIdentName, String newIdentName) {
        CelMutableExpr identToMangle;
        int iterCount = 0;
        while ((long)iterCount < this.iterationLimit && (identToMangle = (CelMutableExpr)CelNavigableMutableExpr.fromExpr(comprehensionExpr).descendants().map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && node.ident().name().equals(originalIdentName)).findAny().orElse(null)) != null) {
            comprehensionExpr = this.mutateExpr(NO_OP_ID_GENERATOR, comprehensionExpr, CelMutableExpr.ofIdent(newIdentName), identToMangle.id());
            ++iterCount;
        }
        if ((long)iterCount >= this.iterationLimit) {
            throw new IllegalStateException("Max iteration count reached.");
        }
    }

    private CelMutableSource mangleIdentsInMacroSource(CelMutableSource sourceBuilder, CelMutableExpr mutatedComprehensionExpr, String originalIterVar, MangledComprehensionName mangledComprehensionName, long originalComprehensionId) {
        if (!sourceBuilder.getMacroCalls().containsKey(originalComprehensionId)) {
            return sourceBuilder;
        }
        CelMutableSource newSource = this.normalizeMacroSource(sourceBuilder, -1L, mutatedComprehensionExpr, id -> id);
        CelMutableExpr macroExpr = newSource.getMacroCalls().get(originalComprehensionId);
        CelMutableExpr identToMangle = macroExpr.call().args().get(0);
        if (identToMangle.ident().name().equals(originalIterVar)) {
            macroExpr = this.mutateExpr(NO_OP_ID_GENERATOR, macroExpr, CelMutableExpr.ofIdent(mangledComprehensionName.iterVarName()), identToMangle.id());
        }
        newSource.addMacroCalls(originalComprehensionId, macroExpr);
        return newSource;
    }

    private CelMutableExpr newBindMacroExpr(String varName, CelMutableExpr varInit, CelMutableExpr resultExpr, CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator) {
        varInit = this.renumberExprIds(stableIdGenerator::nextExprId, varInit);
        resultExpr = this.renumberExprIds(stableIdGenerator::nextExprId, resultExpr);
        long iterRangeId = stableIdGenerator.nextExprId();
        long loopConditionId = stableIdGenerator.nextExprId();
        long loopStepId = stableIdGenerator.nextExprId();
        long comprehensionId = stableIdGenerator.nextExprId();
        return CelMutableExpr.ofComprehension(comprehensionId, CelMutableExpr.CelMutableComprehension.create("#unused", CelMutableExpr.ofList(iterRangeId, CelMutableExpr.CelMutableList.create(new CelMutableExpr[0])), varName, varInit, CelMutableExpr.ofConstant(loopConditionId, CelConstant.ofValue(false)), CelMutableExpr.ofIdent(loopStepId, varName), resultExpr));
    }

    private CelMutableExpr newBindMacroSourceExpr(CelMutableExpr bindMacroExpr, String varName, CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator) {
        return CelMutableExpr.ofCall(0L, CelMutableExpr.CelMutableCall.create(CelMutableExpr.ofIdent(stableIdGenerator.nextExprId(), "cel"), "bind", CelMutableExpr.ofIdent(stableIdGenerator.nextExprId(), varName), bindMacroExpr.comprehension().accuInit(), bindMacroExpr.comprehension().result()));
    }

    private static CelMutableSource combine(CelMutableSource celSource1, CelMutableSource celSource2) {
        return CelMutableSource.newInstance().setDescription(Strings.isNullOrEmpty(celSource1.getDescription()) ? celSource2.getDescription() : celSource1.getDescription()).addAllExtensions(celSource1.getExtensions()).addAllExtensions(celSource2.getExtensions()).addAllMacroCalls(celSource1.getMacroCalls()).addAllMacroCalls(celSource2.getMacroCalls());
    }

    private CelMutableAst stabilizeAst(CelMutableAst mutableAst, long seedExprId) {
        CelMutableExpr mutableExpr = mutableAst.expr();
        CelMutableSource source2 = mutableAst.source();
        CelExprIdGeneratorFactory.StableIdGenerator stableIdGenerator = CelExprIdGeneratorFactory.newStableIdGenerator(seedExprId);
        CelMutableExpr mutatedExpr = this.renumberExprIds(stableIdGenerator::nextExprId, mutableExpr);
        CelMutableSource sourceBuilder = CelMutableSource.newInstance().addAllExtensions(source2.getExtensions());
        for (Map.Entry<Long, CelMutableExpr> macroCall : source2.getMacroCalls().entrySet()) {
            long macroId = macroCall.getKey();
            long newCallId = stableIdGenerator.renumberId(macroId);
            CelMutableExpr existingMacroCallExpr = CelMutableExpr.newInstance(macroCall.getValue());
            CelMutableExpr newCall = this.renumberExprIds(stableIdGenerator::renumberId, existingMacroCallExpr);
            sourceBuilder.addMacroCalls(newCallId, newCall);
        }
        return CelMutableAst.of(mutatedExpr, sourceBuilder);
    }

    private CelMutableSource normalizeMacroSource(CelMutableSource source2, long exprIdToReplace, CelMutableExpr mutatedRoot, CelExprIdGeneratorFactory.ExprIdGenerator idGenerator) {
        source2.clearMacroCall(exprIdToReplace);
        if (source2.getMacroCalls().isEmpty()) {
            return source2;
        }
        ImmutableMap<Long, CelMutableExpr> allExprs = CelNavigableMutableExpr.fromExpr(mutatedRoot).allNodes().map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).collect(ImmutableMap.toImmutableMap(CelMutableExpr::id, expr -> expr, (expr1, expr2) -> {
            if (expr1.equals(expr2)) {
                return expr1;
            }
            throw new IllegalStateException("Expected expressions to be the same for id: " + expr1.id());
        }));
        CelMutableSource newMacroSource = CelMutableSource.newInstance().setDescription(source2.getDescription()).addAllExtensions(source2.getExtensions());
        for (Map.Entry<Long, CelMutableExpr> existingMacroCall : source2.getMacroCalls().entrySet()) {
            long macroId = existingMacroCall.getKey();
            long callId = idGenerator.generate(macroId);
            if (!allExprs.containsKey(callId)) continue;
            CelMutableExpr existingMacroCallExpr = CelMutableExpr.newInstance(existingMacroCall.getValue());
            CelMutableExpr newMacroCallExpr = this.renumberExprIds(idGenerator, existingMacroCallExpr);
            CelNavigableMutableExpr callNav = CelNavigableMutableExpr.fromExpr(newMacroCallExpr);
            ArrayList callDescendants = callNav.descendants().map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).collect(Collectors.toCollection(ArrayList::new));
            for (CelMutableExpr callChild : callDescendants) {
                CelMutableExpr mutatedExpr;
                if (!allExprs.containsKey(callChild.id()) || callChild.equals(mutatedExpr = allExprs.get(callChild.id()))) continue;
                newMacroCallExpr = this.mutateExpr(NO_OP_ID_GENERATOR, newMacroCallExpr, mutatedExpr, callChild.id());
            }
            if (exprIdToReplace > 0L) {
                boolean isListExprBeingReplaced;
                long replacedId = idGenerator.generate(exprIdToReplace);
                boolean bl = isListExprBeingReplaced = allExprs.containsKey(replacedId) && allExprs.get(replacedId).getKind().equals((Object)CelExpr.ExprKind.Kind.LIST);
                if (isListExprBeingReplaced) {
                    AstMutator.unwrapListArgumentsInMacroCallExpr(allExprs.get(callId).comprehension(), newMacroCallExpr);
                }
            }
            newMacroSource.addMacroCalls(callId, newMacroCallExpr);
        }
        for (Map.Entry<Long, CelMutableExpr> macroCall : newMacroSource.getMacroCalls().entrySet()) {
            CelMutableExpr macroCallExpr = macroCall.getValue();
            CelNavigableMutableExpr.fromExpr(macroCallExpr).allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)).map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).forEach(node -> {
                CelMutableExpr mutatedNode = this.mutateExpr(NO_OP_ID_GENERATOR, macroCallExpr, CelMutableExpr.ofNotSet(node.id()), node.id());
                macroCall.setValue(mutatedNode);
            });
            CelNavigableMutableExpr.fromExpr(macroCallExpr).allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.NOT_SET)).map(rec$ -> ((CelNavigableMutableExpr)rec$).id()).filter(id -> !allExprs.containsKey(id)).forEach(id -> {
                ArrayList newCallArgs = macroCallExpr.call().args().stream().filter(node -> node.id() != id.longValue()).collect(Collectors.toCollection(ArrayList::new));
                CelMutableExpr.CelMutableCall call = macroCallExpr.call();
                call.setArgs(newCallArgs);
            });
        }
        return newMacroSource;
    }

    private static void unwrapListArgumentsInMacroCallExpr(CelMutableExpr.CelMutableComprehension comprehension, CelMutableExpr newMacroCallExpr) {
        CelMutableExpr accuInit = comprehension.accuInit();
        if (!accuInit.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) || !accuInit.list().elements().isEmpty()) {
            return;
        }
        CelMutableExpr loopStepExpr = comprehension.loopStep();
        List<CelMutableExpr> loopStepArgs = loopStepExpr.call().args();
        if (loopStepArgs.size() != 2) {
            throw new IllegalArgumentException(String.format("Expected exactly 2 arguments but got %d instead on expr id: %d", loopStepArgs.size(), loopStepExpr.id()));
        }
        CelMutableExpr.CelMutableCall existingMacroCall = newMacroCallExpr.call();
        CelMutableExpr.CelMutableCall newMacroCall = existingMacroCall.target().isPresent() ? CelMutableExpr.CelMutableCall.create(existingMacroCall.target().get(), existingMacroCall.function(), new CelMutableExpr[0]) : CelMutableExpr.CelMutableCall.create(existingMacroCall.function(), new CelMutableExpr[0]);
        newMacroCall.addArgs(existingMacroCall.args().get(0));
        newMacroCall.addArgs(loopStepArgs.get(1).list().elements());
        newMacroCallExpr.setCall(newMacroCall);
    }

    private CelMutableExpr mutateExpr(CelExprIdGeneratorFactory.ExprIdGenerator idGenerator, CelMutableExpr root, CelMutableExpr newExpr, long exprIdToReplace) {
        MutableExprVisitor mutableAst = MutableExprVisitor.newInstance(idGenerator, newExpr, exprIdToReplace, this.iterationLimit);
        return mutableAst.visit(root);
    }

    private CelMutableExpr renumberExprIds(CelExprIdGeneratorFactory.ExprIdGenerator idGenerator, CelMutableExpr root) {
        MutableExprVisitor mutableAst = MutableExprVisitor.newInstance(idGenerator, root, Integer.MIN_VALUE, this.iterationLimit);
        return mutableAst.visit(root);
    }

    private static long getMaxId(CelMutableAst mutableAst) {
        return AstMutator.getMaxId(CelNavigableMutableAst.fromAst(mutableAst));
    }

    private static long getMaxId(CelNavigableMutableAst navAst) {
        long maxId = navAst.getRoot().maxId();
        for (Map.Entry<Long, CelMutableExpr> macroCall : navAst.getAst().source().getMacroCalls().entrySet()) {
            maxId = Math.max(maxId, AstMutator.getMaxId(macroCall.getValue()));
        }
        return maxId;
    }

    private static long getMaxId(CelMutableExpr mutableExpr) {
        return CelNavigableMutableExpr.fromExpr(mutableExpr).allNodes().mapToLong(rec$ -> ((CelNavigableMutableExpr)rec$).id()).max().orElseThrow(NoSuchElementException::new);
    }

    @AutoValue
    public static abstract class MangledComprehensionType {
        public abstract Optional<CelType> iterVarType();

        public abstract CelType resultType();

        private static MangledComprehensionType of(Optional<CelType> iterVarType, CelType resultType) {
            return new AutoValue_AstMutator_MangledComprehensionType(iterVarType, resultType);
        }
    }

    @AutoValue
    public static abstract class MangledComprehensionName {
        public abstract String iterVarName();

        public abstract String resultName();

        private static MangledComprehensionName of(String iterVarName, String resultName) {
            return new AutoValue_AstMutator_MangledComprehensionName(iterVarName, resultName);
        }
    }

    @AutoValue
    public static abstract class MangledComprehensionAst {
        public abstract CelMutableAst mutableAst();

        public abstract ImmutableMap<MangledComprehensionName, MangledComprehensionType> mangledComprehensionMap();

        private static MangledComprehensionAst of(CelMutableAst ast, ImmutableMap<MangledComprehensionName, MangledComprehensionType> mangledComprehensionMap) {
            return new AutoValue_AstMutator_MangledComprehensionAst(ast, mangledComprehensionMap);
        }
    }
}

