/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.optimizer.optimizers;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelMutableAst;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationException;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelMutableExpr;
import dev.cel.common.ast.CelMutableExprConverter;
import dev.cel.common.navigation.CelNavigableMutableAst;
import dev.cel.common.navigation.CelNavigableMutableExpr;
import dev.cel.extensions.CelOptionalLibrary;
import dev.cel.optimizer.AstMutator;
import dev.cel.optimizer.CelAstOptimizer;
import dev.cel.optimizer.CelOptimizationException;
import dev.cel.optimizer.optimizers.AutoValue_ConstantFoldingOptimizer_ConstantFoldingOptions;
import dev.cel.optimizer.optimizers.DefaultOptimizerConstants;
import dev.cel.parser.Operator;
import dev.cel.runtime.CelEvaluationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ConstantFoldingOptimizer
implements CelAstOptimizer {
    private static final ConstantFoldingOptimizer INSTANCE = new ConstantFoldingOptimizer(ConstantFoldingOptions.newBuilder().build());
    private final ConstantFoldingOptions constantFoldingOptions;
    private final AstMutator astMutator;
    private final ImmutableSet<String> foldableFunctions;

    public static ConstantFoldingOptimizer getInstance() {
        return INSTANCE;
    }

    public static ConstantFoldingOptimizer newInstance(ConstantFoldingOptions constantFoldingOptions) {
        return new ConstantFoldingOptimizer(constantFoldingOptions);
    }

    private static CelMutableExpr newOptionalNoneExpr() {
        return CelMutableExpr.ofCall(CelMutableExpr.CelMutableCall.create(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction(), new CelMutableExpr[0]));
    }

    @Override
    public CelAstOptimizer.OptimizationResult optimize(CelAbstractSyntaxTree ast, Cel cel) throws CelOptimizationException {
        CelMutableAst mutableAst = CelMutableAst.fromCelAst(ast);
        int iterCount = 0;
        boolean continueFolding = true;
        while (continueFolding) {
            if (iterCount >= this.constantFoldingOptions.maxIterationLimit()) {
                throw new IllegalStateException("Max iteration count reached.");
            }
            ++iterCount;
            continueFolding = false;
            ImmutableList foldableExprs = CelNavigableMutableAst.fromAst(mutableAst).getRoot().allNodes().filter(this::canFold).collect(ImmutableList.toImmutableList());
            for (CelNavigableMutableExpr foldableExpr : foldableExprs) {
                ++iterCount;
                Optional<CelMutableAst> mutatedResult = this.maybePruneBranches(mutableAst, (CelMutableExpr)foldableExpr.expr());
                if (!mutatedResult.isPresent()) {
                    mutatedResult = this.maybeFold(cel, mutableAst, foldableExpr);
                }
                if (!mutatedResult.isPresent()) continue;
                continueFolding = true;
                mutableAst = mutatedResult.get();
            }
        }
        mutableAst = this.pruneOptionalElements(mutableAst);
        return CelAstOptimizer.OptimizationResult.create(this.astMutator.renumberIdsConsecutively(mutableAst).toParsedAst());
    }

    private boolean canFold(CelNavigableMutableExpr navigableExpr) {
        switch (navigableExpr.getKind()) {
            case CALL: {
                if (!this.containsFoldableFunctionOnly(navigableExpr)) {
                    return false;
                }
                CelMutableExpr.CelMutableCall mutableCall = ((CelMutableExpr)navigableExpr.expr()).call();
                String functionName = mutableCall.function();
                if (functionName.equals(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction()) || functionName.equals(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction())) {
                    return false;
                }
                if (functionName.equals(Operator.LOGICAL_AND.getFunction()) || functionName.equals(Operator.LOGICAL_OR.getFunction())) {
                    return mutableCall.args().stream().anyMatch(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT));
                }
                if (functionName.equals(Operator.CONDITIONAL.getFunction())) {
                    CelMutableExpr cond = mutableCall.args().get(0);
                    return cond.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) && cond.constant().getKind().equals((Object)CelConstant.Kind.BOOLEAN_VALUE);
                }
                if (functionName.equals(Operator.IN.getFunction())) {
                    return ConstantFoldingOptimizer.canFoldInOperator(navigableExpr);
                }
                return ConstantFoldingOptimizer.areChildrenArgConstant(navigableExpr);
            }
            case SELECT: {
                CelNavigableMutableExpr operand = (CelNavigableMutableExpr)navigableExpr.children().collect(MoreCollectors.onlyElement());
                return ConstantFoldingOptimizer.areChildrenArgConstant(operand);
            }
            case COMPREHENSION: {
                return !ConstantFoldingOptimizer.isNestedComprehension(navigableExpr);
            }
        }
        return false;
    }

    private boolean containsFoldableFunctionOnly(CelNavigableMutableExpr navigableExpr) {
        return navigableExpr.allNodes().allMatch(node -> {
            if (node.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
                return this.foldableFunctions.contains(((CelMutableExpr)node.expr()).call().function());
            }
            return true;
        });
    }

    private static boolean canFoldInOperator(CelNavigableMutableExpr navigableExpr) {
        ImmutableList allIdents = navigableExpr.allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT)).collect(ImmutableList.toImmutableList());
        for (CelNavigableMutableExpr identNode : allIdents) {
            CelNavigableMutableExpr parent = identNode.parent().orElse(null);
            while (parent != null) {
                if (parent.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION) && ((CelMutableExpr)parent.expr()).comprehension().accuVar().equals(((CelMutableExpr)identNode.expr()).ident().name())) {
                    return false;
                }
                parent = parent.parent().orElse(null);
            }
        }
        return true;
    }

    private static boolean areChildrenArgConstant(CelNavigableMutableExpr expr) {
        if (expr.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
            return true;
        }
        if (expr.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL) || expr.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) || expr.getKind().equals((Object)CelExpr.ExprKind.Kind.MAP) || expr.getKind().equals((Object)CelExpr.ExprKind.Kind.STRUCT)) {
            return expr.children().allMatch(ConstantFoldingOptimizer::areChildrenArgConstant);
        }
        return false;
    }

    private static boolean isNestedComprehension(CelNavigableMutableExpr expr) {
        Optional<CelNavigableMutableExpr> maybeParent = expr.parent();
        while (maybeParent.isPresent()) {
            CelNavigableMutableExpr parent = maybeParent.get();
            if (parent.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)) {
                return true;
            }
            maybeParent = parent.parent();
        }
        return false;
    }

    private Optional<CelMutableAst> maybeFold(Cel cel, CelMutableAst mutableAst, CelNavigableMutableExpr node) throws CelOptimizationException {
        Object result;
        try {
            result = ConstantFoldingOptimizer.evaluateExpr(cel, CelMutableExprConverter.fromMutableExpr((CelMutableExpr)node.expr()));
        }
        catch (CelValidationException | CelEvaluationException e) {
            throw new CelOptimizationException("Constant folding failure. Failed to evaluate subtree due to: " + e.getMessage(), e);
        }
        if (result instanceof Optional) {
            Optional optResult = (Optional)result;
            return this.maybeRewriteOptional(optResult, mutableAst, (CelMutableExpr)node.expr());
        }
        return this.maybeAdaptEvaluatedResult(result).map(celExpr -> this.astMutator.replaceSubtree(mutableAst, (CelMutableExpr)celExpr, node.id()));
    }

    private Optional<CelMutableExpr> maybeAdaptEvaluatedResult(Object result) {
        if (CelConstant.isConstantValue(result)) {
            return Optional.of(CelMutableExpr.ofConstant(CelConstant.ofObjectValue(result)));
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            ArrayList<CelMutableExpr> listElements = new ArrayList<CelMutableExpr>();
            for (Object evaluatedElement : collection) {
                CelMutableExpr adaptedExpr = this.maybeAdaptEvaluatedResult(evaluatedElement).orElse(null);
                if (adaptedExpr == null) {
                    return Optional.empty();
                }
                listElements.add(adaptedExpr);
            }
            return Optional.of(CelMutableExpr.ofList(CelMutableExpr.CelMutableList.create(listElements)));
        }
        if (result instanceof Map) {
            Map map = (Map)result;
            ArrayList<CelMutableExpr.CelMutableMap.Entry> mapEntries = new ArrayList<CelMutableExpr.CelMutableMap.Entry>();
            for (Map.Entry entry : map.entrySet()) {
                CelMutableExpr adaptedKey = this.maybeAdaptEvaluatedResult(entry.getKey()).orElse(null);
                if (adaptedKey == null) {
                    return Optional.empty();
                }
                CelMutableExpr adaptedValue = this.maybeAdaptEvaluatedResult(entry.getValue()).orElse(null);
                if (adaptedValue == null) {
                    return Optional.empty();
                }
                mapEntries.add(CelMutableExpr.CelMutableMap.Entry.create(adaptedKey, adaptedValue));
            }
            return Optional.of(CelMutableExpr.ofMap(CelMutableExpr.CelMutableMap.create(mapEntries)));
        }
        return Optional.empty();
    }

    private Optional<CelMutableAst> maybeRewriteOptional(Optional<?> optResult, CelMutableAst mutableAst, CelMutableExpr expr) {
        if (!optResult.isPresent()) {
            if (!expr.call().function().equals(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction())) {
                return Optional.of(this.astMutator.replaceSubtree(mutableAst, ConstantFoldingOptimizer.newOptionalNoneExpr(), expr.id()));
            }
        } else if (!expr.call().function().equals(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction())) {
            Object unwrappedResult = optResult.get();
            if (!CelConstant.isConstantValue(unwrappedResult)) {
                return Optional.empty();
            }
            CelMutableExpr newOptionalOfCall = CelMutableExpr.ofCall(CelMutableExpr.CelMutableCall.create(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction(), CelMutableExpr.ofConstant(CelConstant.ofObjectValue(unwrappedResult))));
            return Optional.of(this.astMutator.replaceSubtree(mutableAst, newOptionalOfCall, expr.id()));
        }
        return Optional.empty();
    }

    private Optional<CelMutableAst> maybePruneBranches(CelMutableAst mutableAst, CelMutableExpr expr) {
        if (!expr.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
            return Optional.empty();
        }
        CelMutableExpr.CelMutableCall call = expr.call();
        String function = call.function();
        if (function.equals(Operator.LOGICAL_AND.getFunction()) || function.equals(Operator.LOGICAL_OR.getFunction())) {
            return this.maybeShortCircuitCall(mutableAst, expr);
        }
        if (function.equals(Operator.CONDITIONAL.getFunction())) {
            CelMutableExpr cond = call.args().get(0);
            CelMutableExpr truthy = call.args().get(1);
            CelMutableExpr falsy = call.args().get(2);
            if (!cond.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                throw new IllegalStateException(String.format("Expected constant condition. Got: %s instead.", new Object[]{cond.getKind()}));
            }
            CelMutableExpr result = cond.constant().booleanValue() ? truthy : falsy;
            return Optional.of(this.astMutator.replaceSubtree(mutableAst, result, expr.id()));
        }
        if (function.equals(Operator.IN.getFunction())) {
            CelMutableExpr callArg = call.args().get(1);
            if (!callArg.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST)) {
                return Optional.empty();
            }
            CelMutableExpr.CelMutableList haystack = callArg.list();
            if (haystack.elements().isEmpty()) {
                return Optional.of(this.astMutator.replaceSubtree(mutableAst, CelMutableExpr.ofConstant(CelConstant.ofValue(false)), expr.id()));
            }
            CelMutableExpr needle = call.args().get(0);
            if (needle.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) || needle.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT)) {
                Object needleValue = needle.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) ? needle.constant() : needle.ident();
                for (CelMutableExpr elem : haystack.elements()) {
                    if ((!elem.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) || !elem.constant().equals(needleValue)) && (!elem.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) || !elem.ident().equals(needleValue))) continue;
                    return Optional.of(this.astMutator.replaceSubtree(mutableAst.expr(), CelMutableExpr.ofConstant(CelConstant.ofValue(true)), expr.id()));
                }
            }
        }
        return Optional.empty();
    }

    private Optional<CelMutableAst> maybeShortCircuitCall(CelMutableAst mutableAst, CelMutableExpr expr) {
        CelMutableExpr.CelMutableCall call = expr.call();
        boolean shortCircuit = false;
        boolean skip = true;
        if (call.function().equals(Operator.LOGICAL_OR.getFunction())) {
            shortCircuit = true;
            skip = false;
        }
        ImmutableList.Builder newArgsBuilder = new ImmutableList.Builder();
        for (CelMutableExpr arg : call.args()) {
            if (!arg.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                newArgsBuilder.add(arg);
                continue;
            }
            if (arg.constant().booleanValue() == skip || arg.constant().booleanValue() != shortCircuit) continue;
            return Optional.of(this.astMutator.replaceSubtree(mutableAst, arg, expr.id()));
        }
        ImmutableCollection newArgs = newArgsBuilder.build();
        if (newArgs.isEmpty()) {
            CelMutableExpr shortCircuitTarget = call.args().get(0);
            return Optional.of(this.astMutator.replaceSubtree(mutableAst, shortCircuitTarget, expr.id()));
        }
        if (newArgs.size() == 1) {
            return Optional.of(this.astMutator.replaceSubtree(mutableAst, (CelMutableExpr)newArgs.get(0), expr.id()));
        }
        throw new UnsupportedOperationException("Folding variadic logical operator is not supported yet.");
    }

    private CelMutableAst pruneOptionalElements(CelMutableAst ast) {
        ImmutableList aggregateLiterals = CelNavigableMutableExpr.fromExpr(ast.expr()).allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) || node.getKind().equals((Object)CelExpr.ExprKind.Kind.MAP) || node.getKind().equals((Object)CelExpr.ExprKind.Kind.STRUCT)).map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).collect(ImmutableList.toImmutableList());
        block5: for (CelMutableExpr expr : aggregateLiterals) {
            switch (expr.getKind()) {
                case LIST: {
                    ast = this.pruneOptionalListElements(ast, expr);
                    continue block5;
                }
                case MAP: {
                    ast = this.pruneOptionalMapElements(ast, expr);
                    continue block5;
                }
                case STRUCT: {
                    ast = this.pruneOptionalStructElements(ast, expr);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected exprKind: " + (Object)((Object)expr.getKind()));
        }
        return ast;
    }

    private CelMutableAst pruneOptionalListElements(CelMutableAst mutableAst, CelMutableExpr expr) {
        CelMutableExpr.CelMutableList list = expr.list();
        if (list.optionalIndices().isEmpty()) {
            return mutableAst;
        }
        HashSet<Integer> optionalIndices = new HashSet<Integer>(list.optionalIndices());
        ImmutableList.Builder updatedElemBuilder = new ImmutableList.Builder();
        ImmutableList.Builder updatedIndicesBuilder = new ImmutableList.Builder();
        int newOptIndex = -1;
        for (int i = 0; i < list.elements().size(); ++i) {
            ++newOptIndex;
            CelMutableExpr element = list.elements().get(i);
            if (!optionalIndices.contains(i)) {
                updatedElemBuilder.add(element);
                continue;
            }
            if (element.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
                CelMutableExpr arg;
                CelMutableExpr.CelMutableCall call = element.call();
                if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction())) {
                    --newOptIndex;
                    continue;
                }
                if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction()) && (arg = call.args().get(0)).getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                    updatedElemBuilder.add(call.args().get(0));
                    continue;
                }
            }
            updatedElemBuilder.add(element);
            updatedIndicesBuilder.add((Object)newOptIndex);
        }
        return this.astMutator.replaceSubtree(mutableAst, CelMutableExpr.ofList(CelMutableExpr.CelMutableList.create((List<CelMutableExpr>)((Object)updatedElemBuilder.build()), (List<Integer>)((Object)updatedIndicesBuilder.build()))), expr.id());
    }

    private CelMutableAst pruneOptionalMapElements(CelMutableAst ast, CelMutableExpr expr) {
        CelMutableExpr.CelMutableMap map = expr.map();
        ImmutableList.Builder updatedEntryBuilder = new ImmutableList.Builder();
        boolean modified = false;
        for (CelMutableExpr.CelMutableMap.Entry entry : map.entries()) {
            CelMutableExpr arg;
            CelMutableExpr key = entry.key();
            CelExpr.ExprKind.Kind keyKind = key.getKind();
            CelMutableExpr value = entry.value();
            CelExpr.ExprKind.Kind valueKind = value.getKind();
            if (!(entry.optionalEntry() && keyKind.equals((Object)CelExpr.ExprKind.Kind.CONSTANT) && valueKind.equals((Object)CelExpr.ExprKind.Kind.CALL))) {
                updatedEntryBuilder.add(entry);
                continue;
            }
            CelMutableExpr.CelMutableCall call = value.call();
            if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction())) {
                modified = true;
                continue;
            }
            if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction()) && (arg = call.args().get(0)).getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                modified = true;
                entry.setOptionalEntry(false);
                entry.setValue(call.args().get(0));
                updatedEntryBuilder.add(entry);
                continue;
            }
            updatedEntryBuilder.add(entry);
        }
        if (modified) {
            return this.astMutator.replaceSubtree(ast, CelMutableExpr.ofMap(CelMutableExpr.CelMutableMap.create((List<CelMutableExpr.CelMutableMap.Entry>)((Object)updatedEntryBuilder.build()))), expr.id());
        }
        return ast;
    }

    private CelMutableAst pruneOptionalStructElements(CelMutableAst ast, CelMutableExpr expr) {
        CelMutableExpr.CelMutableStruct struct = expr.struct();
        ImmutableList.Builder updatedEntryBuilder = new ImmutableList.Builder();
        boolean modified = false;
        for (CelMutableExpr.CelMutableStruct.Entry entry : struct.entries()) {
            CelMutableExpr arg;
            CelMutableExpr value = entry.value();
            CelExpr.ExprKind.Kind valueKind = value.getKind();
            if (!entry.optionalEntry() || !valueKind.equals((Object)CelExpr.ExprKind.Kind.CALL)) {
                updatedEntryBuilder.add(entry);
                continue;
            }
            CelMutableExpr.CelMutableCall call = value.call();
            if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction())) {
                modified = true;
                continue;
            }
            if (call.function().equals(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction()) && (arg = call.args().get(0)).getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
                modified = true;
                entry.setOptionalEntry(false);
                entry.setValue(call.args().get(0));
                updatedEntryBuilder.add(entry);
                continue;
            }
            updatedEntryBuilder.add(entry);
        }
        if (modified) {
            return this.astMutator.replaceSubtree(ast, CelMutableExpr.ofStruct(CelMutableExpr.CelMutableStruct.create(struct.messageName(), (List<CelMutableExpr.CelMutableStruct.Entry>)((Object)updatedEntryBuilder.build()))), expr.id());
        }
        return ast;
    }

    @CanIgnoreReturnValue
    private static Object evaluateExpr(Cel cel, CelExpr expr) throws CelValidationException, CelEvaluationException {
        CelAbstractSyntaxTree ast = CelAbstractSyntaxTree.newParsedAst(expr, CelSource.newBuilder().build());
        ast = cel.check(ast).getAst();
        return cel.createProgram(ast).eval();
    }

    private ConstantFoldingOptimizer(ConstantFoldingOptions constantFoldingOptions) {
        this.constantFoldingOptions = constantFoldingOptions;
        this.astMutator = AstMutator.newInstance(constantFoldingOptions.maxIterationLimit());
        this.foldableFunctions = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DefaultOptimizerConstants.CEL_CANONICAL_FUNCTIONS)).addAll(constantFoldingOptions.foldableFunctions())).build();
    }

    @AutoValue
    public static abstract class ConstantFoldingOptions {
        public abstract int maxIterationLimit();

        public abstract ImmutableSet<String> foldableFunctions();

        public static Builder newBuilder() {
            return new AutoValue_ConstantFoldingOptimizer_ConstantFoldingOptions.Builder().maxIterationLimit(400);
        }

        ConstantFoldingOptions() {
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract ImmutableSet.Builder<String> foldableFunctionsBuilder();

            public abstract Builder maxIterationLimit(int var1);

            @CanIgnoreReturnValue
            public Builder addFoldableFunctions(Iterable<String> functions) {
                Preconditions.checkNotNull(functions);
                this.foldableFunctionsBuilder().addAll((Iterable)functions);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addFoldableFunctions(String ... functions) {
                return this.addFoldableFunctions(Arrays.asList(functions));
            }

            public abstract ConstantFoldingOptions build();

            Builder() {
            }
        }
    }
}

