/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprFactory;

public abstract class CelMacroExprFactory
extends CelExprFactory {
    CelMacroExprFactory() {
    }

    @FormatMethod
    public final CelExpr reportError(@FormatString String format, Object ... args) {
        return this.reportError(CelIssue.formatError(this.currentSourceLocationForMacro(), String.format(format, args)));
    }

    public final CelExpr reportError(String message) {
        return this.reportError(CelIssue.formatError(this.currentSourceLocationForMacro(), message));
    }

    public abstract CelExpr reportError(CelIssue var1);

    public abstract String getAccumulatorVarName();

    public final CelSourceLocation getSourceLocation(CelExpr expr) {
        return this.getSourceLocation(expr.id());
    }

    public final CelExpr copy(CelExpr expr) {
        CelExpr.Builder builder = CelExpr.newBuilder().setId(this.copyExprId(expr.id()));
        switch (expr.exprKind().getKind()) {
            case CONSTANT: {
                builder.setConstant(expr.constant());
                break;
            }
            case IDENT: {
                builder.setIdent(expr.ident());
                break;
            }
            case SELECT: {
                builder.setSelect(CelExpr.CelSelect.newBuilder().setOperand(this.copy(expr.select().operand())).setField(expr.select().field()).setTestOnly(expr.select().testOnly()).build());
                break;
            }
            case CALL: {
                CelExpr.CelCall.Builder callBuilder = CelExpr.CelCall.newBuilder().setFunction(expr.call().function());
                expr.call().target().ifPresent(target -> callBuilder.setTarget(this.copy((CelExpr)target)));
                for (CelExpr arg : expr.call().args()) {
                    callBuilder.addArgs(this.copy(arg));
                }
                builder.setCall(callBuilder.build());
                break;
            }
            case LIST: {
                CelExpr.CelList.Builder listBuilder = CelExpr.CelList.newBuilder().addOptionalIndices(expr.list().optionalIndices());
                for (CelExpr element : expr.list().elements()) {
                    listBuilder.addElements(this.copy(element));
                }
                builder.setList(listBuilder.build());
                break;
            }
            case STRUCT: {
                CelExpr.CelStruct.Builder structBuilder = CelExpr.CelStruct.newBuilder().setMessageName(expr.struct().messageName());
                for (CelExpr.CelStruct.Entry entry : expr.struct().entries()) {
                    structBuilder.addEntries(CelExpr.CelStruct.Entry.newBuilder().setId(this.copyExprId(entry.id())).setFieldKey(entry.fieldKey()).setValue(this.copy(entry.value())).setOptionalEntry(entry.optionalEntry()).build());
                }
                builder.setStruct(structBuilder.build());
                break;
            }
            case MAP: {
                CelExpr.CelMap.Builder mapBuilder = CelExpr.CelMap.newBuilder();
                for (CelExpr.CelMap.Entry entry : expr.map().entries()) {
                    mapBuilder.addEntries(CelExpr.CelMap.Entry.newBuilder().setId(this.copyExprId(entry.id())).setKey(this.copy(entry.key())).setValue(this.copy(entry.value())).setOptionalEntry(entry.optionalEntry()).build());
                }
                builder.setMap(mapBuilder.build());
                break;
            }
            case COMPREHENSION: {
                builder.setComprehension(CelExpr.CelComprehension.newBuilder().setIterVar(expr.comprehension().iterVar()).setIterRange(this.copy(expr.comprehension().iterRange())).setAccuVar(expr.comprehension().accuVar()).setAccuInit(this.copy(expr.comprehension().accuInit())).setLoopCondition(this.copy(expr.comprehension().loopCondition())).setLoopStep(this.copy(expr.comprehension().loopStep())).setResult(this.copy(expr.comprehension().result())).build());
                break;
            }
        }
        return builder.build();
    }

    protected abstract long copyExprId(long var1);

    protected abstract CelSourceLocation getSourceLocation(long var1);

    protected abstract CelSourceLocation currentSourceLocationForMacro();
}

