/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import dev.cel.common.ast.CelExpr;
import java.util.ArrayList;

final class ExpressionBalancer {
    private final String function;
    private final ArrayList<CelExpr> terms;
    private final ArrayList<Long> ids;

    ExpressionBalancer(String function, CelExpr expr) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(function));
        this.function = function;
        this.terms = new ArrayList();
        this.terms.add(Preconditions.checkNotNull(expr));
        this.ids = new ArrayList();
    }

    void add(long operationId, CelExpr expr) {
        Preconditions.checkNotNull(expr);
        Preconditions.checkArgument(operationId > 0L);
        this.terms.add(expr);
        this.ids.add(operationId);
    }

    CelExpr balance() {
        Preconditions.checkState(this.terms.size() > 1);
        return this.balance(0, this.ids.size() - 1);
    }

    private CelExpr balance(int lo, int hi) {
        int mid = (lo + hi + 1) / 2;
        CelExpr left = mid == lo ? this.terms.get(mid) : this.balance(lo, mid - 1);
        CelExpr right = mid == hi ? this.terms.get(mid + 1) : this.balance(mid + 1, hi);
        return CelExpr.newBuilder().setId(this.ids.get(mid)).setCall(CelExpr.CelCall.newBuilder().setFunction(this.function).addArgs(left).addArgs(right).build()).build();
    }
}

