/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import cel.parser.internal.CELBaseVisitor;
import cel.parser.internal.CELLexer;
import cel.parser.internal.CELParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelIssue;
import dev.cel.common.CelOptions;
import dev.cel.common.CelSource;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.CelValidationResult;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.CodePointStream;
import dev.cel.common.internal.Constants;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.CelParserImpl;
import dev.cel.parser.ExpressionBalancer;
import dev.cel.parser.Operator;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

final class Parser
extends CELBaseVisitor<CelExpr> {
    private static final CelExpr ERROR = CelExpr.newBuilder().setConstant(Constants.ERROR).build();
    private static final ImmutableSet<String> RESERVED_IDS = ImmutableSet.of("as", "break", "const", "continue", "else", "false", new String[]{"for", "function", "if", "import", "in", "let", "loop", "package", "namespace", "null", "return", "true", "var", "void", "while"});
    private static final String ACCUMULATOR_NAME = "__result__";
    private static final String HIDDEN_ACCUMULATOR_NAME = "@result";
    private final CelParserImpl parser;
    private final CelOptions options;
    private final CelSource.Builder sourceInfo;
    private final ExprFactory exprFactory;
    private int recursionDepth;

    static CelValidationResult parse(CelParserImpl parser, CelSource source2, CelOptions options) {
        CelExpr expr;
        if (source2.getContent().size() > options.maxExpressionCodePointSize()) {
            return new CelValidationResult(source2, ImmutableList.of(CelIssue.formatError(CelSourceLocation.NONE, String.format("expression code point size exceeds limit: size: %d, limit %d", source2.getContent().size(), options.maxExpressionCodePointSize()))));
        }
        CELLexer antlrLexer = new CELLexer(new CodePointStream(source2.getDescription(), source2.getContent()));
        CELParser antlrParser = new CELParser(new CommonTokenStream(antlrLexer));
        CelSource.Builder sourceInfo = source2.toBuilder();
        sourceInfo.setDescription(source2.getDescription());
        ExprFactory exprFactory = new ExprFactory(antlrParser, sourceInfo, options.enableHiddenAccumulatorVar() ? HIDDEN_ACCUMULATOR_NAME : ACCUMULATOR_NAME);
        Parser parserImpl = new Parser(parser, options, sourceInfo, exprFactory);
        ErrorListener errorListener = new ErrorListener(exprFactory);
        antlrLexer.removeErrorListeners();
        antlrParser.removeErrorListeners();
        antlrLexer.addErrorListener(errorListener);
        antlrParser.addErrorListener(errorListener);
        antlrParser.addParseListener(new PerRuleRecursionListener(exprFactory, options.maxParseRecursionDepth()));
        antlrParser.setErrorHandler(new RecoveryLimitErrorStrategy(options.maxParseErrorRecoveryLimit()));
        try {
            CELParser.StartContext context = Preconditions.checkNotNull(antlrParser.start());
            expr = Preconditions.checkNotNull(parserImpl.visit(context));
        }
        catch (ParseCancellationException parseFailure) {
            return new CelValidationResult(sourceInfo.build(), parseFailure, ImmutableList.copyOf(exprFactory.getIssuesList()));
        }
        return new CelValidationResult(CelAbstractSyntaxTree.newParsedAst(expr, sourceInfo.build()), ImmutableList.copyOf(exprFactory.getIssuesList()));
    }

    private Parser(CelParserImpl parser, CelOptions options, CelSource.Builder sourceInfo, ExprFactory exprFactory) {
        this.parser = parser;
        this.options = options;
        this.sourceInfo = sourceInfo;
        this.exprFactory = exprFactory;
    }

    @Override
    public CelExpr visit(ParseTree tree) {
        ParseTree unnestedNode = this.unnest(tree);
        boolean isLeftRecursiveNode = this.isLeftRecursiveForCountingDepths(unnestedNode);
        if (isLeftRecursiveNode) {
            this.checkAndIncrementRecursionDepth();
            CelExpr expr = (CelExpr)super.visit(unnestedNode);
            this.decrementRecursionDepth();
            return expr;
        }
        return (CelExpr)super.visit(unnestedNode);
    }

    @Override
    public CelExpr visitStart(CELParser.StartContext context) {
        Preconditions.checkNotNull(context);
        if (context.e == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        return this.visit(context.e);
    }

    @Override
    public CelExpr visitExpr(CELParser.ExprContext context) {
        Preconditions.checkNotNull(context);
        if (context.e == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr condition = this.visit(context.e);
        if (context.op != null) {
            if (context.e1 == null || context.e2 == null) {
                return this.exprFactory.ensureErrorsExist(context);
            }
            condition = this.exprFactory.newExprBuilder(context.op).setCall(CelExpr.CelCall.newBuilder().setFunction(Operator.CONDITIONAL.getFunction()).addArgs(condition).addArgs(this.visit(context.e1)).addArgs(this.visit(context.e2)).build()).build();
        }
        return condition;
    }

    @Override
    public CelExpr visitConditionalOr(CELParser.ConditionalOrContext context) {
        Preconditions.checkNotNull(context);
        if (context.e == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr conditionalOr = this.visit(context.e);
        if (context.ops == null || context.ops.isEmpty()) {
            return conditionalOr;
        }
        ExpressionBalancer balancer = new ExpressionBalancer(Operator.LOGICAL_OR.getFunction(), conditionalOr);
        int index = 0;
        for (Token token : context.ops) {
            if (context.e1 == null || index >= context.e1.size()) {
                return this.exprFactory.reportError(context, "unexpected character, wanted '||'");
            }
            long operationId = this.exprFactory.newExprId(this.exprFactory.getPosition(token));
            CelExpr term = this.visit(context.e1.get(index));
            balancer.add(operationId, term);
            ++index;
        }
        return balancer.balance();
    }

    @Override
    public CelExpr visitConditionalAnd(CELParser.ConditionalAndContext context) {
        Preconditions.checkNotNull(context);
        if (context.e == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr conditionalAnd = this.visit(context.e);
        if (context.ops == null || context.ops.isEmpty()) {
            return conditionalAnd;
        }
        ExpressionBalancer balancer = new ExpressionBalancer(Operator.LOGICAL_AND.getFunction(), conditionalAnd);
        int index = 0;
        for (Token token : context.ops) {
            if (context.e1 == null || index >= context.e1.size()) {
                return this.exprFactory.reportError(context, "unexpected character, wanted '&&'");
            }
            long operationId = this.exprFactory.newExprId(this.exprFactory.getPosition(token));
            CelExpr term = this.visit(context.e1.get(index));
            balancer.add(operationId, term);
            ++index;
        }
        return balancer.balance();
    }

    @Override
    public CelExpr visitRelation(CELParser.RelationContext context) {
        Preconditions.checkNotNull(context);
        if (context.calc() != null) {
            return this.visit(context.calc());
        }
        if (context.relation() == null || context.relation().isEmpty() || context.op == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        Optional<Operator> operator = Operator.find(context.op.getText());
        if (!operator.isPresent()) {
            return this.exprFactory.reportError(context, "operator not found");
        }
        CelExpr left = this.visit(context.relation(0));
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr right = this.visit(context.relation(1));
        return exprBuilder.setCall(CelExpr.CelCall.newBuilder().setFunction(operator.get().getFunction()).addArgs(left).addArgs(right).build()).build();
    }

    @Override
    public CelExpr visitCalc(CELParser.CalcContext context) {
        Preconditions.checkNotNull(context);
        if (context.unary() != null) {
            return this.visit(context.unary());
        }
        if (context.calc() == null || context.calc().isEmpty() || context.op == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        Optional<Operator> operator = Operator.find(context.op.getText());
        if (!operator.isPresent()) {
            return this.exprFactory.reportError(context, "operator not found");
        }
        CelExpr left = this.visit(context.calc(0));
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr right = this.visit(context.calc(1));
        return exprBuilder.setCall(CelExpr.CelCall.newBuilder().setFunction(operator.get().getFunction()).addArgs(left).addArgs(right).build()).build();
    }

    @Override
    public CelExpr visitMemberExpr(CELParser.MemberExprContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        return this.visit(context.member());
    }

    @Override
    public CelExpr visitLogicalNot(CELParser.LogicalNotContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        if (context.ops != null && this.options.retainRepeatedUnaryOperators()) {
            CelExpr expr = this.visit(context.member());
            for (int index = context.ops.size(); index > 0; --index) {
                expr = this.exprFactory.newExprBuilder(context.ops.get(index - 1)).setCall(CelExpr.CelCall.newBuilder().setFunction(Operator.LOGICAL_NOT.getFunction()).addArgs(expr).build()).build();
            }
            return expr;
        }
        if (context.ops == null || context.ops.size() % 2 == 0) {
            return this.visit(context.member());
        }
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.ops.get(0));
        CelExpr member = this.visit(context.member());
        return exprBuilder.setCall(CelExpr.CelCall.newBuilder().setFunction(Operator.LOGICAL_NOT.getFunction()).addArgs(member).build()).build();
    }

    @Override
    public CelExpr visitNegate(CELParser.NegateContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        if (context.ops != null && this.options.retainRepeatedUnaryOperators()) {
            CelExpr expr = this.visit(context.member());
            for (int index = context.ops.size(); index > 0; --index) {
                expr = this.exprFactory.newExprBuilder(context.ops.get(index - 1)).setCall(CelExpr.CelCall.newBuilder().setFunction(Operator.NEGATE.getFunction()).addArgs(expr).build()).build();
            }
            return expr;
        }
        if (context.ops == null || context.ops.size() % 2 == 0) {
            return this.visit(context.member());
        }
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.ops.get(0));
        CelExpr member = this.visit(context.member());
        return exprBuilder.setCall(CelExpr.CelCall.newBuilder().setFunction(Operator.NEGATE.getFunction()).addArgs(member).build()).build();
    }

    @Override
    public CelExpr visitPrimaryExpr(CELParser.PrimaryExprContext context) {
        Preconditions.checkNotNull(context);
        if (context.primary() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        return this.visit(context.primary());
    }

    @Override
    public CelExpr visitSelect(CELParser.SelectContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr member = this.visit(context.member());
        if (context.id == null) {
            return this.exprFactory.newExprBuilder(context).build();
        }
        String id = this.normalizeEscapedIdent(context.id);
        if (context.opt != null && context.opt.getText().equals("?")) {
            if (!this.options.enableOptionalSyntax()) {
                return this.exprFactory.reportError(context.op, "unsupported syntax '.?'");
            }
            CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(this.exprFactory.getPosition(context.op));
            CelExpr.CelCall callExpr = CelExpr.CelCall.newBuilder().setFunction(Operator.OPTIONAL_SELECT.getFunction()).addArgs(Arrays.asList(member, this.exprFactory.newExprBuilder(context).setConstant(CelConstant.ofValue(id)).build())).build();
            return exprBuilder.setCall(callExpr).build();
        }
        return this.exprFactory.newExprBuilder(context.op).setSelect(CelExpr.CelSelect.newBuilder().setOperand(member).setField(id).build()).build();
    }

    @Override
    public CelExpr visitMemberCall(CELParser.MemberCallContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr member = this.visit(context.member());
        if (context.id == null) {
            return this.exprFactory.newExprBuilder(context).build();
        }
        String id = context.id.getText();
        return this.receiverCallOrMacro(context, id, member);
    }

    @Override
    public CelExpr visitIndex(CELParser.IndexContext context) {
        Preconditions.checkNotNull(context);
        if (context.member() == null || context.index == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr member = this.visit(context.member());
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr index = this.visit(context.index);
        Operator indexOperator = Operator.INDEX;
        if (context.opt != null && context.opt.getText().equals("?")) {
            if (!this.options.enableOptionalSyntax()) {
                return this.exprFactory.reportError(context.op, "unsupported syntax '[?'");
            }
            indexOperator = Operator.OPTIONAL_INDEX;
        }
        return exprBuilder.setCall(CelExpr.CelCall.newBuilder().setFunction(indexOperator.getFunction()).addArgs(member).addArgs(index).build()).build();
    }

    @Override
    public CelExpr visitCreateMessage(CELParser.CreateMessageContext context) {
        String messageName;
        Preconditions.checkNotNull(context);
        StringBuilder msgNameBuilder = new StringBuilder();
        for (Token token : context.ids) {
            if (msgNameBuilder.length() > 0) {
                msgNameBuilder.append(".");
            }
            msgNameBuilder.append(token.getText());
        }
        if (context.leadingDot != null) {
            msgNameBuilder.insert(0, ".");
        }
        if ((messageName = msgNameBuilder.toString()).isEmpty()) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr.CelStruct.Builder structExpr = this.visitStructFields(context.entries);
        return exprBuilder.setStruct(structExpr.setMessageName(messageName).build()).build();
    }

    @Override
    public CelExpr visitIdent(CELParser.IdentContext context) {
        Preconditions.checkNotNull(context);
        if (context.id == null) {
            return this.exprFactory.newExprBuilder(context).build();
        }
        String id = context.id.getText();
        if (this.options.enableReservedIds() && RESERVED_IDS.contains(id)) {
            return this.exprFactory.reportError(context, "reserved identifier: %s", new Object[]{id});
        }
        if (context.leadingDot != null) {
            id = "." + id;
        }
        return this.exprFactory.newExprBuilder(context.id).setIdent(CelExpr.CelIdent.newBuilder().setName(id).build()).build();
    }

    @Override
    public CelExpr visitGlobalCall(CELParser.GlobalCallContext context) {
        Preconditions.checkNotNull(context);
        if (context.id == null) {
            return this.exprFactory.newExprBuilder(context).build();
        }
        String id = context.id.getText();
        if (this.options.enableReservedIds() && RESERVED_IDS.contains(id)) {
            return this.exprFactory.reportError(context, "reserved identifier: %s", new Object[]{id});
        }
        if (context.leadingDot != null) {
            id = "." + id;
        }
        return this.globalCallOrMacro(context, id);
    }

    @Override
    public CelExpr visitNested(CELParser.NestedContext context) {
        Preconditions.checkNotNull(context);
        if (context.e == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        return this.visit(context.e);
    }

    @Override
    public CelExpr visitCreateList(CELParser.CreateListContext context) {
        Preconditions.checkNotNull(context);
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr.CelList createListExpr = this.visitListInitElements(context.listInit());
        return exprBuilder.setList(createListExpr).build();
    }

    private CelExpr.CelList visitListInitElements(CELParser.ListInitContext context) {
        CelExpr.CelList.Builder listExpr = CelExpr.CelList.newBuilder();
        if (context == null) {
            return listExpr.build();
        }
        for (int index = 0; index < context.elems.size(); ++index) {
            CELParser.OptExprContext elem = context.elems.get(index);
            listExpr.addElements(this.visit(elem.e));
            if (elem.opt == null) continue;
            if (!this.options.enableOptionalSyntax()) {
                this.exprFactory.reportError(elem.opt, "unsupported syntax '?'");
                continue;
            }
            listExpr.addOptionalIndices(index);
        }
        return listExpr.build();
    }

    @Override
    public CelExpr visitCreateMap(CELParser.CreateMapContext context) {
        Preconditions.checkNotNull(context);
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(context.op);
        CelExpr.CelMap.Builder createMapExpr = this.visitMapEntries(context.entries);
        return exprBuilder.setMap(createMapExpr.build()).build();
    }

    private CelExpr buildMacroCallArgs(CelExpr expr) {
        CelExpr.Builder resultExpr = CelExpr.newBuilder().setId(expr.id());
        if (this.sourceInfo.containsMacroCalls(expr.id())) {
            return resultExpr.build();
        }
        if (expr.exprKind().getKind() == CelExpr.ExprKind.Kind.CALL) {
            CelExpr.CelCall.Builder callExpr = CelExpr.CelCall.newBuilder().setFunction(expr.call().function());
            ((ImmutableList)expr.call().args()).forEach(arg -> callExpr.addArgs(this.buildMacroCallArgs((CelExpr)arg)));
            expr.call().target().ifPresent(target -> callExpr.setTarget(this.buildMacroCallArgs((CelExpr)target)));
            return resultExpr.setCall(callExpr.build()).build();
        }
        return expr;
    }

    private Optional<CelExpr> visitMacro(CelExpr.Builder expr, String id, ImmutableList<CelExpr> args, Optional<CelExpr> target, CelMacro macro) {
        Optional<CelExpr> expandedMacro = this.expandMacro(this.exprFactory.getPosition(expr.id()), macro, target.orElse(CelExpr.newBuilder().build()), args);
        if (!expandedMacro.isPresent()) {
            return Optional.empty();
        }
        CelExpr.CelCall.Builder callExpr = CelExpr.CelCall.newBuilder().setFunction(id);
        if (target.isPresent()) {
            if (this.sourceInfo.containsMacroCalls(target.get().id())) {
                callExpr.setTarget(CelExpr.newBuilder().setId(target.get().id()).build());
            } else {
                callExpr.setTarget(target.get());
            }
        }
        for (CelExpr arg : args) {
            callExpr.addArgs(this.buildMacroCallArgs(arg));
        }
        if (this.options.populateMacroCalls()) {
            this.sourceInfo.addMacroCalls(expandedMacro.get().id(), CelExpr.newBuilder().setCall(callExpr.build()).build());
        }
        this.exprFactory.maybeDeleteId(expr.id());
        return expandedMacro;
    }

    private String normalizeEscapedIdent(CELParser.EscapeIdentContext context) {
        String identifier = context.getText();
        if (context instanceof CELParser.SimpleIdentifierContext) {
            return identifier;
        }
        if (context instanceof CELParser.EscapedIdentifierContext) {
            if (!this.options.enableQuotedIdentifierSyntax()) {
                this.exprFactory.reportError(context, "unsupported syntax '`'");
                return identifier;
            }
            return identifier.substring(1, identifier.length() - 1);
        }
        this.exprFactory.reportError(context, "unsupported identifier");
        return identifier;
    }

    private CelExpr.CelStruct.Builder visitStructFields(CELParser.FieldInitializerListContext context) {
        if (context == null || context.cols == null || context.fields == null || context.values == null) {
            return CelExpr.CelStruct.newBuilder();
        }
        int entryCount = Ints.min(context.cols.size(), context.fields.size(), context.values.size());
        CelExpr.CelStruct.Builder structExpr = CelExpr.CelStruct.newBuilder();
        for (int index = 0; index < entryCount; ++index) {
            CELParser.OptFieldContext fieldContext = context.fields.get(index);
            boolean isOptionalEntry = false;
            if (fieldContext.opt != null) {
                if (!this.options.enableOptionalSyntax()) {
                    this.exprFactory.reportError(fieldContext.opt, "unsupported syntax '?'");
                } else {
                    isOptionalEntry = true;
                }
            }
            if (fieldContext.escapeIdent() == null) {
                return CelExpr.CelStruct.newBuilder();
            }
            String fieldName = this.normalizeEscapedIdent(fieldContext.escapeIdent());
            CelExpr.CelStruct.Entry.Builder exprBuilder = CelExpr.CelStruct.Entry.newBuilder().setId(this.exprFactory.newExprId(this.exprFactory.getPosition(context.cols.get(index))));
            structExpr.addEntries(exprBuilder.setFieldKey(fieldName).setValue(this.visit(context.values.get(index))).setOptionalEntry(isOptionalEntry).build());
        }
        return structExpr;
    }

    private CelExpr.CelMap.Builder visitMapEntries(CELParser.MapInitializerListContext context) {
        if (context == null || context.cols == null || context.keys == null || context.values == null) {
            return CelExpr.CelMap.newBuilder();
        }
        int entryCount = Ints.min(context.cols.size(), context.keys.size(), context.values.size());
        CelExpr.CelMap.Builder mapExpr = CelExpr.CelMap.newBuilder();
        for (int index = 0; index < entryCount; ++index) {
            CELParser.OptExprContext keyContext = context.keys.get(index);
            boolean isOptionalEntry = false;
            if (keyContext.opt != null) {
                if (!this.options.enableOptionalSyntax()) {
                    this.exprFactory.reportError(keyContext.opt, "unsupported syntax '?'");
                } else {
                    isOptionalEntry = true;
                }
            }
            CelExpr.CelMap.Entry.Builder exprBuilder = CelExpr.CelMap.Entry.newBuilder().setId(this.exprFactory.newExprId(this.exprFactory.getPosition(context.cols.get(index))));
            mapExpr.addEntries(exprBuilder.setKey(this.visit(keyContext.e)).setValue(this.visit(context.values.get(index))).setOptionalEntry(isOptionalEntry).build());
        }
        return mapExpr;
    }

    @Override
    protected CelExpr defaultResult() {
        return this.exprFactory.ensureErrorsExist(() -> "Abstract syntax tree in an unexpected state, this is likely a bug.");
    }

    @Override
    public CelExpr visitConstantLiteral(CELParser.ConstantLiteralContext context) {
        Preconditions.checkNotNull(context);
        if (context.literal() == null) {
            return this.exprFactory.ensureErrorsExist(context);
        }
        return this.visit(context.literal());
    }

    @Override
    public CelExpr visitExprList(CELParser.ExprListContext context) {
        return this.exprFactory.ensureErrorsExist(context);
    }

    @Override
    public CelExpr visitFieldInitializerList(CELParser.FieldInitializerListContext context) {
        return this.exprFactory.ensureErrorsExist(context);
    }

    @Override
    public CelExpr visitMapInitializerList(CELParser.MapInitializerListContext context) {
        return this.exprFactory.ensureErrorsExist(context);
    }

    @Override
    public CelExpr visitListInit(CELParser.ListInitContext context) {
        return this.exprFactory.ensureErrorsExist(context);
    }

    @Override
    public CelExpr visitInt(CELParser.IntContext context) {
        CelConstant constExpr;
        Preconditions.checkNotNull(context);
        try {
            constExpr = Constants.parseInt(context.getText());
        }
        catch (ParseException e) {
            return this.exprFactory.reportError(context, e.getMessage());
        }
        return this.exprFactory.newExprBuilder(context.tok).setConstant(constExpr).build();
    }

    @Override
    public CelExpr visitUint(CELParser.UintContext context) {
        CelConstant constExpr;
        Preconditions.checkNotNull(context);
        try {
            constExpr = Constants.parseUint(context.getText());
        }
        catch (ParseException e) {
            return this.exprFactory.reportError(context, e.getMessage());
        }
        return this.exprFactory.newExprBuilder(context).setConstant(constExpr).build();
    }

    @Override
    public CelExpr visitDouble(CELParser.DoubleContext context) {
        CelConstant constExpr;
        Preconditions.checkNotNull(context);
        try {
            constExpr = Constants.parseDouble(context.getText());
        }
        catch (ParseException e) {
            return this.exprFactory.reportError(context, e.getMessage());
        }
        return this.exprFactory.newExprBuilder(context.tok).setConstant(constExpr).build();
    }

    @Override
    public CelExpr visitString(CELParser.StringContext context) {
        CelConstant constExpr;
        Preconditions.checkNotNull(context);
        try {
            constExpr = Constants.parseString(context.getText());
        }
        catch (ParseException e) {
            return this.exprFactory.reportError(context, e.getMessage());
        }
        return this.exprFactory.newExprBuilder(context).setConstant(constExpr).build();
    }

    @Override
    public CelExpr visitBytes(CELParser.BytesContext context) {
        CelConstant constExpr;
        Preconditions.checkNotNull(context);
        try {
            constExpr = Constants.parseBytes(context.getText());
        }
        catch (ParseException e) {
            return this.exprFactory.reportError(context, e.getMessage());
        }
        return this.exprFactory.newExprBuilder(context).setConstant(constExpr).build();
    }

    @Override
    public CelExpr visitBoolTrue(CELParser.BoolTrueContext context) {
        Preconditions.checkNotNull(context);
        return this.exprFactory.newExprBuilder(context).setConstant(Constants.TRUE).build();
    }

    @Override
    public CelExpr visitBoolFalse(CELParser.BoolFalseContext context) {
        Preconditions.checkNotNull(context);
        return this.exprFactory.newExprBuilder(context).setConstant(Constants.FALSE).build();
    }

    @Override
    public CelExpr visitNull(CELParser.NullContext context) {
        Preconditions.checkNotNull(context);
        return this.exprFactory.newExprBuilder(context).setConstant(Constants.NULL).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CelExpr> expandMacro(int position, CelMacro macro, CelExpr target, ImmutableList<CelExpr> arguments) {
        this.exprFactory.pushPosition(position);
        try {
            Optional<CelExpr> optional = macro.getExpander().expandMacro(this.exprFactory, target, arguments);
            return optional;
        }
        finally {
            this.exprFactory.popPosition();
        }
    }

    private CelExpr receiverCallOrMacro(CELParser.MemberCallContext context, String id, CelExpr member) {
        return this.macroOrCall(context.args, context.open, id, Optional.of(member), true);
    }

    private CelExpr globalCallOrMacro(CELParser.GlobalCallContext context, String id) {
        return this.macroOrCall(context.args, context.op, id, Optional.empty(), false);
    }

    private ImmutableList<CelExpr> visitExprListContext(CELParser.ExprListContext args) {
        int argCount;
        int n = argCount = args != null && args.e != null ? args.e.size() : 0;
        if (argCount == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder argumentsBuilder = ImmutableList.builderWithExpectedSize(argCount);
        for (CELParser.ExprContext argExprCtx : args.e) {
            argumentsBuilder.add(this.visit(argExprCtx));
        }
        return argumentsBuilder.build();
    }

    private CelExpr macroOrCall(CELParser.ExprListContext args, Token open, String id, Optional<CelExpr> member, boolean isReceiverStyle) {
        Optional<CelExpr> expandedMacro;
        int argCount = args != null && args.e != null ? args.e.size() : 0;
        Optional<CelMacro> macro = this.lookupMacro(id, argCount, isReceiverStyle);
        CelExpr.Builder exprBuilder = this.exprFactory.newExprBuilder(open);
        ImmutableList<CelExpr> arguments = this.visitExprListContext(args);
        Optional<CelExpr> errorArg = arguments.stream().filter(ERROR::equals).findAny();
        if (errorArg.isPresent()) {
            this.sourceInfo.removePositions(exprBuilder.id());
            return ERROR;
        }
        if (macro.isPresent() && (expandedMacro = this.visitMacro(exprBuilder, id, arguments, member, macro.get())).isPresent()) {
            return expandedMacro.get();
        }
        CelExpr.CelCall.Builder callExpr = CelExpr.CelCall.newBuilder().setFunction(id).addArgs(arguments);
        member.ifPresent(callExpr::setTarget);
        return exprBuilder.setCall(callExpr.build()).build();
    }

    private Optional<CelMacro> lookupMacro(String id, int argCount, boolean receiverStlye) {
        String key = CelMacro.formatKey(id, argCount, receiverStlye);
        Optional<CelMacro> macro = this.parser.findMacro(key);
        if (macro.isPresent()) {
            return macro;
        }
        key = CelMacro.formatVarArgKey(id, receiverStlye);
        return this.parser.findMacro(key);
    }

    private boolean isLeftRecursiveForCountingDepths(ParseTree node) {
        return node instanceof CELParser.ExprContext || node instanceof CELParser.CalcContext || node instanceof CELParser.RelationContext || node instanceof CELParser.SelectContext || node instanceof CELParser.MemberCallContext || node instanceof CELParser.IndexContext;
    }

    private void checkAndIncrementRecursionDepth() {
        ++this.recursionDepth;
        if (this.recursionDepth > this.options.maxParseRecursionDepth()) {
            String errorMessage = String.format("Expression recursion limit exceeded. limit: %d", this.options.maxParseRecursionDepth());
            this.exprFactory.reportError(CelIssue.formatError(CelSourceLocation.of(1, 0), errorMessage));
            throw new ParseCancellationException(errorMessage);
        }
    }

    private void decrementRecursionDepth() {
        --this.recursionDepth;
    }

    private ParseTree unnest(ParseTree tree) {
        while (tree != null) {
            ParserRuleContext context;
            if (tree instanceof CELParser.ExprContext) {
                context = (CELParser.ExprContext)tree;
                if (((CELParser.ExprContext)context).op != null) {
                    return tree;
                }
                tree = ((CELParser.ExprContext)context).e;
                continue;
            }
            if (tree instanceof CELParser.ConditionalOrContext) {
                context = (CELParser.ConditionalOrContext)tree;
                if (((CELParser.ConditionalOrContext)context).ops != null && !((CELParser.ConditionalOrContext)context).ops.isEmpty()) {
                    return tree;
                }
                tree = ((CELParser.ConditionalOrContext)context).e;
                continue;
            }
            if (tree instanceof CELParser.ConditionalAndContext) {
                context = (CELParser.ConditionalAndContext)tree;
                if (((CELParser.ConditionalAndContext)context).ops != null && !((CELParser.ConditionalAndContext)context).ops.isEmpty()) {
                    return tree;
                }
                tree = ((CELParser.ConditionalAndContext)context).e;
                continue;
            }
            if (tree instanceof CELParser.RelationContext) {
                context = (CELParser.RelationContext)tree;
                if (((CELParser.RelationContext)context).op != null) {
                    return tree;
                }
                tree = ((CELParser.RelationContext)context).calc();
                continue;
            }
            if (tree instanceof CELParser.CalcContext) {
                context = (CELParser.CalcContext)tree;
                if (((CELParser.CalcContext)context).op != null) {
                    return tree;
                }
                tree = ((CELParser.CalcContext)context).unary();
                continue;
            }
            if (tree instanceof CELParser.MemberExprContext) {
                tree = ((CELParser.MemberExprContext)tree).member();
                continue;
            }
            if (tree instanceof CELParser.PrimaryExprContext) {
                tree = ((CELParser.PrimaryExprContext)tree).primary();
                continue;
            }
            if (tree instanceof CELParser.NestedContext) {
                tree = ((CELParser.NestedContext)tree).e;
                continue;
            }
            if (tree instanceof CELParser.ConstantLiteralContext) {
                tree = ((CELParser.ConstantLiteralContext)tree).literal();
                continue;
            }
            return tree;
        }
        return tree;
    }

    private static final class ExprFactory
    extends CelMacroExprFactory {
        private final org.antlr.v4.runtime.Parser recognizer;
        private final CelSource.Builder sourceInfo;
        private final ArrayList<CelIssue> issues;
        private final ArrayDeque<Integer> positions;
        private final String accumulatorVarName;

        private ExprFactory(org.antlr.v4.runtime.Parser recognizer, CelSource.Builder sourceInfo, String accumulatorVarName) {
            this.recognizer = recognizer;
            this.sourceInfo = sourceInfo;
            this.issues = new ArrayList();
            this.positions = new ArrayDeque(1);
            this.accumulatorVarName = accumulatorVarName;
        }

        @Override
        protected CelSourceLocation getSourceLocation(long exprId) {
            Preconditions.checkArgument(exprId > 0L);
            return this.getLocation(this.getPosition(exprId));
        }

        @Override
        @CanIgnoreReturnValue
        public CelExpr reportError(CelIssue error) {
            Preconditions.checkNotNull(error);
            this.issues.add(error);
            if (!CelSourceLocation.NONE.equals(error.getSourceLocation())) {
                Optional<Integer> offset = this.sourceInfo.getLocationOffset(error.getSourceLocation());
                Preconditions.checkState(offset.isPresent());
                return this.newExpr(offset.get());
            }
            return ERROR;
        }

        @Override
        public String getAccumulatorVarName() {
            return this.accumulatorVarName;
        }

        @FormatMethod
        @CanIgnoreReturnValue
        private CelExpr reportError(ParserRuleContext context, @FormatString String format, Object ... args) {
            return this.reportError(context, String.format(format, args));
        }

        @CanIgnoreReturnValue
        private CelExpr reportError(ParserRuleContext context, String message) {
            return this.reportError(CelIssue.formatError(this.getLocation(context), message));
        }

        @CanIgnoreReturnValue
        private CelExpr reportError(Token token, String message) {
            return this.reportError(CelIssue.formatError(this.getLocation(token), message));
        }

        @Override
        protected CelSourceLocation currentSourceLocationForMacro() {
            Preconditions.checkState(!this.positions.isEmpty());
            return this.getLocation(this.peekPosition());
        }

        private void pushPosition(int position) {
            this.positions.addLast(position);
        }

        private void popPosition() {
            Preconditions.checkState(!this.positions.isEmpty());
            this.positions.removeLast();
        }

        private int peekPosition() {
            Preconditions.checkState(!this.positions.isEmpty());
            return this.positions.peekLast();
        }

        private long nextExprId(int position) {
            long exprId = super.nextExprId();
            if (position != -1) {
                this.sourceInfo.addPositions(exprId, position);
            }
            return exprId;
        }

        @Override
        protected void maybeDeleteId(long id) {
            this.sourceInfo.removePositions(id);
            super.maybeDeleteId(id);
        }

        @Override
        public long copyExprId(long id) {
            return this.nextExprId(this.getPosition(id));
        }

        @Override
        public long nextExprId() {
            Preconditions.checkState(!this.positions.isEmpty());
            return this.nextExprId(this.peekPosition());
        }

        private List<CelIssue> getIssuesList() {
            return this.issues;
        }

        private int getPosition(long exprId) {
            return Optional.ofNullable(this.sourceInfo.getPositionsMap().get(exprId)).orElse(-1);
        }

        private int getPosition(Token token) {
            return this.sourceInfo.getLocationOffset(token.getLine(), token.getCharPositionInLine()).orElse(-1);
        }

        private int getPosition(ParserRuleContext context) {
            return this.getPosition(context.getStart());
        }

        private CelSourceLocation getLocation(int position) {
            return this.sourceInfo.getOffsetLocation(position).orElse(CelSourceLocation.NONE);
        }

        private CelSourceLocation getLocation(Token token) {
            return CelSourceLocation.of(token.getLine(), token.getCharPositionInLine());
        }

        private CelSourceLocation getLocation(ParserRuleContext context) {
            return this.getLocation(context.getStart());
        }

        @CanIgnoreReturnValue
        private long newExprId(int position) {
            return this.nextExprId(position);
        }

        private CelExpr.Builder newExprBuilder(int position) {
            return CelExpr.newBuilder().setId(this.newExprId(position));
        }

        private CelExpr.Builder newExprBuilder(Token token) {
            return this.newExprBuilder(this.getPosition(token));
        }

        private CelExpr.Builder newExprBuilder(ParserRuleContext context) {
            return this.newExprBuilder(this.getPosition(context));
        }

        private CelExpr newExpr(int position) {
            return this.newExprBuilder(position).build();
        }

        private CelExpr ensureErrorsExist(Supplier<String> message) {
            if (this.issues.isEmpty()) {
                throw new ParseCancellationException(String.format("Abstract syntax tree in an unexpected state, this is likely a bug: %s", message.get()));
            }
            return ERROR;
        }

        private CelExpr ensureErrorsExist(ParserRuleContext context) {
            return this.ensureErrorsExist(() -> context.toInfoString(this.recognizer));
        }
    }

    private static final class ErrorListener
    implements ANTLRErrorListener {
        private final ExprFactory exprFactory;

        private ErrorListener(ExprFactory exprFactory) {
            this.exprFactory = exprFactory;
        }

        @Override
        public void reportAmbiguity(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            msg = msg.replace("%", "%%");
            this.exprFactory.reportError(CelIssue.formatError(CelSourceLocation.of(line, charPositionInLine), msg));
        }
    }

    private static final class PerRuleRecursionListener
    implements ParseTreeListener {
        private final ExprFactory exprFactory;
        private final int maxRecursionDepth;
        private final Map<Integer, Integer> ruleTypeDepth;

        private PerRuleRecursionListener(ExprFactory exprFactory, int maxRecursionDepth) {
            this.exprFactory = exprFactory;
            this.maxRecursionDepth = maxRecursionDepth;
            this.ruleTypeDepth = new HashMap<Integer, Integer>();
        }

        @Override
        public void enterEveryRule(ParserRuleContext context) {
            int ruleDepth = this.ruleTypeDepth.getOrDefault(context.getRuleIndex(), 0) + 1;
            this.ruleTypeDepth.put(context.getRuleIndex(), ruleDepth);
            if (ruleDepth > this.maxRecursionDepth) {
                String errorMessage = String.format("Expression recursion limit exceeded. limit: %d", this.maxRecursionDepth);
                this.exprFactory.reportError(CelIssue.formatError(CelSourceLocation.of(1, 0), errorMessage));
                throw new ParseCancellationException(errorMessage);
            }
        }

        @Override
        public void exitEveryRule(ParserRuleContext context) {
            int ruleDepth = this.ruleTypeDepth.get(context.getRuleIndex()) - 1;
            this.ruleTypeDepth.put(context.getRuleIndex(), ruleDepth);
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
        }

        @Override
        public void visitTerminal(TerminalNode node) {
        }
    }

    private static final class RecoveryLimitErrorStrategy
    extends DefaultErrorStrategy {
        private final int recoveryLimit;
        private int recoveryAttempts;

        private RecoveryLimitErrorStrategy(int recoveryLimit) {
            this.recoveryLimit = recoveryLimit;
            this.recoveryAttempts = 0;
        }

        @Override
        public void recover(org.antlr.v4.runtime.Parser recognizer, RecognitionException e) {
            this.checkRecoveryLimit(recognizer);
            super.recover(recognizer, e);
        }

        @Override
        public Token recoverInline(org.antlr.v4.runtime.Parser recognizer) {
            this.checkRecoveryLimit(recognizer);
            return super.recoverInline(recognizer);
        }

        private void checkRecoveryLimit(org.antlr.v4.runtime.Parser recognizer) {
            if (this.recoveryAttempts++ >= this.recoveryLimit) {
                String tooManyErrors = String.format("More than %d parse errors.", this.recoveryLimit);
                recognizer.notifyErrorListeners(tooManyErrors);
                throw new ParseCancellationException(tooManyErrors);
            }
        }
    }
}

