/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.common.collect.ImmutableMap;
import dev.cel.common.formats.ValueString;
import dev.cel.policy.CelPolicy;
import dev.cel.policy.CelPolicySource;

final class AutoValue_CelPolicy
extends CelPolicy {
    private final ValueString name;
    private final CelPolicy.Rule rule;
    private final CelPolicySource policySource;
    private final ImmutableMap<String, Object> metadata;

    private AutoValue_CelPolicy(ValueString name, CelPolicy.Rule rule, CelPolicySource policySource, ImmutableMap<String, Object> metadata) {
        this.name = name;
        this.rule = rule;
        this.policySource = policySource;
        this.metadata = metadata;
    }

    @Override
    public ValueString name() {
        return this.name;
    }

    @Override
    public CelPolicy.Rule rule() {
        return this.rule;
    }

    @Override
    public CelPolicySource policySource() {
        return this.policySource;
    }

    @Override
    public ImmutableMap<String, Object> metadata() {
        return this.metadata;
    }

    public String toString() {
        return "CelPolicy{name=" + this.name + ", rule=" + this.rule + ", policySource=" + this.policySource + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CelPolicy) {
            CelPolicy that = (CelPolicy)o;
            return this.name.equals(that.name()) && this.rule.equals(that.rule()) && this.policySource.equals(that.policySource()) && this.metadata.equals(that.metadata());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.rule.hashCode();
        h$ *= 1000003;
        h$ ^= this.policySource.hashCode();
        h$ *= 1000003;
        return h$ ^= this.metadata.hashCode();
    }

    static final class Builder
    extends CelPolicy.Builder {
        private ValueString name;
        private CelPolicy.Rule rule;
        private CelPolicySource policySource;
        private ImmutableMap.Builder<String, Object> metadataBuilder$;
        private ImmutableMap<String, Object> metadata;

        Builder() {
        }

        @Override
        public CelPolicy.Builder setName(ValueString name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public CelPolicy.Builder setRule(CelPolicy.Rule rule) {
            if (rule == null) {
                throw new NullPointerException("Null rule");
            }
            this.rule = rule;
            return this;
        }

        @Override
        public CelPolicy.Builder setPolicySource(CelPolicySource policySource) {
            if (policySource == null) {
                throw new NullPointerException("Null policySource");
            }
            this.policySource = policySource;
            return this;
        }

        @Override
        public CelPolicySource policySource() {
            if (this.policySource == null) {
                throw new IllegalStateException("Property \"policySource\" has not been set");
            }
            return this.policySource;
        }

        @Override
        public CelPolicy.Builder setMetadata(ImmutableMap<String, Object> metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            if (this.metadataBuilder$ != null) {
                throw new IllegalStateException("Cannot set metadata after calling metadataBuilder()");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        ImmutableMap.Builder<String, Object> metadataBuilder() {
            if (this.metadataBuilder$ == null) {
                if (this.metadata == null) {
                    this.metadataBuilder$ = ImmutableMap.builder();
                } else {
                    this.metadataBuilder$ = ImmutableMap.builder();
                    this.metadataBuilder$.putAll(this.metadata);
                    this.metadata = null;
                }
            }
            return this.metadataBuilder$;
        }

        @Override
        public CelPolicy build() {
            if (this.metadataBuilder$ != null) {
                this.metadata = this.metadataBuilder$.buildOrThrow();
            } else if (this.metadata == null) {
                this.metadata = ImmutableMap.of();
            }
            if (this.name == null || this.rule == null || this.policySource == null) {
                StringBuilder missing = new StringBuilder();
                if (this.name == null) {
                    missing.append(" name");
                }
                if (this.rule == null) {
                    missing.append(" rule");
                }
                if (this.policySource == null) {
                    missing.append(" policySource");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CelPolicy(this.name, this.rule, this.policySource, this.metadata);
        }
    }
}

