/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelVarDecl;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.formats.ValueString;
import dev.cel.policy.AutoOneOf_CelCompiledRule_CelCompiledMatch_Result;
import dev.cel.policy.AutoValue_CelCompiledRule;
import dev.cel.policy.AutoValue_CelCompiledRule_CelCompiledMatch;
import dev.cel.policy.AutoValue_CelCompiledRule_CelCompiledMatch_OutputValue;
import dev.cel.policy.AutoValue_CelCompiledRule_CelCompiledVariable;
import java.util.Optional;

@AutoValue
public abstract class CelCompiledRule {
    public abstract long sourceId();

    public abstract Optional<ValueString> ruleId();

    public abstract ImmutableList<CelCompiledVariable> variables();

    public abstract ImmutableList<CelCompiledMatch> matches();

    public abstract Cel cel();

    public boolean hasOptionalOutput() {
        boolean isOptionalOutput = false;
        for (CelCompiledMatch match : this.matches()) {
            if (match.result().kind().equals((Object)CelCompiledMatch.Result.Kind.RULE) && match.result().rule().hasOptionalOutput()) {
                return true;
            }
            if (match.isConditionTriviallyTrue()) {
                return false;
            }
            isOptionalOutput = true;
        }
        return isOptionalOutput;
    }

    static CelCompiledRule create(long sourceId, Optional<ValueString> ruleId, ImmutableList<CelCompiledVariable> variables, ImmutableList<CelCompiledMatch> matches, Cel cel) {
        return new AutoValue_CelCompiledRule(sourceId, ruleId, variables, matches, cel);
    }

    @AutoValue
    public static abstract class CelCompiledMatch {
        public abstract long sourceId();

        public abstract CelAbstractSyntaxTree condition();

        public abstract Result result();

        public boolean isConditionTriviallyTrue() {
            CelExpr celExpr = this.condition().getExpr();
            return celExpr.constantOrDefault().getKind().equals((Object)CelConstant.Kind.BOOLEAN_VALUE) && celExpr.constant().booleanValue();
        }

        static CelCompiledMatch create(long sourceId, CelAbstractSyntaxTree condition, Result result) {
            return new AutoValue_CelCompiledRule_CelCompiledMatch(sourceId, condition, result);
        }

        @AutoOneOf(value=Kind.class)
        public static abstract class Result {
            public abstract OutputValue output();

            public abstract CelCompiledRule rule();

            public abstract Kind kind();

            static Result ofOutput(long id, CelAbstractSyntaxTree ast) {
                return AutoOneOf_CelCompiledRule_CelCompiledMatch_Result.output(OutputValue.create(id, ast));
            }

            static Result ofRule(CelCompiledRule value) {
                return AutoOneOf_CelCompiledRule_CelCompiledMatch_Result.rule(value);
            }

            public static enum Kind {
                OUTPUT,
                RULE;

            }
        }

        @AutoValue
        public static abstract class OutputValue {
            public abstract long sourceId();

            public abstract CelAbstractSyntaxTree ast();

            public static OutputValue create(long id, CelAbstractSyntaxTree ast) {
                return new AutoValue_CelCompiledRule_CelCompiledMatch_OutputValue(id, ast);
            }
        }
    }

    @AutoValue
    public static abstract class CelCompiledVariable {
        public abstract String name();

        public abstract CelAbstractSyntaxTree ast();

        public abstract CelVarDecl celVarDecl();

        static CelCompiledVariable create(String name, CelAbstractSyntaxTree ast, CelVarDecl celVarDecl) {
            return new AutoValue_CelCompiledRule_CelCompiledVariable(name, ast, celVarDecl);
        }
    }
}

