/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.formats.ValueString;
import dev.cel.policy.AutoOneOf_CelPolicy_Match_Result;
import dev.cel.policy.AutoValue_CelPolicy;
import dev.cel.policy.AutoValue_CelPolicy_Match;
import dev.cel.policy.AutoValue_CelPolicy_Rule;
import dev.cel.policy.AutoValue_CelPolicy_Variable;
import dev.cel.policy.CelPolicySource;
import dev.cel.policy.RequiredFieldsChecker;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class CelPolicy {
    public abstract ValueString name();

    public abstract Rule rule();

    public abstract CelPolicySource policySource();

    public abstract ImmutableMap<String, Object> metadata();

    public static Builder newBuilder() {
        return new AutoValue_CelPolicy.Builder().setName(ValueString.of(0L, "")).setRule(Rule.newBuilder(0L).build()).setMetadata(ImmutableMap.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract CelPolicySource policySource();

        public abstract Builder setName(ValueString var1);

        public abstract Builder setRule(Rule var1);

        public abstract Builder setPolicySource(CelPolicySource var1);

        abstract ImmutableMap.Builder<String, Object> metadataBuilder();

        public abstract Builder setMetadata(ImmutableMap<String, Object> var1);

        @CanIgnoreReturnValue
        public Builder putMetadata(String key, Object value) {
            this.metadataBuilder().put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putMetadata(Map<String, Object> map) {
            this.metadataBuilder().putAll(map);
            return this;
        }

        public abstract CelPolicy build();
    }

    @AutoValue
    public static abstract class Rule {
        public abstract long id();

        public abstract Optional<ValueString> ruleId();

        public abstract Optional<ValueString> description();

        public abstract ImmutableSet<Variable> variables();

        public abstract ImmutableSet<Match> matches();

        public static Builder newBuilder(long id) {
            return new AutoValue_CelPolicy_Rule.Builder().setId(id).setVariables(ImmutableSet.of()).setMatches(ImmutableSet.of());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setRuleId(ValueString var1);

            public abstract Builder setDescription(ValueString var1);

            abstract ImmutableSet<Variable> variables();

            abstract ImmutableSet.Builder<Variable> variablesBuilder();

            abstract ImmutableSet<Match> matches();

            abstract ImmutableSet.Builder<Match> matchesBuilder();

            abstract Builder setId(long var1);

            @CanIgnoreReturnValue
            public Builder addVariables(Variable ... variables) {
                return this.addVariables(Arrays.asList(variables));
            }

            @CanIgnoreReturnValue
            public Builder addVariables(Iterable<Variable> variables) {
                this.variablesBuilder().addAll((Iterable)Preconditions.checkNotNull(variables));
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addMatches(Match ... matches) {
                return this.addMatches(Arrays.asList(matches));
            }

            @CanIgnoreReturnValue
            public Builder addMatches(Iterable<Match> matches) {
                this.matchesBuilder().addAll((Iterable)Preconditions.checkNotNull(matches));
                return this;
            }

            abstract Builder setVariables(ImmutableSet<Variable> var1);

            abstract Builder setMatches(ImmutableSet<Match> var1);

            public abstract Rule build();
        }
    }

    @AutoValue
    public static abstract class Variable {
        public abstract ValueString name();

        public abstract ValueString expression();

        public abstract Optional<ValueString> description();

        public static Builder newBuilder() {
            return new AutoValue_CelPolicy_Variable.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            abstract Optional<ValueString> name();

            abstract Optional<ValueString> expression();

            abstract Optional<ValueString> description();

            public abstract Builder setName(ValueString var1);

            public abstract Builder setExpression(ValueString var1);

            public abstract Builder setDescription(ValueString var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("name", this::name), RequiredFieldsChecker.RequiredField.of("expression", this::expression));
            }

            public abstract Variable build();
        }
    }

    @AutoValue
    public static abstract class Match {
        public abstract ValueString condition();

        public abstract Result result();

        public abstract long id();

        public abstract Optional<ValueString> explanation();

        public static Builder newBuilder(long id) {
            return new AutoValue_CelPolicy_Match.Builder().setId(id);
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Builder setId(long var1);

            public abstract Builder setCondition(ValueString var1);

            public abstract Builder setResult(Result var1);

            public abstract Builder setExplanation(ValueString var1);

            abstract Optional<Long> id();

            abstract Optional<Result> result();

            abstract Optional<ValueString> explanation();

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("output or a rule", this::result));
            }

            public abstract Match build();
        }

        @AutoOneOf(value=Kind.class)
        public static abstract class Result {
            public abstract ValueString output();

            public abstract Rule rule();

            public abstract Kind kind();

            public static Result ofOutput(ValueString value) {
                return AutoOneOf_CelPolicy_Match_Result.output(value);
            }

            public static Result ofRule(Rule value) {
                return AutoOneOf_CelPolicy_Match_Result.rule(value);
            }

            public static enum Kind {
                OUTPUT,
                RULE;

            }
        }
    }
}

