/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelIssue;
import dev.cel.common.formats.ParserContext;
import dev.cel.common.formats.ValueString;
import dev.cel.common.formats.YamlHelper;
import dev.cel.common.formats.YamlParserContextImpl;
import dev.cel.common.internal.CelCodePointArray;
import dev.cel.policy.CelPolicy;
import dev.cel.policy.CelPolicyParser;
import dev.cel.policy.CelPolicyParserBuilder;
import dev.cel.policy.CelPolicySource;
import dev.cel.policy.CelPolicyValidationException;
import dev.cel.policy.PolicyParserContext;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

final class CelPolicyYamlParser
implements CelPolicyParser {
    private static final ValueString ERROR_VALUE = ValueString.newBuilder().setValue("*error*").build();
    private static final CelPolicy.Match ERROR_MATCH = CelPolicy.Match.newBuilder(0L).setCondition(ERROR_VALUE).setResult(CelPolicy.Match.Result.ofOutput(ERROR_VALUE)).build();
    private static final CelPolicy.Variable ERROR_VARIABLE = CelPolicy.Variable.newBuilder().setExpression(ERROR_VALUE).setName(ERROR_VALUE).build();
    private final CelPolicyParser.TagVisitor<Node> tagVisitor;

    @Override
    public CelPolicy parse(String policySource) throws CelPolicyValidationException {
        return this.parse(policySource, "<input>");
    }

    @Override
    public CelPolicy parse(String policySource, String description) throws CelPolicyValidationException {
        ParserImpl parser = new ParserImpl(this.tagVisitor, policySource, description);
        return parser.parseYaml();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    private CelPolicyYamlParser(CelPolicyParser.TagVisitor<Node> tagVisitor) {
        this.tagVisitor = Preconditions.checkNotNull(tagVisitor);
    }

    private static class ParserImpl
    implements PolicyParserContext<Node> {
        private final CelPolicyParser.TagVisitor<Node> tagVisitor;
        private final CelPolicySource policySource;
        private final ParserContext<Node> ctx;

        private CelPolicy parseYaml() throws CelPolicyValidationException {
            Node node;
            String policySourceString = this.policySource.getContent().toString();
            try {
                Node yamlNode;
                node = yamlNode = YamlHelper.parseYamlSource(policySourceString).orElseThrow(() -> new CelPolicyValidationException(String.format("YAML document empty or malformed: %s", policySourceString)));
            }
            catch (RuntimeException e) {
                throw new CelPolicyValidationException("YAML document is malformed: " + e.getMessage(), e);
            }
            CelPolicy celPolicy = this.parsePolicy((PolicyParserContext<Node>)this, node);
            if (!this.ctx.getIssues().isEmpty()) {
                throw new CelPolicyValidationException(CelIssue.toDisplayString(this.ctx.getIssues(), celPolicy.policySource()));
            }
            return celPolicy;
        }

        @Override
        public CelPolicy parsePolicy(PolicyParserContext<Node> ctx, Node node) {
            CelPolicy.Builder policyBuilder = CelPolicy.newBuilder();
            long id = ctx.collectMetadata(node);
            if (!YamlHelper.assertYamlType(ctx, id, node, YamlHelper.YamlNodeType.MAP)) {
                return policyBuilder.setPolicySource(this.policySource).build();
            }
            MappingNode rootNode = (MappingNode)node;
            block8: for (NodeTuple nodeTuple : rootNode.getValue()) {
                String fieldName;
                Node keyNode = nodeTuple.getKeyNode();
                long keyId = ctx.collectMetadata(keyNode);
                if (!YamlHelper.assertYamlType(ctx, keyId, keyNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
                Node valueNode = nodeTuple.getValueNode();
                switch (fieldName = ((ScalarNode)keyNode).getValue()) {
                    case "name": {
                        policyBuilder.setName(ctx.newValueString(valueNode));
                        continue block8;
                    }
                    case "rule": {
                        policyBuilder.setRule(this.parseRule(ctx, policyBuilder, valueNode));
                        continue block8;
                    }
                }
                this.tagVisitor.visitPolicyTag(ctx, keyId, fieldName, valueNode, policyBuilder);
            }
            return policyBuilder.setPolicySource(this.policySource.toBuilder().setPositionsMap(ctx.getIdToOffsetMap()).build()).build();
        }

        @Override
        public CelPolicy.Rule parseRule(PolicyParserContext<Node> ctx, CelPolicy.Builder policyBuilder, Node node) {
            long valueId = ctx.collectMetadata(node);
            CelPolicy.Rule.Builder ruleBuilder = CelPolicy.Rule.newBuilder(valueId);
            if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.MAP)) {
                return ruleBuilder.build();
            }
            block12: for (NodeTuple nodeTuple : ((MappingNode)node).getValue()) {
                Node key = nodeTuple.getKeyNode();
                long tagId = ctx.collectMetadata(key);
                if (!YamlHelper.assertYamlType(ctx, tagId, key, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
                String fieldName = ((ScalarNode)key).getValue();
                Node value = nodeTuple.getValueNode();
                switch (fieldName) {
                    case "id": {
                        ruleBuilder.setRuleId(ctx.newValueString(value));
                        continue block12;
                    }
                    case "description": {
                        ruleBuilder.setDescription(ctx.newValueString(value));
                        continue block12;
                    }
                    case "variables": {
                        ruleBuilder.addVariables(this.parseVariables(ctx, policyBuilder, value));
                        continue block12;
                    }
                    case "match": {
                        ruleBuilder.addMatches(this.parseMatches(ctx, policyBuilder, value));
                        continue block12;
                    }
                }
                this.tagVisitor.visitRuleTag(ctx, tagId, fieldName, value, policyBuilder, ruleBuilder);
            }
            return ruleBuilder.build();
        }

        private ImmutableSet<CelPolicy.Match> parseMatches(PolicyParserContext<Node> ctx, CelPolicy.Builder policyBuilder, Node node) {
            long valueId = ctx.collectMetadata(node);
            ImmutableSet.Builder matchesBuilder = ImmutableSet.builder();
            if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.LIST)) {
                return matchesBuilder.build();
            }
            SequenceNode matchListNode = (SequenceNode)node;
            for (Node elementNode : matchListNode.getValue()) {
                matchesBuilder.add(this.parseMatch(ctx, policyBuilder, elementNode));
            }
            return matchesBuilder.build();
        }

        @Override
        public CelPolicy.Match parseMatch(PolicyParserContext<Node> ctx, CelPolicy.Builder policyBuilder, Node node) {
            long nodeId = ctx.collectMetadata(node);
            if (!YamlHelper.assertYamlType(ctx, nodeId, node, YamlHelper.YamlNodeType.MAP)) {
                return ERROR_MATCH;
            }
            MappingNode matchNode = (MappingNode)node;
            CelPolicy.Match.Builder matchBuilder = CelPolicy.Match.newBuilder(nodeId).setCondition(ValueString.of(ctx.nextId(), "true"));
            block12: for (NodeTuple nodeTuple : matchNode.getValue()) {
                Node key = nodeTuple.getKeyNode();
                long tagId = ctx.collectMetadata(key);
                if (!YamlHelper.assertYamlType(ctx, tagId, key, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
                String fieldName = ((ScalarNode)key).getValue();
                Node value = nodeTuple.getValueNode();
                switch (fieldName) {
                    case "condition": {
                        matchBuilder.setCondition(ctx.newValueString(value));
                        continue block12;
                    }
                    case "output": {
                        matchBuilder.result().filter(result -> result.kind().equals((Object)CelPolicy.Match.Result.Kind.RULE)).ifPresent(result -> ctx.reportError(tagId, "Only the rule or the output may be set"));
                        matchBuilder.setResult(CelPolicy.Match.Result.ofOutput(ctx.newValueString(value)));
                        continue block12;
                    }
                    case "explanation": {
                        matchBuilder.result().filter(result -> result.kind().equals((Object)CelPolicy.Match.Result.Kind.RULE)).ifPresent(result -> ctx.reportError(tagId, "Explanation can only be set on output match cases, not nested rules"));
                        matchBuilder.setExplanation(ctx.newValueString(value));
                        continue block12;
                    }
                    case "rule": {
                        matchBuilder.result().filter(result -> result.kind().equals((Object)CelPolicy.Match.Result.Kind.OUTPUT)).ifPresent(result -> ctx.reportError(tagId, "Only the rule or the output may be set"));
                        matchBuilder.explanation().ifPresent(result -> ctx.reportError(result.id(), "Explanation can only be set on output match cases, not nested rules"));
                        matchBuilder.setResult(CelPolicy.Match.Result.ofRule(this.parseRule(ctx, policyBuilder, value)));
                        continue block12;
                    }
                }
                this.tagVisitor.visitMatchTag(ctx, tagId, fieldName, value, policyBuilder, matchBuilder);
            }
            if (!YamlHelper.assertRequiredFields(ctx, nodeId, matchBuilder.getMissingRequiredFieldNames())) {
                return ERROR_MATCH;
            }
            return matchBuilder.build();
        }

        private ImmutableSet<CelPolicy.Variable> parseVariables(PolicyParserContext<Node> ctx, CelPolicy.Builder policyBuilder, Node node) {
            long valueId = ctx.collectMetadata(node);
            ImmutableSet.Builder variableBuilder = ImmutableSet.builder();
            if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.LIST)) {
                return variableBuilder.build();
            }
            SequenceNode variableListNode = (SequenceNode)node;
            for (Node elementNode : variableListNode.getValue()) {
                variableBuilder.add(this.parseVariable(ctx, policyBuilder, elementNode));
            }
            return variableBuilder.build();
        }

        @Override
        public CelPolicy.Variable parseVariable(PolicyParserContext<Node> ctx, CelPolicy.Builder policyBuilder, Node node) {
            long id = ctx.collectMetadata(node);
            if (!YamlHelper.assertYamlType(ctx, id, node, YamlHelper.YamlNodeType.MAP)) {
                return ERROR_VARIABLE;
            }
            MappingNode variableMap = (MappingNode)node;
            CelPolicy.Variable.Builder builder = CelPolicy.Variable.newBuilder();
            block10: for (NodeTuple nodeTuple : variableMap.getValue()) {
                String keyName;
                Node keyNode = nodeTuple.getKeyNode();
                long keyId = ctx.collectMetadata(keyNode);
                Node valueNode = nodeTuple.getValueNode();
                switch (keyName = ((ScalarNode)keyNode).getValue()) {
                    case "name": {
                        builder.setName(ctx.newValueString(valueNode));
                        continue block10;
                    }
                    case "expression": {
                        builder.setExpression(ctx.newValueString(valueNode));
                        continue block10;
                    }
                    case "description": {
                        builder.setDescription(ctx.newValueString(valueNode));
                        continue block10;
                    }
                }
                this.tagVisitor.visitVariableTag(ctx, keyId, keyName, valueNode, policyBuilder, builder);
            }
            if (!YamlHelper.assertRequiredFields(ctx, id, builder.getMissingRequiredFieldNames())) {
                return ERROR_VARIABLE;
            }
            return builder.build();
        }

        private ParserImpl(CelPolicyParser.TagVisitor<Node> tagVisitor, String source2, String description) {
            this.tagVisitor = tagVisitor;
            this.policySource = CelPolicySource.newBuilder(CelCodePointArray.fromString(source2)).setDescription(description).build();
            this.ctx = YamlParserContextImpl.newInstance(this.policySource);
        }

        @Override
        public long nextId() {
            return this.ctx.nextId();
        }

        @Override
        public long collectMetadata(Node node) {
            return this.ctx.collectMetadata(node);
        }

        @Override
        public void reportError(long id, String message) {
            this.ctx.reportError(id, message);
        }

        @Override
        public List<CelIssue> getIssues() {
            return this.ctx.getIssues();
        }

        @Override
        public Map<Long, Integer> getIdToOffsetMap() {
            return this.ctx.getIdToOffsetMap();
        }

        @Override
        public ValueString newValueString(Node node) {
            return this.ctx.newValueString(node);
        }
    }

    static final class Builder
    implements CelPolicyParserBuilder<Node> {
        private CelPolicyParser.TagVisitor<Node> tagVisitor = new CelPolicyParser.TagVisitor<Node>(){};

        private Builder() {
        }

        @Override
        public CelPolicyParserBuilder<Node> addTagVisitor(CelPolicyParser.TagVisitor<Node> tagVisitor) {
            this.tagVisitor = tagVisitor;
            return this;
        }

        @Override
        public CelPolicyParser build() {
            return new CelPolicyYamlParser(this.tagVisitor);
        }
    }
}

