/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import dev.cel.policy.AutoValue_RequiredFieldsChecker_RequiredField;
import java.util.Optional;
import java.util.function.Supplier;

interface RequiredFieldsChecker {
    public ImmutableList<RequiredField> requiredFields();

    default public ImmutableList<String> getMissingRequiredFieldNames() {
        return this.requiredFields().stream().filter(entry -> !entry.fieldValue().get().isPresent()).map(RequiredField::displayName).collect(ImmutableList.toImmutableList());
    }

    @AutoValue
    public static abstract class RequiredField {
        abstract String displayName();

        abstract Supplier<Optional<?>> fieldValue();

        static RequiredField of(String displayName, Supplier<Optional<?>> fieldValue) {
            return new AutoValue_RequiredFieldsChecker_RequiredField(displayName, fieldValue);
        }
    }
}

