/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelMutableAst;
import dev.cel.common.CelValidationException;
import dev.cel.common.formats.ValueString;
import dev.cel.extensions.CelOptionalLibrary;
import dev.cel.optimizer.AstMutator;
import dev.cel.optimizer.CelAstOptimizer;
import dev.cel.parser.Operator;
import dev.cel.policy.AutoValue_RuleComposer_RuleOptimizationResult;
import dev.cel.policy.CelCompiledRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

final class RuleComposer
implements CelAstOptimizer {
    private final CelCompiledRule compiledRule;
    private final String variablePrefix;
    private final AstMutator astMutator;

    @Override
    public CelAstOptimizer.OptimizationResult optimize(CelAbstractSyntaxTree ast, Cel cel) {
        RuleOptimizationResult result = this.optimizeRule(cel, this.compiledRule);
        return CelAstOptimizer.OptimizationResult.create(result.ast().toParsedAst());
    }

    private RuleOptimizationResult optimizeRule(Cel cel, CelCompiledRule compiledRule) {
        cel = cel.toCelBuilder().addVarDeclarations(compiledRule.variables().stream().map(CelCompiledRule.CelCompiledVariable::celVarDecl).collect(ImmutableList.toImmutableList())).build();
        CelMutableAst matchAst = this.astMutator.newGlobalCall(CelOptionalLibrary.Function.OPTIONAL_NONE.getFunction(), new CelMutableAst[0]);
        boolean isOptionalResult = true;
        long lastOutputId = 0L;
        for (CelCompiledRule.CelCompiledMatch match : Lists.reverse(compiledRule.matches())) {
            CelAbstractSyntaxTree conditionAst = match.condition();
            boolean isTriviallyTrue = match.isConditionTriviallyTrue();
            switch (match.result().kind()) {
                case OUTPUT: {
                    CelCompiledRule.CelCompiledMatch.OutputValue matchOutput = match.result().output();
                    CelMutableAst outAst = CelMutableAst.fromCelAst(matchOutput.ast());
                    if (isTriviallyTrue) {
                        matchAst = outAst;
                        isOptionalResult = false;
                        lastOutputId = matchOutput.sourceId();
                        break;
                    }
                    if (isOptionalResult) {
                        outAst = this.astMutator.newGlobalCall(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction(), outAst);
                    }
                    matchAst = this.astMutator.newGlobalCall(Operator.CONDITIONAL.getFunction(), CelMutableAst.fromCelAst(conditionAst), outAst, matchAst);
                    this.assertComposedAstIsValid(cel, matchAst, "conflicting output types found.", matchOutput.sourceId(), lastOutputId);
                    lastOutputId = matchOutput.sourceId();
                    break;
                }
                case RULE: {
                    CelCompiledRule matchNestedRule = match.result().rule();
                    RuleOptimizationResult nestedRule = this.optimizeRule(cel, matchNestedRule);
                    boolean nestedHasOptional = matchNestedRule.hasOptionalOutput();
                    CelMutableAst nestedRuleAst = nestedRule.ast();
                    if (isOptionalResult && !nestedHasOptional) {
                        nestedRuleAst = this.astMutator.newGlobalCall(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction(), nestedRuleAst);
                    }
                    if (!isOptionalResult && nestedHasOptional) {
                        matchAst = this.astMutator.newGlobalCall(CelOptionalLibrary.Function.OPTIONAL_OF.getFunction(), matchAst);
                        isOptionalResult = true;
                    }
                    matchAst = isOptionalResult && isTriviallyTrue ? this.astMutator.newMemberCall(nestedRuleAst, CelOptionalLibrary.Function.OR.getFunction(), matchAst) : this.astMutator.newGlobalCall(Operator.CONDITIONAL.getFunction(), CelMutableAst.fromCelAst(conditionAst), nestedRuleAst, matchAst);
                    this.assertComposedAstIsValid(cel, matchAst, String.format("failed composing the subrule '%s' due to conflicting output types.", matchNestedRule.ruleId().map(ValueString::value).orElse("")), lastOutputId);
                }
            }
        }
        CelMutableAst result = matchAst;
        for (CelCompiledRule.CelCompiledVariable variable : Lists.reverse(compiledRule.variables())) {
            result = this.astMutator.replaceSubtreeWithNewBindMacro(result, this.variablePrefix + variable.name(), CelMutableAst.fromCelAst(variable.ast()), result.expr(), result.expr().id(), true);
        }
        result = this.astMutator.renumberIdsConsecutively(result);
        return RuleOptimizationResult.create(result, isOptionalResult);
    }

    static RuleComposer newInstance(CelCompiledRule compiledRule, String variablePrefix, int iterationLimit) {
        return new RuleComposer(compiledRule, variablePrefix, iterationLimit);
    }

    private void assertComposedAstIsValid(Cel cel, CelMutableAst composedAst, String failureMessage, Long ... ids) {
        this.assertComposedAstIsValid(cel, composedAst, failureMessage, Arrays.asList(ids));
    }

    private void assertComposedAstIsValid(Cel cel, CelMutableAst composedAst, String failureMessage, List<Long> ids) {
        try {
            cel.check(composedAst.toParsedAst()).getAst();
        }
        catch (CelValidationException e) {
            ids = ids.stream().filter(id -> id > 0L).collect(Collectors.toCollection(ArrayList::new));
            throw new RuleCompositionException(failureMessage, e, ids);
        }
    }

    private RuleComposer(CelCompiledRule compiledRule, String variablePrefix, int iterationLimit) {
        this.compiledRule = Preconditions.checkNotNull(compiledRule);
        this.variablePrefix = variablePrefix;
        this.astMutator = AstMutator.newInstance(iterationLimit);
    }

    @AutoValue
    static abstract class RuleOptimizationResult {
        RuleOptimizationResult() {
        }

        abstract CelMutableAst ast();

        abstract boolean isOptionalResult();

        static RuleOptimizationResult create(CelMutableAst ast, boolean isOptionalResult) {
            return new AutoValue_RuleComposer_RuleOptimizationResult(ast, isOptionalResult);
        }
    }

    static final class RuleCompositionException
    extends RuntimeException {
        final String failureReason;
        final List<Long> errorIds;
        final CelValidationException compileException;

        private RuleCompositionException(String failureReason, CelValidationException e, List<Long> errorIds) {
            super(e);
            this.failureReason = failureReason;
            this.errorIds = errorIds;
            this.compileException = e;
        }
    }
}

