/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.SafeStringFormatter;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.Metadata;
import org.jspecify.annotations.Nullable;

@Internal
public final class CelEvaluationExceptionBuilder {
    private String message = "";
    private Throwable cause;
    private CelErrorCode errorCode;
    private String errorLocation;

    @CanIgnoreReturnValue
    public CelEvaluationExceptionBuilder setCause(@Nullable Throwable cause) {
        this.cause = cause;
        return this;
    }

    @CanIgnoreReturnValue
    public CelEvaluationExceptionBuilder setErrorCode(CelErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @CanIgnoreReturnValue
    public CelEvaluationExceptionBuilder setMetadata(Metadata metadata, long exprId) {
        if (metadata.hasPosition(exprId)) {
            this.errorLocation = SafeStringFormatter.format(" at %s:%d", metadata.getLocation(), metadata.getPosition(exprId));
        }
        return this;
    }

    @Internal
    public CelEvaluationException build() {
        return new CelEvaluationException(SafeStringFormatter.format("evaluation error%s: %s", this.errorLocation, this.message), this.cause, this.errorCode);
    }

    @Internal
    public static CelEvaluationExceptionBuilder newBuilder(String message, Object ... args) {
        return new CelEvaluationExceptionBuilder(SafeStringFormatter.format(message, args));
    }

    @Internal
    public static CelEvaluationExceptionBuilder newBuilder(CelRuntimeException celRuntimeException) {
        Throwable cause = celRuntimeException.getCause();
        return new CelEvaluationExceptionBuilder(cause.getMessage()).setCause(cause).setErrorCode(celRuntimeException.getErrorCode());
    }

    private CelEvaluationExceptionBuilder(String message) {
        this.message = message == null ? "" : message;
        this.errorCode = CelErrorCode.INTERNAL_ERROR;
        this.errorLocation = "";
    }
}

