/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.CelFunctionOverload;
import dev.cel.runtime.FunctionBindingImpl;

@Immutable
@Internal
public interface CelFunctionBinding {
    public String getOverloadId();

    public ImmutableList<Class<?>> getArgTypes();

    public CelFunctionOverload getDefinition();

    public static <T> CelFunctionBinding from(String overloadId, Class<T> arg, CelFunctionOverload.Unary<T> impl) {
        return CelFunctionBinding.from(overloadId, ImmutableList.of(arg), args -> impl.apply(args[0]));
    }

    public static <T1, T2> CelFunctionBinding from(String overloadId, Class<T1> arg1, Class<T2> arg2, CelFunctionOverload.Binary<T1, T2> impl) {
        return CelFunctionBinding.from(overloadId, ImmutableList.of(arg1, arg2), args -> impl.apply(args[0], args[1]));
    }

    public static CelFunctionBinding from(String overloadId, Iterable<Class<?>> argTypes, CelFunctionOverload impl) {
        return new FunctionBindingImpl(overloadId, ImmutableList.copyOf(argTypes), impl);
    }
}

