/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelFunctionResolver;
import dev.cel.runtime.CelResolvedOverload;
import dev.cel.runtime.DefaultDispatcher;
import dev.cel.runtime.ResolvedOverload;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@Immutable
public final class CelLateFunctionBindings
implements CelFunctionResolver {
    private final ImmutableMap<String, ResolvedOverload> functions;

    private CelLateFunctionBindings(ImmutableMap<String, ResolvedOverload> functions) {
        this.functions = functions;
    }

    @Override
    public Optional<ResolvedOverload> findOverload(String functionName, List<String> overloadIds, Object[] args) throws CelEvaluationException {
        return DefaultDispatcher.findOverload(functionName, overloadIds, this.functions, args);
    }

    public static CelLateFunctionBindings from(CelFunctionBinding ... functions) {
        return CelLateFunctionBindings.from(Arrays.asList(functions));
    }

    public static CelLateFunctionBindings from(List<CelFunctionBinding> functions) {
        return new CelLateFunctionBindings(functions.stream().collect(ImmutableMap.toImmutableMap(CelFunctionBinding::getOverloadId, CelLateFunctionBindings::createResolvedOverload)));
    }

    private static ResolvedOverload createResolvedOverload(CelFunctionBinding binding) {
        return CelResolvedOverload.of(binding.getOverloadId(), binding.getArgTypes(), args -> binding.getDefinition().apply(args));
    }
}

