/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.AddOperator;
import dev.cel.runtime.standard.BoolFunction;
import dev.cel.runtime.standard.BytesFunction;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.ContainsFunction;
import dev.cel.runtime.standard.DivideOperator;
import dev.cel.runtime.standard.DoubleFunction;
import dev.cel.runtime.standard.DurationFunction;
import dev.cel.runtime.standard.DynFunction;
import dev.cel.runtime.standard.EndsWithFunction;
import dev.cel.runtime.standard.EqualsOperator;
import dev.cel.runtime.standard.GetDateFunction;
import dev.cel.runtime.standard.GetDayOfMonthFunction;
import dev.cel.runtime.standard.GetDayOfWeekFunction;
import dev.cel.runtime.standard.GetDayOfYearFunction;
import dev.cel.runtime.standard.GetFullYearFunction;
import dev.cel.runtime.standard.GetHoursFunction;
import dev.cel.runtime.standard.GetMillisecondsFunction;
import dev.cel.runtime.standard.GetMinutesFunction;
import dev.cel.runtime.standard.GetMonthFunction;
import dev.cel.runtime.standard.GetSecondsFunction;
import dev.cel.runtime.standard.GreaterEqualsOperator;
import dev.cel.runtime.standard.GreaterOperator;
import dev.cel.runtime.standard.InOperator;
import dev.cel.runtime.standard.IndexOperator;
import dev.cel.runtime.standard.IntFunction;
import dev.cel.runtime.standard.LessEqualsOperator;
import dev.cel.runtime.standard.LessOperator;
import dev.cel.runtime.standard.LogicalNotOperator;
import dev.cel.runtime.standard.MatchesFunction;
import dev.cel.runtime.standard.ModuloOperator;
import dev.cel.runtime.standard.MultiplyOperator;
import dev.cel.runtime.standard.NegateOperator;
import dev.cel.runtime.standard.NotEqualsOperator;
import dev.cel.runtime.standard.SizeFunction;
import dev.cel.runtime.standard.StartsWithFunction;
import dev.cel.runtime.standard.StringFunction;
import dev.cel.runtime.standard.SubtractOperator;
import dev.cel.runtime.standard.TimestampFunction;
import dev.cel.runtime.standard.UintFunction;

@Immutable
public final class CelStandardFunctions {
    private final ImmutableSet<StandardOverload> standardOverloads;
    public static final ImmutableSet<CelStandardFunction> ALL_STANDARD_FUNCTIONS = ImmutableSet.of(AddOperator.create(), BoolFunction.create(), BytesFunction.create(), ContainsFunction.create(), DivideOperator.create(), DoubleFunction.create(), new CelStandardFunction[]{DurationFunction.create(), DynFunction.create(), EndsWithFunction.create(), EqualsOperator.create(), GetDateFunction.create(), GetDayOfMonthFunction.create(), GetDayOfWeekFunction.create(), GetDayOfYearFunction.create(), GetFullYearFunction.create(), GetHoursFunction.create(), GetMillisecondsFunction.create(), GetMinutesFunction.create(), GetMonthFunction.create(), GetSecondsFunction.create(), GreaterEqualsOperator.create(), GreaterOperator.create(), IndexOperator.create(), InOperator.create(), IntFunction.create(), LessEqualsOperator.create(), LessOperator.create(), LogicalNotOperator.create(), MatchesFunction.create(), ModuloOperator.create(), MultiplyOperator.create(), NegateOperator.create(), NotEqualsOperator.create(), SizeFunction.create(), StartsWithFunction.create(), StringFunction.create(), SubtractOperator.create(), TimestampFunction.create(), UintFunction.create()});

    @VisibleForTesting
    ImmutableSet<StandardOverload> getOverloads() {
        return this.standardOverloads;
    }

    @Internal
    public ImmutableSet<CelFunctionBinding> newFunctionBindings(RuntimeEquality runtimeEquality, CelOptions celOptions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (StandardOverload overload : this.standardOverloads) {
            builder.add(overload.newFunctionBinding(celOptions, runtimeEquality));
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private CelStandardFunctions(ImmutableSet<StandardOverload> standardOverloads) {
        this.standardOverloads = standardOverloads;
    }

    @Immutable
    public static interface StandardOverload {
        public CelFunctionBinding newFunctionBinding(CelOptions var1, RuntimeEquality var2);
    }

    public static final class Builder {
        private ImmutableSet<StandardFunction> includeFunctions = ImmutableSet.of();
        private ImmutableSet<StandardFunction> excludeFunctions = ImmutableSet.of();
        private FunctionFilter functionFilter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder excludeFunctions(StandardFunction ... functions) {
            return this.excludeFunctions(ImmutableSet.copyOf(functions));
        }

        @CanIgnoreReturnValue
        public Builder excludeFunctions(Iterable<StandardFunction> functions) {
            this.excludeFunctions = Preconditions.checkNotNull(ImmutableSet.copyOf(functions));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder includeFunctions(StandardFunction ... functions) {
            return this.includeFunctions(ImmutableSet.copyOf(functions));
        }

        @CanIgnoreReturnValue
        public Builder includeFunctions(Iterable<StandardFunction> functions) {
            this.includeFunctions = Preconditions.checkNotNull(ImmutableSet.copyOf(functions));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder filterFunctions(FunctionFilter functionFilter) {
            this.functionFilter = functionFilter;
            return this;
        }

        private static void assertOneSettingIsSet(boolean a, boolean b, boolean c, String errorMessage) {
            int count = 0;
            if (a) {
                ++count;
            }
            if (b) {
                ++count;
            }
            if (c) {
                ++count;
            }
            if (count > 1) {
                throw new IllegalArgumentException(errorMessage);
            }
        }

        public CelStandardFunctions build() {
            boolean hasIncludeFunctions = !this.includeFunctions.isEmpty();
            boolean hasExcludeFunctions = !this.excludeFunctions.isEmpty();
            boolean hasFilterFunction = this.functionFilter != null;
            Builder.assertOneSettingIsSet(hasIncludeFunctions, hasExcludeFunctions, hasFilterFunction, "You may only populate one of the following builder methods: includeFunctions, excludeFunctions or filterFunctions");
            ImmutableSet.Builder standardOverloadBuilder = ImmutableSet.builder();
            for (StandardFunction standardFunction : StandardFunction.values()) {
                if (hasIncludeFunctions) {
                    if (!this.includeFunctions.contains((Object)standardFunction)) continue;
                    standardOverloadBuilder.addAll((Iterable)standardFunction.standardOverloads);
                    continue;
                }
                if (hasExcludeFunctions) {
                    if (this.excludeFunctions.contains((Object)standardFunction)) continue;
                    standardOverloadBuilder.addAll((Iterable)standardFunction.standardOverloads);
                    continue;
                }
                if (hasFilterFunction) {
                    ImmutableSet.Builder filteredOverloadsBuilder = ImmutableSet.builder();
                    for (StandardOverload standardOverload : standardFunction.standardOverloads) {
                        boolean includeOverload = this.functionFilter.include(standardFunction, standardOverload);
                        if (!includeOverload) continue;
                        standardOverloadBuilder.add(standardOverload);
                    }
                    ImmutableCollection filteredOverloads = filteredOverloadsBuilder.build();
                    if (filteredOverloads.isEmpty()) continue;
                    standardOverloadBuilder.addAll((Iterable)filteredOverloads);
                    continue;
                }
                standardOverloadBuilder.addAll((Iterable)standardFunction.standardOverloads);
            }
            return new CelStandardFunctions((ImmutableSet)standardOverloadBuilder.build());
        }

        @FunctionalInterface
        public static interface FunctionFilter {
            public boolean include(StandardFunction var1, StandardOverload var2);
        }
    }

    @FunctionalInterface
    @Immutable
    private static interface FunctionBindingCreator {
        public CelFunctionBinding create(CelOptions var1, RuntimeEquality var2);
    }

    public static enum StandardFunction {
        LOGICAL_NOT(Overload.BooleanOperator.LOGICAL_NOT),
        IN(Overload.InternalOperator.IN_LIST, Overload.InternalOperator.IN_MAP),
        EQUALS(Overload.Relation.EQUALS),
        NOT_EQUALS(Overload.Relation.NOT_EQUALS),
        BOOL(Overload.Conversions.BOOL_TO_BOOL, Overload.Conversions.STRING_TO_BOOL),
        ADD(Overload.Arithmetic.ADD_INT64, Overload.Arithmetic.ADD_UINT64, Overload.Arithmetic.ADD_DOUBLE, Overload.Arithmetic.ADD_STRING, Overload.Arithmetic.ADD_BYTES, Overload.Arithmetic.ADD_LIST, Overload.Arithmetic.ADD_TIMESTAMP_DURATION, Overload.Arithmetic.ADD_DURATION_TIMESTAMP, Overload.Arithmetic.ADD_DURATION_DURATION),
        SUBTRACT(Overload.Arithmetic.SUBTRACT_INT64, Overload.Arithmetic.SUBTRACT_TIMESTAMP_TIMESTAMP, Overload.Arithmetic.SUBTRACT_TIMESTAMP_DURATION, Overload.Arithmetic.SUBTRACT_UINT64, Overload.Arithmetic.SUBTRACT_DOUBLE, Overload.Arithmetic.SUBTRACT_DURATION_DURATION),
        MULTIPLY(Overload.Arithmetic.MULTIPLY_INT64, Overload.Arithmetic.MULTIPLY_DOUBLE, Overload.Arithmetic.MULTIPLY_UINT64),
        DIVIDE(Overload.Arithmetic.DIVIDE_DOUBLE, Overload.Arithmetic.DIVIDE_INT64, Overload.Arithmetic.DIVIDE_UINT64),
        MODULO(Overload.Arithmetic.MODULO_INT64, Overload.Arithmetic.MODULO_UINT64),
        NEGATE(Overload.Arithmetic.NEGATE_INT64, Overload.Arithmetic.NEGATE_DOUBLE),
        INDEX(Overload.Index.INDEX_LIST, Overload.Index.INDEX_MAP),
        SIZE(Overload.Size.SIZE_STRING, Overload.Size.SIZE_BYTES, Overload.Size.SIZE_LIST, Overload.Size.SIZE_MAP, Overload.Size.STRING_SIZE, Overload.Size.BYTES_SIZE, Overload.Size.LIST_SIZE, Overload.Size.MAP_SIZE),
        INT(Overload.Conversions.INT64_TO_INT64, Overload.Conversions.UINT64_TO_INT64, Overload.Conversions.DOUBLE_TO_INT64, Overload.Conversions.STRING_TO_INT64, Overload.Conversions.TIMESTAMP_TO_INT64),
        UINT(Overload.Conversions.UINT64_TO_UINT64, Overload.Conversions.INT64_TO_UINT64, Overload.Conversions.DOUBLE_TO_UINT64, Overload.Conversions.STRING_TO_UINT64),
        DOUBLE(Overload.Conversions.DOUBLE_TO_DOUBLE, Overload.Conversions.INT64_TO_DOUBLE, Overload.Conversions.STRING_TO_DOUBLE, Overload.Conversions.UINT64_TO_DOUBLE),
        STRING(Overload.Conversions.STRING_TO_STRING, Overload.Conversions.INT64_TO_STRING, Overload.Conversions.DOUBLE_TO_STRING, Overload.Conversions.BOOL_TO_STRING, Overload.Conversions.BYTES_TO_STRING, Overload.Conversions.TIMESTAMP_TO_STRING, Overload.Conversions.DURATION_TO_STRING, Overload.Conversions.UINT64_TO_STRING),
        BYTES(Overload.Conversions.BYTES_TO_BYTES, Overload.Conversions.STRING_TO_BYTES),
        DURATION(Overload.Conversions.DURATION_TO_DURATION, Overload.Conversions.STRING_TO_DURATION),
        TIMESTAMP(Overload.Conversions.STRING_TO_TIMESTAMP, Overload.Conversions.TIMESTAMP_TO_TIMESTAMP, Overload.Conversions.INT64_TO_TIMESTAMP),
        DYN(Overload.Conversions.TO_DYN),
        MATCHES(Overload.StringMatchers.MATCHES, Overload.StringMatchers.MATCHES_STRING),
        CONTAINS(Overload.StringMatchers.CONTAINS_STRING),
        ENDS_WITH(Overload.StringMatchers.ENDS_WITH_STRING),
        STARTS_WITH(Overload.StringMatchers.STARTS_WITH_STRING),
        GET_FULL_YEAR(Overload.DateTime.TIMESTAMP_TO_YEAR, Overload.DateTime.TIMESTAMP_TO_YEAR_WITH_TZ),
        GET_MONTH(Overload.DateTime.TIMESTAMP_TO_MONTH, Overload.DateTime.TIMESTAMP_TO_MONTH_WITH_TZ),
        GET_DAY_OF_YEAR(Overload.DateTime.TIMESTAMP_TO_DAY_OF_YEAR, Overload.DateTime.TIMESTAMP_TO_DAY_OF_YEAR_WITH_TZ),
        GET_DAY_OF_MONTH(Overload.DateTime.TIMESTAMP_TO_DAY_OF_MONTH, Overload.DateTime.TIMESTAMP_TO_DAY_OF_MONTH_WITH_TZ),
        GET_DATE(Overload.DateTime.TIMESTAMP_TO_DAY_OF_MONTH_1_BASED, Overload.DateTime.TIMESTAMP_TO_DAY_OF_MONTH_1_BASED_WITH_TZ),
        GET_DAY_OF_WEEK(Overload.DateTime.TIMESTAMP_TO_DAY_OF_WEEK, Overload.DateTime.TIMESTAMP_TO_DAY_OF_WEEK_WITH_TZ),
        GET_HOURS(Overload.DateTime.TIMESTAMP_TO_HOURS, Overload.DateTime.TIMESTAMP_TO_HOURS_WITH_TZ, Overload.DateTime.DURATION_TO_HOURS),
        GET_MINUTES(Overload.DateTime.TIMESTAMP_TO_MINUTES, Overload.DateTime.TIMESTAMP_TO_MINUTES_WITH_TZ, Overload.DateTime.DURATION_TO_MINUTES),
        GET_SECONDS(Overload.DateTime.TIMESTAMP_TO_SECONDS, Overload.DateTime.TIMESTAMP_TO_SECONDS_WITH_TZ, Overload.DateTime.DURATION_TO_SECONDS),
        GET_MILLISECONDS(Overload.DateTime.TIMESTAMP_TO_MILLISECONDS, Overload.DateTime.TIMESTAMP_TO_MILLISECONDS_WITH_TZ, Overload.DateTime.DURATION_TO_MILLISECONDS),
        LESS(Overload.Comparison.LESS_BOOL, Overload.Comparison.LESS_INT64, Overload.Comparison.LESS_UINT64, Overload.Comparison.LESS_DOUBLE, Overload.Comparison.LESS_STRING, Overload.Comparison.LESS_BYTES, Overload.Comparison.LESS_TIMESTAMP, Overload.Comparison.LESS_DURATION, Overload.Comparison.LESS_INT64_UINT64, Overload.Comparison.LESS_UINT64_INT64, Overload.Comparison.LESS_INT64_DOUBLE, Overload.Comparison.LESS_DOUBLE_INT64, Overload.Comparison.LESS_UINT64_DOUBLE, Overload.Comparison.LESS_DOUBLE_UINT64),
        LESS_EQUALS(Overload.Comparison.LESS_EQUALS_BOOL, Overload.Comparison.LESS_EQUALS_INT64, Overload.Comparison.LESS_EQUALS_UINT64, Overload.Comparison.LESS_EQUALS_DOUBLE, Overload.Comparison.LESS_EQUALS_STRING, Overload.Comparison.LESS_EQUALS_BYTES, Overload.Comparison.LESS_EQUALS_TIMESTAMP, Overload.Comparison.LESS_EQUALS_DURATION, Overload.Comparison.LESS_EQUALS_INT64_UINT64, Overload.Comparison.LESS_EQUALS_UINT64_INT64, Overload.Comparison.LESS_EQUALS_INT64_DOUBLE, Overload.Comparison.LESS_EQUALS_DOUBLE_INT64, Overload.Comparison.LESS_EQUALS_UINT64_DOUBLE, Overload.Comparison.LESS_EQUALS_DOUBLE_UINT64),
        GREATER(Overload.Comparison.GREATER_BOOL, Overload.Comparison.GREATER_INT64, Overload.Comparison.GREATER_UINT64, Overload.Comparison.GREATER_DOUBLE, Overload.Comparison.GREATER_STRING, Overload.Comparison.GREATER_BYTES, Overload.Comparison.GREATER_TIMESTAMP, Overload.Comparison.GREATER_DURATION, Overload.Comparison.GREATER_INT64_UINT64, Overload.Comparison.GREATER_UINT64_INT64, Overload.Comparison.GREATER_INT64_DOUBLE, Overload.Comparison.GREATER_DOUBLE_INT64, Overload.Comparison.GREATER_UINT64_DOUBLE, Overload.Comparison.GREATER_DOUBLE_UINT64),
        GREATER_EQUALS(Overload.Comparison.GREATER_EQUALS_BOOL, Overload.Comparison.GREATER_EQUALS_BYTES, Overload.Comparison.GREATER_EQUALS_DOUBLE, Overload.Comparison.GREATER_EQUALS_DURATION, Overload.Comparison.GREATER_EQUALS_INT64, Overload.Comparison.GREATER_EQUALS_STRING, Overload.Comparison.GREATER_EQUALS_TIMESTAMP, Overload.Comparison.GREATER_EQUALS_UINT64, Overload.Comparison.GREATER_EQUALS_INT64_UINT64, Overload.Comparison.GREATER_EQUALS_UINT64_INT64, Overload.Comparison.GREATER_EQUALS_INT64_DOUBLE, Overload.Comparison.GREATER_EQUALS_DOUBLE_INT64, Overload.Comparison.GREATER_EQUALS_UINT64_DOUBLE, Overload.Comparison.GREATER_EQUALS_DOUBLE_UINT64);

        private final ImmutableSet<StandardOverload> standardOverloads;

        private StandardFunction(StandardOverload ... overloads) {
            this.standardOverloads = ImmutableSet.copyOf(overloads);
        }

        @VisibleForTesting
        ImmutableSet<StandardOverload> getOverloads() {
            return this.standardOverloads;
        }

        public static final class Overload {
            private Overload() {
            }

            public static enum Comparison implements StandardOverload
            {
                LESS_BOOL(LessOperator.LessOverload.LESS_BOOL::newFunctionBinding, false),
                LESS_INT64(LessOperator.LessOverload.LESS_INT64::newFunctionBinding, false),
                LESS_UINT64(LessOperator.LessOverload.LESS_UINT64::newFunctionBinding, false),
                LESS_BYTES(LessOperator.LessOverload.LESS_BYTES::newFunctionBinding, false),
                LESS_DOUBLE(LessOperator.LessOverload.LESS_DOUBLE::newFunctionBinding, false),
                LESS_DOUBLE_UINT64(LessOperator.LessOverload.LESS_DOUBLE_UINT64::newFunctionBinding, true),
                LESS_INT64_UINT64(LessOperator.LessOverload.LESS_INT64_UINT64::newFunctionBinding, true),
                LESS_UINT64_INT64(LessOperator.LessOverload.LESS_UINT64_INT64::newFunctionBinding, true),
                LESS_INT64_DOUBLE(LessOperator.LessOverload.LESS_INT64_DOUBLE::newFunctionBinding, true),
                LESS_DOUBLE_INT64(LessOperator.LessOverload.LESS_DOUBLE_INT64::newFunctionBinding, true),
                LESS_UINT64_DOUBLE(LessOperator.LessOverload.LESS_UINT64_DOUBLE::newFunctionBinding, true),
                LESS_DURATION(LessOperator.LessOverload.LESS_DURATION::newFunctionBinding, false),
                LESS_STRING(LessOperator.LessOverload.LESS_STRING::newFunctionBinding, false),
                LESS_TIMESTAMP(LessOperator.LessOverload.LESS_TIMESTAMP::newFunctionBinding, false),
                LESS_EQUALS_BOOL(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_BOOL::newFunctionBinding, false),
                LESS_EQUALS_BYTES(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_BYTES::newFunctionBinding, false),
                LESS_EQUALS_DOUBLE(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_DOUBLE::newFunctionBinding, false),
                LESS_EQUALS_DURATION(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_DURATION::newFunctionBinding, false),
                LESS_EQUALS_INT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_INT64::newFunctionBinding, false),
                LESS_EQUALS_STRING(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_STRING::newFunctionBinding, false),
                LESS_EQUALS_TIMESTAMP(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_TIMESTAMP::newFunctionBinding, false),
                LESS_EQUALS_UINT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_UINT64::newFunctionBinding, false),
                LESS_EQUALS_INT64_UINT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_INT64_UINT64::newFunctionBinding, true),
                LESS_EQUALS_UINT64_INT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_UINT64_INT64::newFunctionBinding, true),
                LESS_EQUALS_INT64_DOUBLE(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_INT64_DOUBLE::newFunctionBinding, true),
                LESS_EQUALS_DOUBLE_INT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_DOUBLE_INT64::newFunctionBinding, true),
                LESS_EQUALS_UINT64_DOUBLE(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_UINT64_DOUBLE::newFunctionBinding, true),
                LESS_EQUALS_DOUBLE_UINT64(LessEqualsOperator.LessEqualsOverload.LESS_EQUALS_DOUBLE_UINT64::newFunctionBinding, true),
                GREATER_BOOL(GreaterOperator.GreaterOverload.GREATER_BOOL::newFunctionBinding, false),
                GREATER_BYTES(GreaterOperator.GreaterOverload.GREATER_BYTES::newFunctionBinding, false),
                GREATER_DOUBLE(GreaterOperator.GreaterOverload.GREATER_DOUBLE::newFunctionBinding, false),
                GREATER_DURATION(GreaterOperator.GreaterOverload.GREATER_DURATION::newFunctionBinding, false),
                GREATER_INT64(GreaterOperator.GreaterOverload.GREATER_INT64::newFunctionBinding, false),
                GREATER_STRING(GreaterOperator.GreaterOverload.GREATER_STRING::newFunctionBinding, false),
                GREATER_TIMESTAMP(GreaterOperator.GreaterOverload.GREATER_TIMESTAMP::newFunctionBinding, false),
                GREATER_UINT64(GreaterOperator.GreaterOverload.GREATER_UINT64::newFunctionBinding, false),
                GREATER_INT64_UINT64(GreaterOperator.GreaterOverload.GREATER_INT64_UINT64::newFunctionBinding, true),
                GREATER_UINT64_INT64(GreaterOperator.GreaterOverload.GREATER_UINT64_INT64::newFunctionBinding, true),
                GREATER_INT64_DOUBLE(GreaterOperator.GreaterOverload.GREATER_INT64_DOUBLE::newFunctionBinding, true),
                GREATER_DOUBLE_INT64(GreaterOperator.GreaterOverload.GREATER_DOUBLE_INT64::newFunctionBinding, true),
                GREATER_UINT64_DOUBLE(GreaterOperator.GreaterOverload.GREATER_UINT64_DOUBLE::newFunctionBinding, true),
                GREATER_DOUBLE_UINT64(GreaterOperator.GreaterOverload.GREATER_DOUBLE_UINT64::newFunctionBinding, true),
                GREATER_EQUALS_BOOL(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_BOOL::newFunctionBinding, false),
                GREATER_EQUALS_BYTES(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_BYTES::newFunctionBinding, false),
                GREATER_EQUALS_DOUBLE(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_DOUBLE::newFunctionBinding, false),
                GREATER_EQUALS_DURATION(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_DURATION::newFunctionBinding, false),
                GREATER_EQUALS_INT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_INT64::newFunctionBinding, false),
                GREATER_EQUALS_STRING(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_STRING::newFunctionBinding, false),
                GREATER_EQUALS_TIMESTAMP(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_TIMESTAMP::newFunctionBinding, false),
                GREATER_EQUALS_UINT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_UINT64::newFunctionBinding, false),
                GREATER_EQUALS_INT64_UINT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_INT64_UINT64::newFunctionBinding, true),
                GREATER_EQUALS_UINT64_INT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_UINT64_INT64::newFunctionBinding, true),
                GREATER_EQUALS_INT64_DOUBLE(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_INT64_DOUBLE::newFunctionBinding, true),
                GREATER_EQUALS_DOUBLE_INT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_DOUBLE_INT64::newFunctionBinding, true),
                GREATER_EQUALS_UINT64_DOUBLE(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_UINT64_DOUBLE::newFunctionBinding, true),
                GREATER_EQUALS_DOUBLE_UINT64(GreaterEqualsOperator.GreaterEqualsOverload.GREATER_EQUALS_DOUBLE_UINT64::newFunctionBinding, true);

                private final FunctionBindingCreator bindingCreator;
                private final boolean isHeterogeneousComparison;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Comparison(FunctionBindingCreator bindingCreator, boolean isHeterogeneousComparison) {
                    this.bindingCreator = bindingCreator;
                    this.isHeterogeneousComparison = isHeterogeneousComparison;
                }

                public boolean isHeterogeneousComparison() {
                    return this.isHeterogeneousComparison;
                }
            }

            public static enum DateTime implements StandardOverload
            {
                TIMESTAMP_TO_YEAR(GetFullYearFunction.GetFullYearOverload.TIMESTAMP_TO_YEAR::newFunctionBinding),
                TIMESTAMP_TO_YEAR_WITH_TZ(GetFullYearFunction.GetFullYearOverload.TIMESTAMP_TO_YEAR_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_MONTH(GetMonthFunction.GetMonthOverload.TIMESTAMP_TO_MONTH::newFunctionBinding),
                TIMESTAMP_TO_MONTH_WITH_TZ(GetMonthFunction.GetMonthOverload.TIMESTAMP_TO_MONTH_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_YEAR(GetDayOfYearFunction.GetDayOfYearOverload.TIMESTAMP_TO_DAY_OF_YEAR::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_YEAR_WITH_TZ(GetDayOfYearFunction.GetDayOfYearOverload.TIMESTAMP_TO_DAY_OF_YEAR_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_MONTH(GetDayOfMonthFunction.GetDayOfMonthOverload.TIMESTAMP_TO_DAY_OF_MONTH::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_MONTH_WITH_TZ(GetDayOfMonthFunction.GetDayOfMonthOverload.TIMESTAMP_TO_DAY_OF_MONTH_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_MONTH_1_BASED(GetDateFunction.GetDateOverload.TIMESTAMP_TO_DAY_OF_MONTH_1_BASED::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_MONTH_1_BASED_WITH_TZ(GetDateFunction.GetDateOverload.TIMESTAMP_TO_DAY_OF_MONTH_1_BASED_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_WEEK(GetDayOfWeekFunction.GetDayOfWeekOverload.TIMESTAMP_TO_DAY_OF_WEEK::newFunctionBinding),
                TIMESTAMP_TO_DAY_OF_WEEK_WITH_TZ(GetDayOfWeekFunction.GetDayOfWeekOverload.TIMESTAMP_TO_DAY_OF_WEEK_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_HOURS(GetHoursFunction.GetHoursOverload.TIMESTAMP_TO_HOURS::newFunctionBinding),
                TIMESTAMP_TO_HOURS_WITH_TZ(GetHoursFunction.GetHoursOverload.TIMESTAMP_TO_HOURS_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_MINUTES(GetMinutesFunction.GetMinutesOverload.TIMESTAMP_TO_MINUTES::newFunctionBinding),
                TIMESTAMP_TO_MINUTES_WITH_TZ(GetMinutesFunction.GetMinutesOverload.TIMESTAMP_TO_MINUTES_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_SECONDS(GetSecondsFunction.GetSecondsOverload.TIMESTAMP_TO_SECONDS::newFunctionBinding),
                TIMESTAMP_TO_SECONDS_WITH_TZ(GetSecondsFunction.GetSecondsOverload.TIMESTAMP_TO_SECONDS_WITH_TZ::newFunctionBinding),
                TIMESTAMP_TO_MILLISECONDS(GetMillisecondsFunction.GetMillisecondsOverload.TIMESTAMP_TO_MILLISECONDS::newFunctionBinding),
                TIMESTAMP_TO_MILLISECONDS_WITH_TZ(GetMillisecondsFunction.GetMillisecondsOverload.TIMESTAMP_TO_MILLISECONDS_WITH_TZ::newFunctionBinding),
                DURATION_TO_HOURS(GetHoursFunction.GetHoursOverload.DURATION_TO_HOURS::newFunctionBinding),
                DURATION_TO_MINUTES(GetMinutesFunction.GetMinutesOverload.DURATION_TO_MINUTES::newFunctionBinding),
                DURATION_TO_SECONDS(GetSecondsFunction.GetSecondsOverload.DURATION_TO_SECONDS::newFunctionBinding),
                DURATION_TO_MILLISECONDS(GetMillisecondsFunction.GetMillisecondsOverload.DURATION_TO_MILLISECONDS::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private DateTime(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum BooleanOperator implements StandardOverload
            {
                LOGICAL_NOT(LogicalNotOperator.LogicalNotOverload.LOGICAL_NOT::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private BooleanOperator(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum StringMatchers implements StandardOverload
            {
                MATCHES(MatchesFunction.MatchesOverload.MATCHES::newFunctionBinding),
                MATCHES_STRING(MatchesFunction.MatchesOverload.MATCHES_STRING::newFunctionBinding),
                CONTAINS_STRING(ContainsFunction.ContainsOverload.CONTAINS_STRING::newFunctionBinding),
                ENDS_WITH_STRING(EndsWithFunction.EndsWithOverload.ENDS_WITH_STRING::newFunctionBinding),
                STARTS_WITH_STRING(StartsWithFunction.StartsWithOverload.STARTS_WITH_STRING::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private StringMatchers(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum Conversions implements StandardOverload
            {
                BOOL_TO_BOOL(BoolFunction.BoolOverload.BOOL_TO_BOOL::newFunctionBinding),
                STRING_TO_BOOL(BoolFunction.BoolOverload.STRING_TO_BOOL::newFunctionBinding),
                INT64_TO_INT64(IntFunction.IntOverload.INT64_TO_INT64::newFunctionBinding),
                DOUBLE_TO_INT64(IntFunction.IntOverload.DOUBLE_TO_INT64::newFunctionBinding),
                STRING_TO_INT64(IntFunction.IntOverload.STRING_TO_INT64::newFunctionBinding),
                TIMESTAMP_TO_INT64(IntFunction.IntOverload.TIMESTAMP_TO_INT64::newFunctionBinding),
                UINT64_TO_INT64(IntFunction.IntOverload.UINT64_TO_INT64::newFunctionBinding),
                UINT64_TO_UINT64(UintFunction.UintOverload.UINT64_TO_UINT64::newFunctionBinding),
                INT64_TO_UINT64(UintFunction.UintOverload.INT64_TO_UINT64::newFunctionBinding),
                DOUBLE_TO_UINT64(UintFunction.UintOverload.DOUBLE_TO_UINT64::newFunctionBinding),
                STRING_TO_UINT64(UintFunction.UintOverload.STRING_TO_UINT64::newFunctionBinding),
                DOUBLE_TO_DOUBLE(DoubleFunction.DoubleOverload.DOUBLE_TO_DOUBLE::newFunctionBinding),
                INT64_TO_DOUBLE(DoubleFunction.DoubleOverload.INT64_TO_DOUBLE::newFunctionBinding),
                STRING_TO_DOUBLE(DoubleFunction.DoubleOverload.STRING_TO_DOUBLE::newFunctionBinding),
                UINT64_TO_DOUBLE(DoubleFunction.DoubleOverload.UINT64_TO_DOUBLE::newFunctionBinding),
                STRING_TO_STRING(StringFunction.StringOverload.STRING_TO_STRING::newFunctionBinding),
                INT64_TO_STRING(StringFunction.StringOverload.INT64_TO_STRING::newFunctionBinding),
                DOUBLE_TO_STRING(StringFunction.StringOverload.DOUBLE_TO_STRING::newFunctionBinding),
                BOOL_TO_STRING(StringFunction.StringOverload.BOOL_TO_STRING::newFunctionBinding),
                BYTES_TO_STRING(StringFunction.StringOverload.BYTES_TO_STRING::newFunctionBinding),
                TIMESTAMP_TO_STRING(StringFunction.StringOverload.TIMESTAMP_TO_STRING::newFunctionBinding),
                DURATION_TO_STRING(StringFunction.StringOverload.DURATION_TO_STRING::newFunctionBinding),
                UINT64_TO_STRING(StringFunction.StringOverload.UINT64_TO_STRING::newFunctionBinding),
                BYTES_TO_BYTES(BytesFunction.BytesOverload.BYTES_TO_BYTES::newFunctionBinding),
                STRING_TO_BYTES(BytesFunction.BytesOverload.STRING_TO_BYTES::newFunctionBinding),
                DURATION_TO_DURATION(DurationFunction.DurationOverload.DURATION_TO_DURATION::newFunctionBinding),
                STRING_TO_DURATION(DurationFunction.DurationOverload.STRING_TO_DURATION::newFunctionBinding),
                STRING_TO_TIMESTAMP(TimestampFunction.TimestampOverload.STRING_TO_TIMESTAMP::newFunctionBinding),
                TIMESTAMP_TO_TIMESTAMP(TimestampFunction.TimestampOverload.TIMESTAMP_TO_TIMESTAMP::newFunctionBinding),
                INT64_TO_TIMESTAMP(TimestampFunction.TimestampOverload.INT64_TO_TIMESTAMP::newFunctionBinding),
                TO_DYN(DynFunction.DynOverload.TO_DYN::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Conversions(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum Size implements StandardOverload
            {
                SIZE_BYTES(SizeFunction.SizeOverload.SIZE_BYTES::newFunctionBinding),
                BYTES_SIZE(SizeFunction.SizeOverload.BYTES_SIZE::newFunctionBinding),
                SIZE_LIST(SizeFunction.SizeOverload.SIZE_LIST::newFunctionBinding),
                LIST_SIZE(SizeFunction.SizeOverload.LIST_SIZE::newFunctionBinding),
                SIZE_STRING(SizeFunction.SizeOverload.SIZE_STRING::newFunctionBinding),
                STRING_SIZE(SizeFunction.SizeOverload.STRING_SIZE::newFunctionBinding),
                SIZE_MAP(SizeFunction.SizeOverload.SIZE_MAP::newFunctionBinding),
                MAP_SIZE(SizeFunction.SizeOverload.MAP_SIZE::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Size(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum Index implements StandardOverload
            {
                INDEX_LIST(IndexOperator.IndexOverload.INDEX_LIST::newFunctionBinding),
                INDEX_MAP(IndexOperator.IndexOverload.INDEX_MAP::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Index(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum Arithmetic implements StandardOverload
            {
                ADD_INT64(AddOperator.AddOverload.ADD_INT64::newFunctionBinding),
                ADD_UINT64(AddOperator.AddOverload.ADD_UINT64::newFunctionBinding),
                ADD_BYTES(AddOperator.AddOverload.ADD_BYTES::newFunctionBinding),
                ADD_DOUBLE(AddOperator.AddOverload.ADD_DOUBLE::newFunctionBinding),
                ADD_DURATION_DURATION(AddOperator.AddOverload.ADD_DURATION_DURATION::newFunctionBinding),
                ADD_TIMESTAMP_DURATION(AddOperator.AddOverload.ADD_TIMESTAMP_DURATION::newFunctionBinding),
                ADD_STRING(AddOperator.AddOverload.ADD_STRING::newFunctionBinding),
                ADD_DURATION_TIMESTAMP(AddOperator.AddOverload.ADD_DURATION_TIMESTAMP::newFunctionBinding),
                ADD_LIST(AddOperator.AddOverload.ADD_LIST::newFunctionBinding),
                SUBTRACT_INT64(SubtractOperator.SubtractOverload.SUBTRACT_INT64::newFunctionBinding),
                SUBTRACT_TIMESTAMP_TIMESTAMP(SubtractOperator.SubtractOverload.SUBTRACT_TIMESTAMP_TIMESTAMP::newFunctionBinding),
                SUBTRACT_TIMESTAMP_DURATION(SubtractOperator.SubtractOverload.SUBTRACT_TIMESTAMP_DURATION::newFunctionBinding),
                SUBTRACT_UINT64(SubtractOperator.SubtractOverload.SUBTRACT_UINT64::newFunctionBinding),
                SUBTRACT_DOUBLE(SubtractOperator.SubtractOverload.SUBTRACT_DOUBLE::newFunctionBinding),
                SUBTRACT_DURATION_DURATION(SubtractOperator.SubtractOverload.SUBTRACT_DURATION_DURATION::newFunctionBinding),
                MULTIPLY_INT64(MultiplyOperator.MultiplyOverload.MULTIPLY_INT64::newFunctionBinding),
                MULTIPLY_DOUBLE(MultiplyOperator.MultiplyOverload.MULTIPLY_DOUBLE::newFunctionBinding),
                MULTIPLY_UINT64(MultiplyOperator.MultiplyOverload.MULTIPLY_UINT64::newFunctionBinding),
                DIVIDE_DOUBLE(DivideOperator.DivideOverload.DIVIDE_DOUBLE::newFunctionBinding),
                DIVIDE_INT64(DivideOperator.DivideOverload.DIVIDE_INT64::newFunctionBinding),
                DIVIDE_UINT64(DivideOperator.DivideOverload.DIVIDE_UINT64::newFunctionBinding),
                MODULO_INT64(ModuloOperator.ModuloOverload.MODULO_INT64::newFunctionBinding),
                MODULO_UINT64(ModuloOperator.ModuloOverload.MODULO_UINT64::newFunctionBinding),
                NEGATE_INT64(NegateOperator.NegateOverload.NEGATE_INT64::newFunctionBinding),
                NEGATE_DOUBLE(NegateOperator.NegateOverload.NEGATE_DOUBLE::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Arithmetic(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum Relation implements StandardOverload
            {
                EQUALS(EqualsOperator.EqualsOverload.EQUALS::newFunctionBinding),
                NOT_EQUALS(NotEqualsOperator.NotEqualsOverload.NOT_EQUALS::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private Relation(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }

            public static enum InternalOperator implements StandardOverload
            {
                IN_LIST(InOperator.InOverload.IN_LIST::newFunctionBinding),
                IN_MAP(InOperator.InOverload.IN_MAP::newFunctionBinding);

                private final FunctionBindingCreator bindingCreator;

                @Override
                public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
                    return this.bindingCreator.create(celOptions, runtimeEquality);
                }

                private InternalOperator(FunctionBindingCreator bindingCreator) {
                    this.bindingCreator = bindingCreator;
                }
            }
        }
    }
}

