/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageOrBuilder;
import dev.cel.common.types.CelType;
import dev.cel.common.types.StructTypeReference;
import dev.cel.common.types.TypeType;
import dev.cel.runtime.TypeResolver;
import java.util.Optional;

@Immutable
final class DescriptorTypeResolver
extends TypeResolver {
    static DescriptorTypeResolver create() {
        return new DescriptorTypeResolver();
    }

    @Override
    TypeType resolveObjectType(Object obj, CelType typeCheckedType) {
        Preconditions.checkNotNull(obj);
        Optional<TypeType> wellKnownTypeType = this.resolveWellKnownObjectType(obj);
        if (wellKnownTypeType.isPresent()) {
            return wellKnownTypeType.get();
        }
        if (obj instanceof MessageOrBuilder) {
            MessageOrBuilder msg = (MessageOrBuilder)obj;
            return TypeType.create(StructTypeReference.create(msg.getDescriptorForType().getFullName()));
        }
        return super.resolveObjectType(obj, typeCheckedType);
    }

    private DescriptorTypeResolver() {
    }
}

