/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelUnknownSet;
import java.util.LinkedHashSet;
import org.jspecify.annotations.Nullable;

@Internal
public final class InterpreterUtil {
    @CheckReturnValue
    public static Object strict(Object valueOrThrowable) throws CelEvaluationException {
        if (!(valueOrThrowable instanceof Throwable)) {
            return valueOrThrowable;
        }
        if (valueOrThrowable instanceof CelEvaluationException) {
            throw (CelEvaluationException)valueOrThrowable;
        }
        if (valueOrThrowable instanceof RuntimeException) {
            throw (RuntimeException)valueOrThrowable;
        }
        throw new RuntimeException((Throwable)valueOrThrowable);
    }

    public static boolean isUnknown(Object obj) {
        return obj instanceof CelUnknownSet;
    }

    static CelUnknownSet combineUnknownExprValue(Object ... objs) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        for (Object object : objs) {
            if (!InterpreterUtil.isUnknown(object)) continue;
            ids.addAll(((CelUnknownSet)object).unknownExprIds());
        }
        return CelUnknownSet.create(ids);
    }

    public static Object shortcircuitUnknownOrThrowable(Object left, Object right) throws CelEvaluationException {
        if (InterpreterUtil.isUnknown(left) && InterpreterUtil.isUnknown(right)) {
            return InterpreterUtil.combineUnknownExprValue(left, right);
        }
        if (InterpreterUtil.isUnknown(left)) {
            return left;
        }
        if (InterpreterUtil.isUnknown(right)) {
            return right;
        }
        if (left instanceof Throwable) {
            return InterpreterUtil.strict(left);
        }
        if (right instanceof Throwable) {
            return InterpreterUtil.strict(right);
        }
        throw new RuntimeException("Left or/and right object is neither bool, unknown nor error, unexpected behavior.");
    }

    public static Object valueOrUnknown(@Nullable Object valueOrThrowable, Long id) {
        if (InterpreterUtil.isUnknown(valueOrThrowable)) {
            return CelUnknownSet.create(id);
        }
        if (valueOrThrowable == null) {
            return CelUnknownSet.create(id);
        }
        return valueOrThrowable;
    }

    private InterpreterUtil() {
    }
}

