/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Message;
import dev.cel.common.CelOptions;
import dev.cel.runtime.Activation;
import dev.cel.runtime.AutoValue_ProgramImpl;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationListener;
import dev.cel.runtime.CelFunctionResolver;
import dev.cel.runtime.CelRuntime;
import dev.cel.runtime.CelVariableResolver;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.Interpretable;
import dev.cel.runtime.ProtoMessageActivationFactory;
import dev.cel.runtime.RuntimeUnknownResolver;
import dev.cel.runtime.UnknownContext;
import dev.cel.runtime.UnknownTrackingInterpretable;
import java.util.Map;
import java.util.Optional;

@Immutable
@AutoValue
abstract class ProgramImpl
implements CelRuntime.Program {
    ProgramImpl() {
    }

    @Override
    public Object eval() throws CelEvaluationException {
        return this.evalInternal(Activation.EMPTY);
    }

    @Override
    public Object eval(Map<String, ?> mapValue) throws CelEvaluationException {
        return this.evalInternal(Activation.copyOf(mapValue));
    }

    @Override
    public Object eval(Message message) throws CelEvaluationException {
        return this.evalInternal(ProtoMessageActivationFactory.fromProto(message, this.getOptions()));
    }

    @Override
    public Object eval(CelVariableResolver resolver) throws CelEvaluationException {
        return this.evalInternal(name -> resolver.find(name).orElse(null));
    }

    @Override
    public Object eval(CelVariableResolver resolver, CelFunctionResolver lateBoundFunctionResolver) throws CelEvaluationException {
        return this.evalInternal((String name) -> resolver.find(name).orElse(null), lateBoundFunctionResolver, CelEvaluationListener.noOpListener());
    }

    @Override
    public Object eval(Map<String, ?> mapValue, CelFunctionResolver lateBoundFunctionResolver) throws CelEvaluationException {
        return this.evalInternal(Activation.copyOf(mapValue), lateBoundFunctionResolver, CelEvaluationListener.noOpListener());
    }

    @Override
    public Object trace(CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(Activation.EMPTY, listener);
    }

    @Override
    public Object trace(Map<String, ?> mapValue, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(Activation.copyOf(mapValue), listener);
    }

    @Override
    public Object trace(Message message, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(ProtoMessageActivationFactory.fromProto(message, this.getOptions()), listener);
    }

    @Override
    public Object trace(CelVariableResolver resolver, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(name -> resolver.find(name).orElse(null), listener);
    }

    @Override
    public Object trace(CelVariableResolver resolver, CelFunctionResolver lateBoundFunctionResolver, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal((String name) -> resolver.find(name).orElse(null), lateBoundFunctionResolver, listener);
    }

    @Override
    public Object trace(Map<String, ?> mapValue, CelFunctionResolver lateBoundFunctionResolver, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(Activation.copyOf(mapValue), lateBoundFunctionResolver, listener);
    }

    @Override
    public Object advanceEvaluation(UnknownContext context) throws CelEvaluationException {
        return this.evalInternal(context, Optional.empty(), CelEvaluationListener.noOpListener());
    }

    private Object evalInternal(GlobalResolver resolver) throws CelEvaluationException {
        return this.evalInternal(UnknownContext.create(resolver), Optional.empty(), CelEvaluationListener.noOpListener());
    }

    private Object evalInternal(GlobalResolver resolver, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(UnknownContext.create(resolver), Optional.empty(), listener);
    }

    private Object evalInternal(GlobalResolver resolver, CelFunctionResolver lateBoundFunctionResolver, CelEvaluationListener listener) throws CelEvaluationException {
        return this.evalInternal(UnknownContext.create(resolver), Optional.of(lateBoundFunctionResolver), listener);
    }

    private Object evalInternal(UnknownContext context, Optional<CelFunctionResolver> lateBoundFunctionResolver, CelEvaluationListener listener) throws CelEvaluationException {
        Interpretable impl = this.getInterpretable();
        if (this.getOptions().enableUnknownTracking()) {
            Preconditions.checkState(impl instanceof UnknownTrackingInterpretable, "Environment misconfigured. Requested unknown tracking without a compatible implementation.");
            UnknownTrackingInterpretable interpreter = (UnknownTrackingInterpretable)((Object)impl);
            return interpreter.evalTrackingUnknowns(RuntimeUnknownResolver.builder().setResolver(context.variableResolver()).setAttributeResolver(context.createAttributeResolver()).build(), lateBoundFunctionResolver, listener);
        }
        if (lateBoundFunctionResolver.isPresent()) {
            return impl.eval(context.variableResolver(), lateBoundFunctionResolver.get(), listener);
        }
        return impl.eval(context.variableResolver(), listener);
    }

    abstract Interpretable getInterpretable();

    abstract CelOptions getOptions();

    static CelRuntime.Program from(Interpretable interpretable, CelOptions options) {
        return new AutoValue_ProgramImpl(interpretable, options);
    }
}

