/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoAdapter;
import dev.cel.runtime.Activation;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationExceptionBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class ProtoMessageActivationFactory {
    public static Activation fromProto(Message message, CelOptions celOptions) {
        HashMap<String, CelEvaluationException> variables = new HashMap<String, CelEvaluationException>();
        Map<Descriptors.FieldDescriptor, Object> msgFieldValues = message.getAllFields();
        ProtoAdapter protoAdapter = new ProtoAdapter(DynamicProto.create(DefaultMessageFactory.INSTANCE), celOptions.enableUnsignedLongs());
        boolean skipUnsetFields = celOptions.fromProtoUnsetFieldOption().equals((Object)CelOptions.ProtoUnsetFieldOptions.SKIP);
        for (Descriptors.FieldDescriptor field : message.getDescriptorForType().getFields()) {
            if (skipUnsetFields && !field.isRepeated() && !msgFieldValues.containsKey(field)) continue;
            Object fieldValue = msgFieldValues.getOrDefault(field, message.getField(field));
            try {
                Optional<Object> adapted = protoAdapter.adaptFieldToValue(field, fieldValue);
                variables.put(field.getName(), adapted.orElse(null));
            }
            catch (IllegalArgumentException e) {
                variables.put(field.getName(), CelEvaluationExceptionBuilder.newBuilder("illegal field value. field=%s, value=%s", field.getName(), fieldValue).setCause(e).build());
            }
        }
        return Activation.copyOf(variables);
    }

    private ProtoMessageActivationFactory() {
    }
}

